/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.ImmutableHolidayCalendarDeserializer;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.tuple.Pair;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;
import org.joda.beans.ser.SerDeserializer;

@BeanDefinition(builderScope="private")
public final class ImmutableHolidayCalendar
implements HolidayCalendar,
ImmutableBean,
Serializable {
    public static final SerDeserializer DESERIALIZER = new ImmutableHolidayCalendarDeserializer();
    private static final long serialVersionUID = 2L;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final HolidayCalendarId id;
    @PropertyDefinition(get="")
    private final int weekends;
    @PropertyDefinition(get="")
    private final int startYear;
    @PropertyDefinition(validate="notNull", get="")
    private final int[] lookup;

    public static ImmutableHolidayCalendar of(HolidayCalendarId id, Iterable<LocalDate> holidays, DayOfWeek firstWeekendDay, DayOfWeek secondWeekendDay) {
        ImmutableSet weekendDays = Sets.immutableEnumSet((Enum)firstWeekendDay, (Enum[])new DayOfWeek[]{secondWeekendDay});
        return ImmutableHolidayCalendar.of(id, (SortedSet<LocalDate>)ImmutableSortedSet.copyOf(holidays), (Set<DayOfWeek>)weekendDays, (Iterable<LocalDate>)ImmutableSet.of());
    }

    public static ImmutableHolidayCalendar of(HolidayCalendarId id, Iterable<LocalDate> holidays, Iterable<DayOfWeek> weekendDays) {
        return ImmutableHolidayCalendar.of(id, (SortedSet<LocalDate>)ImmutableSortedSet.copyOf(holidays), (Set<DayOfWeek>)Sets.immutableEnumSet(weekendDays), (Iterable<LocalDate>)ImmutableSet.of());
    }

    public static ImmutableHolidayCalendar of(HolidayCalendarId id, Iterable<LocalDate> holidays, Iterable<DayOfWeek> weekendDays, Iterable<LocalDate> workingDays) {
        return ImmutableHolidayCalendar.of(id, (SortedSet<LocalDate>)ImmutableSortedSet.copyOf(holidays), (Set<DayOfWeek>)Sets.immutableEnumSet(weekendDays), (Iterable<LocalDate>)((Iterable)ArgChecker.notNull(workingDays, (String)"workingDays")));
    }

    public static ImmutableHolidayCalendar combined(ImmutableHolidayCalendar cal1, ImmutableHolidayCalendar cal2) {
        if (cal1 == cal2) {
            return (ImmutableHolidayCalendar)ArgChecker.notNull((Object)cal1, (String)"cal1");
        }
        HolidayCalendarId newId = cal1.id.combinedWith(cal2.id);
        int endYear1 = cal1.startYear + cal1.lookup.length / 12;
        int endYear2 = cal2.startYear + cal2.lookup.length / 12;
        if (endYear1 < cal2.startYear || endYear2 < cal1.startYear) {
            Pair<ImmutableSortedSet<LocalDate>, ImmutableSortedSet<LocalDate>> holsWork1 = cal1.getHolidaysAndWorkingDays();
            Pair<ImmutableSortedSet<LocalDate>, ImmutableSortedSet<LocalDate>> holsWork2 = cal2.getHolidaysAndWorkingDays();
            ImmutableSortedSet newHolidays = ImmutableSortedSet.copyOf((Iterable)Iterables.concat((Iterable)((Iterable)holsWork1.getFirst()), (Iterable)((Iterable)holsWork2.getFirst())));
            ImmutableSet newWeekends = ImmutableSet.copyOf((Iterable)Iterables.concat(cal1.getWeekendDays(), cal2.getWeekendDays()));
            ImmutableSet newWorkingDays = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)((Iterable)holsWork1.getSecond()), (Iterable)((Iterable)holsWork2.getSecond())));
            return ImmutableHolidayCalendar.of(newId, (SortedSet<LocalDate>)newHolidays, (Set<DayOfWeek>)newWeekends, (Iterable<LocalDate>)newWorkingDays);
        }
        boolean cal1Lower = cal1.startYear <= cal2.startYear;
        int[] lookup1 = cal1Lower ? cal1.lookup : cal2.lookup;
        int[] lookup2 = cal1Lower ? cal2.lookup : cal1.lookup;
        int newStartYear = cal1Lower ? cal1.startYear : cal2.startYear;
        int otherStartYear = cal1Lower ? cal2.startYear : cal1.startYear;
        int newSize = Math.max(lookup1.length, lookup2.length + (otherStartYear - newStartYear) * 12);
        int offset = (otherStartYear - newStartYear) * 12;
        int[] newLookup = Arrays.copyOf(lookup1, newSize);
        for (int i = 0; i < lookup2.length; ++i) {
            int n = i + offset;
            newLookup[n] = newLookup[n] & lookup2[i];
        }
        int newWeekends = cal1.weekends | cal2.weekends;
        return new ImmutableHolidayCalendar(newId, newWeekends, newStartYear, newLookup, false);
    }

    static ImmutableHolidayCalendar of(HolidayCalendarId id, SortedSet<LocalDate> holidays, Set<DayOfWeek> weekendDays, Iterable<LocalDate> workingDays) {
        ArgChecker.notNull((Object)id, (String)"id");
        int weekends = weekendDays.stream().mapToInt(dow -> 1 << dow.getValue() - 1).sum();
        int startYear = 0;
        int[] lookup = new int[]{};
        if (!holidays.isEmpty()) {
            startYear = holidays.first().getYear();
            int endYearExclusive = holidays.last().getYear() + 1;
            lookup = ImmutableHolidayCalendar.buildLookupArray(holidays, weekendDays, startYear, endYearExclusive, workingDays);
        }
        return new ImmutableHolidayCalendar(id, weekends, startYear, lookup);
    }

    private static int[] buildLookupArray(Iterable<LocalDate> holidays, Iterable<DayOfWeek> weekendDays, int startYear, int endYearExclusive, Iterable<LocalDate> workingDays) {
        int[] array = new int[(endYearExclusive - startYear) * 12];
        LocalDate firstOfMonth = LocalDate.of(startYear, 1, 1);
        for (int i = 0; i < array.length; ++i) {
            int monthLen = firstOfMonth.lengthOfMonth();
            array[i] = (1 << monthLen) - 1;
            for (DayOfWeek weekendDow : weekendDays) {
                int daysDiff = weekendDow.getValue() - firstOfMonth.getDayOfWeek().getValue();
                int offset = daysDiff < 0 ? daysDiff + 7 : daysDiff;
                int n = i;
                array[n] = array[n] & ~(270549121 << offset);
            }
            firstOfMonth = firstOfMonth.plusMonths(1L);
        }
        for (LocalDate date : holidays) {
            int index;
            int n = index = (date.getYear() - startYear) * 12 + date.getMonthValue() - 1;
            array[n] = array[n] & ~(1 << date.getDayOfMonth() - 1);
        }
        for (LocalDate date : workingDays) {
            int index;
            if (date.getYear() < startYear || date.getYear() >= endYearExclusive) continue;
            int n = index = (date.getYear() - startYear) * 12 + date.getMonthValue() - 1;
            array[n] = array[n] | 1 << date.getDayOfMonth() - 1;
        }
        return array;
    }

    void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.id.getName());
        out.writeShort(this.weekends);
        out.writeShort(this.startYear);
        out.writeShort(this.lookup.length);
        for (int i = 0; i < this.lookup.length; ++i) {
            out.writeInt(this.lookup[i]);
        }
    }

    static ImmutableHolidayCalendar readExternal(DataInput in) throws IOException {
        String id = in.readUTF();
        short weekendDays = in.readShort();
        short startYear = in.readShort();
        int lookupSize = in.readShort();
        byte[] bytes = new byte[lookupSize * 4];
        int[] lookup = new int[lookupSize];
        in.readFully(bytes);
        int offset = 0;
        for (int i = 0; i < lookupSize; ++i) {
            lookup[i] = (bytes[offset++] & 0xFF) << 24 | (bytes[offset++] & 0xFF) << 16 | (bytes[offset++] & 0xFF) << 8 | bytes[offset++] & 0xFF;
        }
        return new ImmutableHolidayCalendar(HolidayCalendarId.of(id), (int)weekendDays, (int)startYear, lookup, false);
    }

    ImmutableHolidayCalendar(HolidayCalendarId id, int weekendDays, int startYear, int[] lookup, boolean flag) {
        this.id = (HolidayCalendarId)ArgChecker.notNull((Object)id, (String)"id");
        this.weekends = weekendDays;
        this.startYear = startYear;
        this.lookup = (int[])ArgChecker.notNull((Object)lookup, (String)"lookup");
    }

    @VisibleForTesting
    ImmutableSortedSet<LocalDate> getHolidays() {
        return (ImmutableSortedSet)this.getHolidaysAndWorkingDays().getFirst();
    }

    @VisibleForTesting
    ImmutableSet<DayOfWeek> getWeekendDays() {
        return (ImmutableSet)Stream.of(DayOfWeek.values()).filter(dow -> (this.weekends & 1 << dow.ordinal()) != 0).collect(Guavate.toImmutableSet());
    }

    @VisibleForTesting
    ImmutableSortedSet<LocalDate> getWorkingDays() {
        return (ImmutableSortedSet)this.getHolidaysAndWorkingDays().getSecond();
    }

    private Pair<ImmutableSortedSet<LocalDate>, ImmutableSortedSet<LocalDate>> getHolidaysAndWorkingDays() {
        if (this.startYear == 0) {
            return Pair.of((Object)ImmutableSortedSet.of(), (Object)ImmutableSortedSet.of());
        }
        ImmutableSortedSet.Builder holidays = ImmutableSortedSet.naturalOrder();
        ImmutableSortedSet.Builder workingDays = ImmutableSortedSet.naturalOrder();
        LocalDate firstOfMonth = LocalDate.of(this.startYear, 1, 1);
        for (int i = 0; i < this.lookup.length; ++i) {
            int monthData = this.lookup[i];
            int monthLen = firstOfMonth.lengthOfMonth();
            int dow0 = firstOfMonth.getDayOfWeek().ordinal();
            int bit = 1;
            for (int j = 0; j < monthLen; ++j) {
                if ((monthData & bit) == 0 && (this.weekends & 1 << dow0) == 0) {
                    holidays.add((Object)firstOfMonth.withDayOfMonth(j + 1));
                }
                if ((monthData & bit) != 0 && (this.weekends & 1 << dow0) != 0) {
                    workingDays.add((Object)firstOfMonth.withDayOfMonth(j + 1));
                }
                dow0 = (dow0 + 1) % 7;
                bit <<= 1;
            }
            firstOfMonth = firstOfMonth.plusMonths(1L);
        }
        return Pair.of((Object)holidays.build(), (Object)workingDays.build());
    }

    @Override
    public boolean isHoliday(LocalDate date) {
        try {
            int index = (date.getYear() - this.startYear) * 12 + date.getMonthValue() - 1;
            return (this.lookup[index] & 1 << date.getDayOfMonth() - 1) == 0;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.isHolidayOutOfRange(date);
        }
    }

    private boolean isHolidayOutOfRange(LocalDate date) {
        if (date.getYear() >= 0 && date.getYear() < 10000) {
            return (this.weekends & 1 << date.getDayOfWeek().ordinal()) != 0;
        }
        throw new IllegalArgumentException("Date is outside the accepted range (year 0000 to 10,000): " + date);
    }

    @Override
    public LocalDate shift(LocalDate date, int amount) {
        try {
            if (amount > 0) {
                return this.shiftNext(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), amount);
            }
            if (amount < 0) {
                return this.shiftPrev(date.getYear(), date.getMonthValue(), date.getDayOfMonth() - 1, amount);
            }
            return date;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.shiftOutOfRange(date, amount);
        }
    }

    private LocalDate shiftOutOfRange(LocalDate date, int amount) {
        if (date.getYear() >= 0 && date.getYear() < 10000) {
            return HolidayCalendar.super.shift(date, amount);
        }
        throw new IllegalArgumentException("Date is outside the accepted range (year 0000 to 10,000): " + date);
    }

    @Override
    public LocalDate next(LocalDate date) {
        try {
            return this.shiftNext(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 1);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return HolidayCalendar.super.next(date);
        }
    }

    private LocalDate shiftNext(int baseYear, int baseMonth, int baseDom0, int amount) {
        int index = (baseYear - this.startYear) * 12 + baseMonth - 1;
        int monthData = this.lookup[index];
        int domOffset = baseDom0;
        for (int amt = amount; amt > 0; --amt) {
            int shifted = monthData >>> domOffset;
            if (shifted == 0) {
                return baseMonth == 12 ? this.shiftNext(baseYear + 1, 1, 0, amt) : this.shiftNext(baseYear, baseMonth + 1, 0, amt);
            }
            domOffset += Integer.numberOfTrailingZeros(shifted) + 1;
        }
        return LocalDate.of(baseYear, baseMonth, domOffset);
    }

    @Override
    public LocalDate previous(LocalDate date) {
        try {
            return this.shiftPrev(date.getYear(), date.getMonthValue(), date.getDayOfMonth() - 1, -1);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.previousOutOfRange(date);
        }
    }

    private LocalDate shiftPrev(int baseYear, int baseMonth, int baseDom, int amount) {
        int index = (baseYear - this.startYear) * 12 + baseMonth - 1;
        int monthData = this.lookup[index];
        int domOffset = baseDom;
        for (int amt = amount; amt < 0; ++amt) {
            int shifted = monthData << 32 - domOffset;
            if (shifted == 0 || domOffset <= 0) {
                return baseMonth == 1 ? this.shiftPrev(baseYear - 1, 12, 31, amt) : this.shiftPrev(baseYear, baseMonth - 1, 31, amt);
            }
            domOffset -= Integer.numberOfLeadingZeros(shifted) + 1;
        }
        return LocalDate.of(baseYear, baseMonth, domOffset + 1);
    }

    private LocalDate previousOutOfRange(LocalDate date) {
        if (date.getYear() >= 0 && date.getYear() < 10000) {
            return HolidayCalendar.super.previous(date);
        }
        throw new IllegalArgumentException("Date is outside the accepted range (year 0000 to 10,000): " + date);
    }

    @Override
    public LocalDate nextSameOrLastInMonth(LocalDate date) {
        try {
            return this.shiftNextSameLast(date);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return HolidayCalendar.super.nextSameOrLastInMonth(date);
        }
    }

    private LocalDate shiftNextSameLast(LocalDate baseDate) {
        int dom;
        int baseDom;
        int baseMonth;
        int baseYear = baseDate.getYear();
        int index = (baseYear - this.startYear) * 12 + (baseMonth = baseDate.getMonthValue()) - 1;
        int monthData = this.lookup[index];
        int shifted = monthData >>> (baseDom = baseDate.getDayOfMonth()) - 1;
        if (shifted == 0) {
            int leading = Integer.numberOfLeadingZeros(monthData);
            dom = 32 - leading;
        } else {
            dom = baseDom + Integer.numberOfTrailingZeros(shifted);
        }
        return baseDate.withDayOfMonth(dom);
    }

    @Override
    public boolean isLastBusinessDayOfMonth(LocalDate date) {
        try {
            int index = (date.getYear() - this.startYear) * 12 + date.getMonthValue() - 1;
            return this.lookup[index] >>> date.getDayOfMonth() - 1 == 1;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.isLastBusinessDayOfMonthOutOfRange(date);
        }
    }

    private boolean isLastBusinessDayOfMonthOutOfRange(LocalDate date) {
        if (date.getYear() >= 0 && date.getYear() < 10000) {
            return HolidayCalendar.super.isLastBusinessDayOfMonth(date);
        }
        throw new IllegalArgumentException("Date is outside the accepted range (year 0000 to 10,000): " + date);
    }

    @Override
    public LocalDate lastBusinessDayOfMonth(LocalDate date) {
        try {
            int index = (date.getYear() - this.startYear) * 12 + date.getMonthValue() - 1;
            int leading = Integer.numberOfLeadingZeros(this.lookup[index]);
            return date.withDayOfMonth(32 - leading);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.lastBusinessDayOfMonthOutOfRange(date);
        }
    }

    private LocalDate lastBusinessDayOfMonthOutOfRange(LocalDate date) {
        if (date.getYear() >= 0 && date.getYear() < 10000) {
            return HolidayCalendar.super.lastBusinessDayOfMonth(date);
        }
        throw new IllegalArgumentException("Date is outside the accepted range (year 0000 to 10,000): " + date);
    }

    @Override
    public int daysBetween(LocalDate startInclusive, LocalDate endExclusive) {
        ArgChecker.inOrderOrEqual((Comparable)startInclusive, (Object)endExclusive, (String)"startInclusive", (String)"endExclusive");
        try {
            int startIndex = (startInclusive.getYear() - this.startYear) * 12 + startInclusive.getMonthValue() - 1;
            int endIndex = (endExclusive.getYear() - this.startYear) * 12 + endExclusive.getMonthValue() - 1;
            int start = Integer.bitCount(this.lookup[startIndex] >>> startInclusive.getDayOfMonth() - 1);
            int missingEnd = Integer.bitCount(this.lookup[endIndex] >>> endExclusive.getDayOfMonth() - 1);
            if (startIndex == endIndex) {
                return start - missingEnd;
            }
            int end = Integer.bitCount(this.lookup[endIndex]) - missingEnd;
            int count = start + end;
            for (int i = startIndex + 1; i < endIndex; ++i) {
                count += Integer.bitCount(this.lookup[i]);
            }
            return count;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.daysBetweenOutOfRange(startInclusive, endExclusive);
        }
    }

    private int daysBetweenOutOfRange(LocalDate startInclusive, LocalDate endExclusive) {
        if (startInclusive.getYear() >= 0 && startInclusive.getYear() < 10000 && endExclusive.getYear() >= 0 && endExclusive.getYear() < 10000) {
            return HolidayCalendar.super.daysBetween(startInclusive, endExclusive);
        }
        throw new IllegalArgumentException(Messages.format((String)"Dates are outside the accepted range (year 0000 to 10,000): {}, {}", (Object[])new Object[]{startInclusive, endExclusive}));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutableHolidayCalendar) {
            return this.id.equals(((ImmutableHolidayCalendar)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "HolidayCalendar[" + this.getName() + ']';
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ImmutableHolidayCalendar(HolidayCalendarId id, int weekends, int startYear, int[] lookup) {
        JodaBeanUtils.notNull((Object)id, (String)"id");
        JodaBeanUtils.notNull((Object)lookup, (String)"lookup");
        this.id = id;
        this.weekends = weekends;
        this.startYear = startYear;
        this.lookup = (int[])lookup.clone();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public HolidayCalendarId getId() {
        return this.id;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ImmutableHolidayCalendar> {
        private HolidayCalendarId id;
        private int weekends;
        private int startYear;
        private int[] lookup;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case -621930260: {
                    return this.weekends;
                }
                case -2129150017: {
                    return this.startYear;
                }
                case -1097094790: {
                    return this.lookup;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    this.id = (HolidayCalendarId)newValue;
                    break;
                }
                case -621930260: {
                    this.weekends = (Integer)newValue;
                    break;
                }
                case -2129150017: {
                    this.startYear = (Integer)newValue;
                    break;
                }
                case -1097094790: {
                    this.lookup = (int[])newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ImmutableHolidayCalendar build() {
            return new ImmutableHolidayCalendar(this.id, this.weekends, this.startYear, this.lookup);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ImmutableHolidayCalendar.Builder{");
            buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
            buf.append("weekends").append('=').append(JodaBeanUtils.toString((Object)this.weekends)).append(',').append(' ');
            buf.append("startYear").append('=').append(JodaBeanUtils.toString((Object)this.startYear)).append(',').append(' ');
            buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<HolidayCalendarId> id = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"id", ImmutableHolidayCalendar.class, HolidayCalendarId.class);
        private final MetaProperty<Integer> weekends = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"weekends", ImmutableHolidayCalendar.class, Integer.TYPE);
        private final MetaProperty<Integer> startYear = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startYear", ImmutableHolidayCalendar.class, Integer.TYPE);
        private final MetaProperty<int[]> lookup = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lookup", ImmutableHolidayCalendar.class, int[].class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"id", "weekends", "startYear", "lookup"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case -621930260: {
                    return this.weekends;
                }
                case -2129150017: {
                    return this.startYear;
                }
                case -1097094790: {
                    return this.lookup;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ImmutableHolidayCalendar> builder() {
            return new Builder();
        }

        public Class<? extends ImmutableHolidayCalendar> beanType() {
            return ImmutableHolidayCalendar.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<HolidayCalendarId> id() {
            return this.id;
        }

        public MetaProperty<Integer> weekends() {
            return this.weekends;
        }

        public MetaProperty<Integer> startYear() {
            return this.startYear;
        }

        public MetaProperty<int[]> lookup() {
            return this.lookup;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return ((ImmutableHolidayCalendar)bean).getId();
                }
                case -621930260: {
                    return ((ImmutableHolidayCalendar)bean).weekends;
                }
                case -2129150017: {
                    return ((ImmutableHolidayCalendar)bean).startYear;
                }
                case -1097094790: {
                    return ((ImmutableHolidayCalendar)bean).lookup;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

