/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.ReferenceDataId;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.ImmutableHolidayCalendar;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;
import org.joda.beans.impl.direct.MinimalMetaBean;

@BeanDefinition(style="minimal", builderScope="private", constructorScope="package")
final class HolidaySafeReferenceData
implements ReferenceData,
ImmutableBean,
Serializable {
    private static final ImmutableList<DayOfWeek> WEEKEND_DAYS = ImmutableList.of((Object)DayOfWeek.SATURDAY, (Object)DayOfWeek.SUNDAY);
    @PropertyDefinition(validate="notNull")
    private final ReferenceData underlying;
    private static final TypedMetaBean<HolidaySafeReferenceData> META_BEAN = MinimalMetaBean.of(HolidaySafeReferenceData.class, (String[])new String[]{"underlying"}, () -> new Builder(), (Function[])new Function[]{b -> b.getUnderlying()});
    private static final long serialVersionUID = 1L;

    @Override
    public <T> T queryValueOrNull(ReferenceDataId<T> id) {
        T found = this.underlying.queryValueOrNull(id);
        return found == null ? this.tryDefaultValue(id) : found;
    }

    private <T> T tryDefaultValue(ReferenceDataId<T> id) {
        if (id instanceof HolidayCalendarId && !HolidayCalendarId.isCompositeCalendar((HolidayCalendarId)id)) {
            return (T)ImmutableHolidayCalendar.of((HolidayCalendarId)id, (Iterable<LocalDate>)ImmutableList.of(), WEEKEND_DAYS);
        }
        return null;
    }

    @Override
    public boolean containsValue(ReferenceDataId<?> id) {
        return this.underlying.queryValueOrNull(id) != null || id instanceof HolidayCalendarId;
    }

    @Override
    public ReferenceData combinedWith(ReferenceData other) {
        ReferenceData combined = this.underlying.combinedWith(other);
        return new HolidaySafeReferenceData(combined);
    }

    public static TypedMetaBean<HolidaySafeReferenceData> meta() {
        return META_BEAN;
    }

    HolidaySafeReferenceData(ReferenceData underlying) {
        JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
        this.underlying = underlying;
    }

    public TypedMetaBean<HolidaySafeReferenceData> metaBean() {
        return META_BEAN;
    }

    public ReferenceData getUnderlying() {
        return this.underlying;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            HolidaySafeReferenceData other = (HolidaySafeReferenceData)obj;
            return JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("HolidaySafeReferenceData{");
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<HolidaySafeReferenceData> {
        private ReferenceData underlying;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    return this.underlying;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    this.underlying = (ReferenceData)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public HolidaySafeReferenceData build() {
            return new HolidaySafeReferenceData(this.underlying);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("HolidaySafeReferenceData.Builder{");
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
            buf.append('}');
            return buf.toString();
        }
    }
}

