/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.ReferenceDataId;
import com.opengamma.strata.basics.ReferenceDataNotFoundException;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.basics.date.HolidayCalendarIniLookup;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.named.Named;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class HolidayCalendarId
implements ReferenceDataId<HolidayCalendar>,
Resolvable<HolidayCalendar>,
Named,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Splitter SPLITTER_PLUS = Splitter.on((char)'+');
    private static final Joiner JOINER_PLUS = Joiner.on((char)'+');
    private static final Splitter SPLITTER_WIGGLE = Splitter.on((char)'~');
    private static final Joiner JOINER_WIGGLE = Joiner.on((char)'~');
    private static final ConcurrentHashMap<String, HolidayCalendarId> CACHE = new ConcurrentHashMap();
    private final String name;
    private final transient int hashCode;
    private final transient BiFunction<HolidayCalendarId, ReferenceData, HolidayCalendar> resolver;

    @FromString
    public static HolidayCalendarId of(String uniqueName) {
        HolidayCalendarId id = CACHE.get(uniqueName);
        return id != null ? id : HolidayCalendarId.create(uniqueName);
    }

    private static HolidayCalendarId create(String name) {
        if (name.indexOf(126) >= 0) {
            List<HolidayCalendarId> ids = SPLITTER_WIGGLE.splitToList((CharSequence)name).stream().map(n -> HolidayCalendarId.of(n)).distinct().sorted(Comparator.comparing(HolidayCalendarId::getName)).collect(Collectors.toList());
            if (ids.contains(HolidayCalendarIds.NO_HOLIDAYS)) {
                return HolidayCalendarIds.NO_HOLIDAYS;
            }
            String normalizedName = JOINER_WIGGLE.join(ids);
            return HolidayCalendarId.create(name, ids, normalizedName, HolidayCalendar::linkedWith);
        }
        if (name.indexOf(43) >= 0) {
            List<HolidayCalendarId> ids = SPLITTER_PLUS.splitToList((CharSequence)name).stream().filter(n -> !n.equals(HolidayCalendarIds.NO_HOLIDAYS.getName())).map(n -> HolidayCalendarId.of(n)).distinct().sorted(Comparator.comparing(HolidayCalendarId::getName)).collect(Collectors.toList());
            String normalizedName = JOINER_PLUS.join(ids);
            return HolidayCalendarId.create(name, ids, normalizedName, HolidayCalendar::combinedWith);
        }
        return CACHE.computeIfAbsent(name, n -> new HolidayCalendarId(name));
    }

    private static HolidayCalendarId create(String name, List<HolidayCalendarId> ids, String normalizedName, BinaryOperator<HolidayCalendar> fn) {
        BiFunction<HolidayCalendarId, ReferenceData, HolidayCalendar> resolver = (id, refData) -> {
            HolidayCalendar cal = refData.queryValueOrNull(id);
            if (cal != null) {
                return cal;
            }
            for (HolidayCalendarId splitId : ids) {
                HolidayCalendar splitCal = refData.queryValueOrNull(splitId);
                if (splitCal == null) {
                    throw new ReferenceDataNotFoundException(Messages.format((String)"Reference data not found for '{}' of type 'HolidayCalendarId' when finding '{}'", (Object[])new Object[]{splitId, id}));
                }
                cal = cal != null ? (HolidayCalendar)fn.apply(cal, splitCal) : splitCal;
            }
            return cal;
        };
        HolidayCalendarId id2 = CACHE.computeIfAbsent(normalizedName, n -> new HolidayCalendarId(normalizedName, resolver));
        CACHE.putIfAbsent(name, id2);
        return id2;
    }

    public static HolidayCalendarId defaultByCurrency(Currency currency) {
        return HolidayCalendarIniLookup.INSTANCE.defaultByCurrency(currency);
    }

    public static Optional<HolidayCalendarId> findDefaultByCurrency(Currency currency) {
        return HolidayCalendarIniLookup.INSTANCE.findDefaultByCurrency(currency);
    }

    public static HolidayCalendarId defaultByCurrencyPair(CurrencyPair currencyPair) {
        return currencyPair.toSet().stream().map(HolidayCalendarId::findDefaultByCurrency).flatMap(Guavate.filteringOptional()).reduce(HolidayCalendarIds.NO_HOLIDAYS, HolidayCalendarId::combinedWith);
    }

    public static boolean isCompositeCalendar(HolidayCalendarId id) {
        return id.getName().indexOf(126) >= 0 || id.getName().indexOf(43) >= 0;
    }

    private HolidayCalendarId(String normalizedName) {
        this.name = normalizedName;
        this.hashCode = normalizedName.hashCode();
        this.resolver = (id, refData) -> refData.queryValueOrNull(this);
    }

    private HolidayCalendarId(String normalizedName, BiFunction<HolidayCalendarId, ReferenceData, HolidayCalendar> resolver) {
        this.name = normalizedName;
        this.hashCode = normalizedName.hashCode();
        this.resolver = resolver;
    }

    private Object readResolve() {
        return HolidayCalendarId.of(this.name);
    }

    @ToString
    public String getName() {
        return this.name;
    }

    @Override
    public Class<HolidayCalendar> getReferenceDataType() {
        return HolidayCalendar.class;
    }

    @Override
    public HolidayCalendar resolve(ReferenceData refData) {
        return refData.getValue(this);
    }

    @Override
    public HolidayCalendar queryValueOrNull(ReferenceData refData) {
        return this.resolver.apply(this, refData);
    }

    public HolidayCalendarId combinedWith(HolidayCalendarId other) {
        if (this == other) {
            return this;
        }
        if (this == HolidayCalendarIds.NO_HOLIDAYS) {
            return (HolidayCalendarId)ArgChecker.notNull((Object)other, (String)"other");
        }
        if (other == HolidayCalendarIds.NO_HOLIDAYS) {
            return this;
        }
        return HolidayCalendarId.of(this.name + '+' + other.name);
    }

    public HolidayCalendarId linkedWith(HolidayCalendarId other) {
        if (this == other) {
            return this;
        }
        if (this == HolidayCalendarIds.NO_HOLIDAYS || other == HolidayCalendarIds.NO_HOLIDAYS) {
            return HolidayCalendarIds.NO_HOLIDAYS;
        }
        return HolidayCalendarId.of(this.name + '~' + other.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HolidayCalendarId that = (HolidayCalendarId)obj;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }
}

