/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.CombinedHolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendars;
import com.opengamma.strata.basics.date.LinkedHolidayCalendar;
import com.opengamma.strata.basics.date.LocalDateUtils;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.Named;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.stream.Stream;

public interface HolidayCalendar
extends Named {
    public boolean isHoliday(LocalDate var1);

    default public boolean isBusinessDay(LocalDate date) {
        return !this.isHoliday(date);
    }

    default public TemporalAdjuster adjustBy(int amount) {
        return TemporalAdjusters.ofDateAdjuster(date -> this.shift((LocalDate)date, amount));
    }

    default public LocalDate shift(LocalDate date, int amount) {
        LocalDate adjusted;
        block3: {
            block2: {
                adjusted = date;
                if (amount <= 0) break block2;
                for (int i = 0; i < amount; ++i) {
                    adjusted = this.next(adjusted);
                }
                break block3;
            }
            if (amount >= 0) break block3;
            for (int i = 0; i > amount; --i) {
                adjusted = this.previous(adjusted);
            }
        }
        return adjusted;
    }

    default public LocalDate next(LocalDate date) {
        LocalDate next = LocalDateUtils.plusDays(date, 1);
        return this.isHoliday(next) ? this.next(next) : next;
    }

    default public LocalDate nextOrSame(LocalDate date) {
        return this.isHoliday(date) ? this.next(date) : date;
    }

    default public LocalDate previous(LocalDate date) {
        LocalDate previous = LocalDateUtils.plusDays(date, -1);
        return this.isHoliday(previous) ? this.previous(previous) : previous;
    }

    default public LocalDate previousOrSame(LocalDate date) {
        return this.isHoliday(date) ? this.previous(date) : date;
    }

    default public LocalDate nextSameOrLastInMonth(LocalDate date) {
        LocalDate nextOrSame = this.nextOrSame(date);
        return nextOrSame.getMonthValue() != date.getMonthValue() ? this.previous(date) : nextOrSame;
    }

    default public boolean isLastBusinessDayOfMonth(LocalDate date) {
        return this.isBusinessDay(date) && this.next(date).getMonthValue() != date.getMonthValue();
    }

    default public LocalDate lastBusinessDayOfMonth(LocalDate date) {
        return this.previousOrSame(date.withDayOfMonth(date.lengthOfMonth()));
    }

    default public int daysBetween(LocalDate startInclusive, LocalDate endExclusive) {
        ArgChecker.inOrderOrEqual((Comparable)startInclusive, (Object)endExclusive, (String)"startInclusive", (String)"endExclusive");
        return Math.toIntExact(LocalDateUtils.stream(startInclusive, endExclusive).filter(this::isBusinessDay).count());
    }

    default public Stream<LocalDate> businessDays(LocalDate startInclusive, LocalDate endExclusive) {
        ArgChecker.inOrderOrEqual((Comparable)startInclusive, (Object)endExclusive, (String)"startInclusive", (String)"endExclusive");
        return LocalDateUtils.stream(startInclusive, endExclusive).filter(this::isBusinessDay);
    }

    default public Stream<LocalDate> holidays(LocalDate startInclusive, LocalDate endExclusive) {
        ArgChecker.inOrderOrEqual((Comparable)startInclusive, (Object)endExclusive, (String)"startInclusive", (String)"endExclusive");
        return LocalDateUtils.stream(startInclusive, endExclusive).filter(this::isHoliday);
    }

    default public HolidayCalendar combinedWith(HolidayCalendar other) {
        if (this.equals(other)) {
            return this;
        }
        if (other == HolidayCalendars.NO_HOLIDAYS) {
            return this;
        }
        return new CombinedHolidayCalendar(this, other);
    }

    default public HolidayCalendar linkedWith(HolidayCalendar other) {
        if (this.equals(other)) {
            return this;
        }
        if (this == HolidayCalendars.NO_HOLIDAYS || other == HolidayCalendars.NO_HOLIDAYS) {
            return HolidayCalendars.NO_HOLIDAYS;
        }
        return new LinkedHolidayCalendar(this, other);
    }

    public HolidayCalendarId getId();

    default public String getName() {
        return this.getId().getName();
    }
}

