/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjuster;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class Payment
implements FxConvertible<Payment>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurrencyAmount value;
    @PropertyDefinition(validate="notNull")
    private final LocalDate date;
    private static final long serialVersionUID = 1L;

    public static Payment of(Currency currency, double amount, LocalDate date) {
        return new Payment(CurrencyAmount.of(currency, amount), date);
    }

    public static Payment of(CurrencyAmount value, LocalDate date) {
        return new Payment(value, date);
    }

    public static Payment ofPay(CurrencyAmount value, LocalDate date) {
        return new Payment(value.negative(), date);
    }

    public static Payment ofReceive(CurrencyAmount value, LocalDate date) {
        return new Payment(value.positive(), date);
    }

    public Currency getCurrency() {
        return this.value.getCurrency();
    }

    public double getAmount() {
        return this.value.getAmount();
    }

    public Payment adjustDate(TemporalAdjuster adjuster) {
        LocalDate adjusted = this.date.with(adjuster);
        return adjusted.equals(this.date) ? this : this.toBuilder().date(adjusted).build();
    }

    public Payment negated() {
        return Payment.of(this.value.negated(), this.date);
    }

    @Override
    public Payment convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        if (this.getCurrency().equals(resultCurrency)) {
            return this;
        }
        return Payment.of(this.value.convertedTo(resultCurrency, rateProvider), this.date);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Payment(CurrencyAmount value, LocalDate date) {
        JodaBeanUtils.notNull((Object)value, (String)"value");
        JodaBeanUtils.notNull((Object)date, (String)"date");
        this.value = value;
        this.date = date;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurrencyAmount getValue() {
        return this.value;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Payment other = (Payment)obj;
            return JodaBeanUtils.equal((Object)this.value, (Object)other.value) && JodaBeanUtils.equal((Object)this.date, (Object)other.date);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.value);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.date);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("Payment{");
        buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value)).append(',').append(' ');
        buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<Payment> {
        private CurrencyAmount value;
        private LocalDate date;

        private Builder() {
        }

        private Builder(Payment beanToCopy) {
            this.value = beanToCopy.getValue();
            this.date = beanToCopy.getDate();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case 3076014: {
                    return this.date;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    this.value = (CurrencyAmount)newValue;
                    break;
                }
                case 3076014: {
                    this.date = (LocalDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public Payment build() {
            return new Payment(this.value, this.date);
        }

        public Builder value(CurrencyAmount value) {
            JodaBeanUtils.notNull((Object)value, (String)"value");
            this.value = value;
            return this;
        }

        public Builder date(LocalDate date) {
            JodaBeanUtils.notNull((Object)date, (String)"date");
            this.date = date;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("Payment.Builder{");
            buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value)).append(',').append(' ');
            buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyAmount> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", Payment.class, CurrencyAmount.class);
        private final MetaProperty<LocalDate> date = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"date", Payment.class, LocalDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"value", "date"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case 3076014: {
                    return this.date;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends Payment> beanType() {
            return Payment.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyAmount> value() {
            return this.value;
        }

        public MetaProperty<LocalDate> date() {
            return this.date;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return ((Payment)bean).getValue();
                }
                case 3076014: {
                    return ((Payment)bean).getDate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

