/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.LazyFxRateProvider;
import com.opengamma.strata.collect.Decimal;
import com.opengamma.strata.collect.Messages;
import java.util.function.Supplier;

public interface FxRateProvider {
    public static FxRateProvider lazy(Supplier<FxRateProvider> target) {
        return new LazyFxRateProvider(target);
    }

    public static FxRateProvider noConversion() {
        return (baseCurrency, counterCurrency) -> {
            throw new IllegalArgumentException(Messages.format((String)"FX rate conversion is not supported, requested for {}/{}", (Object[])new Object[]{baseCurrency, counterCurrency}));
        };
    }

    public static FxRateProvider minimal() {
        return (baseCurrency, counterCurrency) -> {
            if (baseCurrency.equals(counterCurrency)) {
                return 1.0;
            }
            throw new IllegalArgumentException(Messages.format((String)"FX rate conversion is not supported for {}/{}", (Object[])new Object[]{baseCurrency, counterCurrency}));
        };
    }

    default public double convert(double amount, Currency fromCurrency, Currency toCurrency) {
        return amount * this.fxRate(fromCurrency, toCurrency);
    }

    default public Decimal convert(Decimal amount, Currency fromCurrency, Currency toCurrency) {
        return amount.multipliedBy(this.fxRate(fromCurrency, toCurrency));
    }

    public double fxRate(Currency var1, Currency var2);

    default public double fxRate(CurrencyPair currencyPair) {
        return this.fxRate(currencyPair.getBase(), currencyPair.getCounter());
    }
}

