/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.date.AdjustableDate;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class AdjustablePayment
implements Resolvable<Payment>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurrencyAmount value;
    @PropertyDefinition(validate="notNull")
    private final AdjustableDate date;
    private static final long serialVersionUID = 1L;

    public static AdjustablePayment of(Currency currency, double amount, LocalDate date) {
        return new AdjustablePayment(CurrencyAmount.of(currency, amount), AdjustableDate.of(date));
    }

    public static AdjustablePayment of(Currency currency, double amount, AdjustableDate date) {
        return new AdjustablePayment(CurrencyAmount.of(currency, amount), date);
    }

    public static AdjustablePayment of(CurrencyAmount value, LocalDate date) {
        return new AdjustablePayment(value, AdjustableDate.of(date));
    }

    public static AdjustablePayment of(CurrencyAmount value, AdjustableDate date) {
        return new AdjustablePayment(value, date);
    }

    public static AdjustablePayment ofPay(CurrencyAmount value, LocalDate date) {
        return new AdjustablePayment(value.negative(), AdjustableDate.of(date));
    }

    public static AdjustablePayment ofPay(CurrencyAmount value, AdjustableDate date) {
        return new AdjustablePayment(value.negative(), date);
    }

    public static AdjustablePayment ofReceive(CurrencyAmount value, LocalDate date) {
        return new AdjustablePayment(value.positive(), AdjustableDate.of(date));
    }

    public static AdjustablePayment ofReceive(CurrencyAmount value, AdjustableDate date) {
        return new AdjustablePayment(value.positive(), date);
    }

    public static AdjustablePayment of(Payment payment) {
        return AdjustablePayment.of(payment.getValue(), payment.getDate());
    }

    public Currency getCurrency() {
        return this.value.getCurrency();
    }

    public double getAmount() {
        return this.value.getAmount();
    }

    @Override
    public Payment resolve(ReferenceData refData) {
        return Payment.of(this.value, this.date.adjusted(refData));
    }

    public AdjustablePayment negated() {
        return AdjustablePayment.of(this.value.negated(), this.date);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private AdjustablePayment(CurrencyAmount value, AdjustableDate date) {
        JodaBeanUtils.notNull((Object)value, (String)"value");
        JodaBeanUtils.notNull((Object)date, (String)"date");
        this.value = value;
        this.date = date;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurrencyAmount getValue() {
        return this.value;
    }

    public AdjustableDate getDate() {
        return this.date;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            AdjustablePayment other = (AdjustablePayment)obj;
            return JodaBeanUtils.equal((Object)this.value, (Object)other.value) && JodaBeanUtils.equal((Object)this.date, (Object)other.date);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.value);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.date);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("AdjustablePayment{");
        buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value)).append(',').append(' ');
        buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<AdjustablePayment> {
        private CurrencyAmount value;
        private AdjustableDate date;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case 3076014: {
                    return this.date;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    this.value = (CurrencyAmount)newValue;
                    break;
                }
                case 3076014: {
                    this.date = (AdjustableDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public AdjustablePayment build() {
            return new AdjustablePayment(this.value, this.date);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("AdjustablePayment.Builder{");
            buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value)).append(',').append(' ');
            buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyAmount> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", AdjustablePayment.class, CurrencyAmount.class);
        private final MetaProperty<AdjustableDate> date = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"date", AdjustablePayment.class, AdjustableDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"value", "date"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case 3076014: {
                    return this.date;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends AdjustablePayment> builder() {
            return new Builder();
        }

        public Class<? extends AdjustablePayment> beanType() {
            return AdjustablePayment.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyAmount> value() {
            return this.value;
        }

        public MetaProperty<AdjustableDate> date() {
            return this.date;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return ((AdjustablePayment)bean).getValue();
                }
                case 3076014: {
                    return ((AdjustablePayment)bean).getDate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

