/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.sdk.env;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

final class OktaSdkPropertiesEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String OKTA_CLIENT_ORG_URL = "okta.client.orgUrl";
    private static final String OKTA_OAUTH2_ISSUER = "okta.oauth2.issuer";

    OktaSdkPropertiesEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        environment.getPropertySources().addLast(this.loadYaml((Resource)new FileSystemResource(new File(System.getProperty("user.home"), ".okta/okta.yml")), false));
        environment.getPropertySources().addLast(this.loadYaml((Resource)new FileSystemResource(new File(System.getProperty("user.home"), ".okta/okta.yaml")), false));
        this.resolveEmptyOrgUrl(environment);
    }

    private void resolveEmptyOrgUrl(ConfigurableEnvironment environment) {
        String issuerValue;
        if (!StringUtils.hasText((String)environment.getProperty(OKTA_CLIENT_ORG_URL)) && StringUtils.hasText((String)(issuerValue = environment.getProperty(OKTA_OAUTH2_ISSUER)))) {
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                map.put(OKTA_CLIENT_ORG_URL, new URL(new URL(issuerValue), "/").toString());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource("issuer-to-orgUrl", map));
        }
    }

    private PropertySource<?> loadYaml(Resource resource, boolean required) {
        YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
        if (!resource.exists() && required) {
            throw new IllegalArgumentException("Resource " + resource + " does not exist");
        }
        if (resource.exists()) {
            try {
                List list = loader.load(resource.getFilename(), resource);
                return (PropertySource)list.get(0);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to load yaml configuration from " + resource, ex);
            }
        }
        return new MapPropertySource("Missing " + resource.getFilename(), Collections.emptyMap());
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

