/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt;

import com.okta.jwt.AccessTokenVerifier;
import com.okta.jwt.IdTokenVerifier;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public final class JwtVerifiers {
    private JwtVerifiers() {
    }

    public static IdTokenVerifier.Builder idTokenVerifierBuilder() {
        return JwtVerifiers.loadService(IdTokenVerifier.Builder.class);
    }

    public static AccessTokenVerifier.Builder accessTokenVerifierBuilder() {
        return JwtVerifiers.loadService(AccessTokenVerifier.Builder.class);
    }

    private static <T> T loadService(Class<T> service) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(service);
        return StreamSupport.stream(serviceLoader.spliterator(), false).reduce((a, b) -> {
            throw new IllegalStateException("Multiple implementations of `" + service + "` class found on the classpath. There can be only one.");
        }).orElseThrow(() -> new IllegalStateException("No `" + service + "` implementation found on the classpath. Have you remembered to include the okta-jwt-verifier-impl.jar in your runtime classpath?"));
    }
}

