/*
 * Decompiled with CFR 0.152.
 */
package com.okta.authn.sdk.client;

import com.okta.authn.sdk.AuthenticationException;
import com.okta.authn.sdk.AuthenticationStateHandler;
import com.okta.authn.sdk.http.RequestContext;
import com.okta.authn.sdk.resource.ActivateFactorRequest;
import com.okta.authn.sdk.resource.AuthenticationRequest;
import com.okta.authn.sdk.resource.AuthenticationResponse;
import com.okta.authn.sdk.resource.ChangePasswordRequest;
import com.okta.authn.sdk.resource.FactorEnrollRequest;
import com.okta.authn.sdk.resource.RecoverPasswordRequest;
import com.okta.authn.sdk.resource.RecoveryQuestionAnswerRequest;
import com.okta.authn.sdk.resource.UnlockAccountRequest;
import com.okta.authn.sdk.resource.VerifyFactorRequest;
import com.okta.authn.sdk.resource.VerifyRecoveryRequest;
import com.okta.sdk.ds.DataStore;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.user.factor.FactorProfile;
import com.okta.sdk.resource.user.factor.FactorProvider;
import com.okta.sdk.resource.user.factor.FactorType;

public interface AuthenticationClient {
    public DataStore getDataStore();

    public <T extends Resource> T instantiate(Class<T> var1);

    public AuthenticationResponse authenticate(String var1, char[] var2, String var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse authenticate(AuthenticationRequest request, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.authenticate(request, null, stateHandler);
    }

    public AuthenticationResponse authenticate(AuthenticationRequest var1, RequestContext var2, AuthenticationStateHandler var3) throws AuthenticationException;

    public AuthenticationResponse changePassword(char[] var1, char[] var2, String var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse changePassword(ChangePasswordRequest changePasswordRequest, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.changePassword(changePasswordRequest, null, stateHandler);
    }

    public AuthenticationResponse changePassword(ChangePasswordRequest var1, RequestContext var2, AuthenticationStateHandler var3) throws AuthenticationException;

    public AuthenticationResponse resetPassword(char[] var1, String var2, AuthenticationStateHandler var3) throws AuthenticationException;

    default public AuthenticationResponse resetPassword(ChangePasswordRequest changePasswordRequest, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.resetPassword(changePasswordRequest, null, stateHandler);
    }

    public AuthenticationResponse resetPassword(ChangePasswordRequest var1, RequestContext var2, AuthenticationStateHandler var3) throws AuthenticationException;

    public AuthenticationResponse enrollFactor(FactorType var1, FactorProvider var2, FactorProfile var3, String var4, AuthenticationStateHandler var5) throws AuthenticationException;

    default public AuthenticationResponse enrollFactor(FactorEnrollRequest factorEnrollRequest, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.enrollFactor(factorEnrollRequest, null, stateHandler);
    }

    public AuthenticationResponse enrollFactor(FactorEnrollRequest var1, RequestContext var2, AuthenticationStateHandler var3) throws AuthenticationException;

    public AuthenticationResponse recoverPassword(String var1, FactorType var2, String var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse recoverPassword(RecoverPasswordRequest request, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.recoverPassword(request, null, stateHandler);
    }

    public AuthenticationResponse recoverPassword(RecoverPasswordRequest var1, RequestContext var2, AuthenticationStateHandler var3) throws AuthenticationException;

    public AuthenticationResponse unlockAccount(String var1, FactorType var2, String var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse unlockAccount(UnlockAccountRequest request, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.unlockAccount(request, null, stateHandler);
    }

    public AuthenticationResponse unlockAccount(UnlockAccountRequest var1, RequestContext var2, AuthenticationStateHandler var3) throws AuthenticationException;

    public AuthenticationResponse answerRecoveryQuestion(String var1, String var2, AuthenticationStateHandler var3) throws AuthenticationException;

    default public AuthenticationResponse answerRecoveryQuestion(RecoveryQuestionAnswerRequest request, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.answerRecoveryQuestion(request, null, stateHandler);
    }

    public AuthenticationResponse answerRecoveryQuestion(RecoveryQuestionAnswerRequest var1, RequestContext var2, AuthenticationStateHandler var3) throws AuthenticationException;

    default public AuthenticationResponse previous(String stateToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.previous(stateToken, null, stateHandler);
    }

    public AuthenticationResponse previous(String var1, RequestContext var2, AuthenticationStateHandler var3) throws AuthenticationException;

    default public AuthenticationResponse skip(String stateToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.skip(stateToken, null, stateHandler);
    }

    public AuthenticationResponse skip(String var1, RequestContext var2, AuthenticationStateHandler var3) throws AuthenticationException;

    default public AuthenticationResponse cancel(String stateToken) throws AuthenticationException {
        return this.cancel(stateToken, null);
    }

    public AuthenticationResponse cancel(String var1, RequestContext var2) throws AuthenticationException;

    default public AuthenticationResponse activateFactor(String factorId, ActivateFactorRequest request, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.activateFactor(factorId, request, null, stateHandler);
    }

    public AuthenticationResponse activateFactor(String var1, ActivateFactorRequest var2, RequestContext var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse verifyFactor(String factorId, VerifyFactorRequest request, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.verifyFactor(factorId, request, null, stateHandler);
    }

    public AuthenticationResponse verifyFactor(String var1, VerifyFactorRequest var2, RequestContext var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse verifyFactor(String factorId, String stateToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.verifyFactor(factorId, stateToken, null, stateHandler);
    }

    public AuthenticationResponse verifyFactor(String var1, String var2, RequestContext var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse challengeFactor(String factorId, String stateToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.challengeFactor(factorId, stateToken, null, stateHandler);
    }

    public AuthenticationResponse challengeFactor(String var1, String var2, RequestContext var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse verifyUnlockAccount(FactorType factorType, VerifyRecoveryRequest request, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.verifyUnlockAccount(factorType, request, null, stateHandler);
    }

    public AuthenticationResponse verifyUnlockAccount(FactorType var1, VerifyRecoveryRequest var2, RequestContext var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse resendActivateFactor(String factorId, String stateToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.resendActivateFactor(factorId, stateToken, null, stateHandler);
    }

    public AuthenticationResponse resendActivateFactor(String var1, String var2, RequestContext var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse resendVerifyFactor(String factorId, String stateToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.resendVerifyFactor(factorId, stateToken, null, stateHandler);
    }

    public AuthenticationResponse resendVerifyFactor(String var1, String var2, RequestContext var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse verifyActivation(String factorId, String stateToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.verifyActivation(factorId, stateToken, null, stateHandler);
    }

    public AuthenticationResponse verifyActivation(String var1, String var2, RequestContext var3, AuthenticationStateHandler var4) throws AuthenticationException;

    default public AuthenticationResponse verifyRecoveryToken(String recoveryToken, AuthenticationStateHandler stateHandler) throws AuthenticationException {
        return this.verifyRecoveryToken(recoveryToken, null, stateHandler);
    }

    public AuthenticationResponse verifyRecoveryToken(String var1, RequestContext var2, AuthenticationStateHandler var3) throws AuthenticationException;
}

