/*
 * Decompiled with CFR 0.152.
 */
package com.ning.nagios;

import com.googlecode.jsendnsca.Level;

public interface ServiceCheck {
    public Status checkServiceStatus();

    public static class Status {
        private final Level level;
        private final String message;

        private Status(Level level, String message) {
            this.level = level;
            this.message = message;
        }

        public static Status ok(String message) {
            return new Status(Level.OK, message);
        }

        @Deprecated
        public static Status okf(String message) {
            return new Status(Level.OK, message);
        }

        public static Status okf(String format, Object ... args) {
            return new Status(Level.OK, String.format(format, args));
        }

        public static Status warning(String message) {
            return new Status(Level.WARNING, message);
        }

        @Deprecated
        public static Status warningf(String message) {
            return new Status(Level.WARNING, message);
        }

        public static Status warningf(String format, Object ... args) {
            return new Status(Level.WARNING, String.format(format, args));
        }

        public static Status critical(String message) {
            return new Status(Level.CRITICAL, message);
        }

        @Deprecated
        public static Status criticalf(String message) {
            return new Status(Level.CRITICAL, message);
        }

        public static Status criticalf(String format, Object ... args) {
            return new Status(Level.CRITICAL, String.format(format, args));
        }

        public static Status unknown(String message) {
            return new Status(Level.UNKNOWN, message);
        }

        @Deprecated
        public static Status unknownf(String message) {
            return new Status(Level.UNKNOWN, message);
        }

        public static Status unknownf(String format, Object ... args) {
            return new Status(Level.UNKNOWN, String.format(format, args));
        }

        Level getLevel() {
            return this.level;
        }

        String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.level + " " + this.message;
        }
    }
}

