/*
 * Decompiled with CFR 0.152.
 */
package com.ning.nagios;

import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NagiosException;
import com.googlecode.jsendnsca.PassiveCheckSender;
import com.googlecode.jsendnsca.builders.MessagePayloadBuilder;
import com.ning.nagios.MonitoredService;
import com.ning.nagios.ServiceCheck;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.skife.config.TimeSpan;

public class JsendnscaService
implements MonitoredService,
Runnable {
    private static final Logger log = Logger.getLogger(JsendnscaService.class);
    private final String serviceName;
    private final ServiceCheck check;
    private final PassiveCheckSender sender;
    private final MessagePayloadBuilder payloadBuilder;
    private final ScheduledExecutorService executor;
    private final TimeSpan checkRate;

    public JsendnscaService(String serviceName, TimeSpan checkRate, ServiceCheck check, PassiveCheckSender sender, MessagePayloadBuilder payloadBuilder) {
        this.serviceName = serviceName;
        this.checkRate = checkRate;
        this.check = check;
        this.sender = sender;
        this.payloadBuilder = payloadBuilder.withServiceName(serviceName);
        this.executor = Executors.newScheduledThreadPool(1);
        this.executor.submit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block10: {
            long startNanos = System.nanoTime();
            this.report();
            try {
                long ellapsedMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
                long delayMillis = this.checkRate.getMillis() - ellapsedMillis;
                this.executor.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                log.error((Object)String.format("Service [%s] had completely unexpected exception rescheduling", this.serviceName), t);
            }
            break block10;
            catch (Throwable t) {
                try {
                    log.warn((Object)String.format("Service [%s] had completely unexpected exception somewhere", this.serviceName), t);
                }
                catch (Throwable throwable) {
                    try {
                        long ellapsedMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
                        long delayMillis = this.checkRate.getMillis() - ellapsedMillis;
                        this.executor.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (Throwable t2) {
                        log.error((Object)String.format("Service [%s] had completely unexpected exception rescheduling", this.serviceName), t2);
                    }
                    throw throwable;
                }
                try {
                    long ellapsedMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
                    long delayMillis = this.checkRate.getMillis() - ellapsedMillis;
                    this.executor.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
                }
                catch (Throwable t3) {
                    log.error((Object)String.format("Service [%s] had completely unexpected exception rescheduling", this.serviceName), t3);
                }
            }
        }
    }

    private void report() {
        ServiceCheck.Status status;
        try {
            status = this.check.checkServiceStatus();
            log.info((Object)String.format("Service [%s] returned status [%s]", this.serviceName, status));
        }
        catch (RuntimeException e) {
            log.warn((Object)String.format("Service [%s] threw exception", this.serviceName), (Throwable)e);
            status = ServiceCheck.Status.unknown("Check threw exception: " + e.getMessage());
        }
        if (status == null) {
            log.warn((Object)String.format("Service [%s] returned null", this.serviceName));
            status = ServiceCheck.Status.unknown("Null status");
        }
        try {
            MessagePayload payload = this.payloadBuilder.withLevel(status.getLevel()).withMessage(status.getMessage()).create();
            this.sender.send(payload);
        }
        catch (NagiosException e) {
            log.warn((Object)String.format("Service [%s] had NagiosException sending status [%s]", this.serviceName, status), (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)String.format("Service [%s] had NagiosException sending status [%s]", this.serviceName, status), (Throwable)e);
        }
        catch (RuntimeException e) {
            log.warn((Object)String.format("Service [%s] had NagiosException sending status [%s]", this.serviceName, status), (Throwable)e);
        }
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public TimeSpan getCheckRate() {
        return this.checkRate;
    }

    public String toString() {
        return this.serviceName;
    }
}

