/*
 * Decompiled with CFR 0.152.
 */
package com.ning.nagios;

import com.ning.nagios.MonitoredService;
import com.ning.nagios.ServiceCheck;
import com.ning.nagios.ServiceMonitor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.skife.config.TimeSpan;

public class FakeNagiosMonitor
implements ServiceMonitor {
    private static final Logger log = Logger.getLogger(FakeNagiosMonitor.class);
    private final ConcurrentMap<String, MonitoredService> services = new ConcurrentHashMap<String, MonitoredService>();
    private final TimeSpan checkRate;

    public FakeNagiosMonitor(TimeSpan checkRate) {
        this.checkRate = checkRate;
    }

    @Override
    public MonitoredService registerServiceCheck(String serviceName, ServiceCheck check) {
        FakeNagiosService service = new FakeNagiosService(serviceName, this.checkRate, check);
        MonitoredService existingService = this.services.putIfAbsent(serviceName, service);
        if (existingService != null) {
            throw new IllegalStateException(String.format("Service check [%s] has already been registered", serviceName));
        }
        log.info((Object)String.format("Added service [%s] with check rate of [%s]", service, this.checkRate));
        return service;
    }

    private static class FakeNagiosService
    implements MonitoredService,
    Runnable {
        private static final Logger log = Logger.getLogger(FakeNagiosService.class);
        private final String serviceName;
        private final ServiceCheck check;
        private final ScheduledExecutorService executor;
        private final TimeSpan checkRate;

        private FakeNagiosService(String serviceName, TimeSpan checkRate, ServiceCheck check) {
            this.serviceName = serviceName;
            this.checkRate = checkRate;
            this.check = check;
            this.executor = Executors.newScheduledThreadPool(1);
            this.executor.submit(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block10: {
                long startNanos = System.nanoTime();
                this.report();
                try {
                    long ellapsedMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
                    long delayMillis = this.checkRate.getMillis() - ellapsedMillis;
                    this.executor.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
                }
                catch (Throwable t) {
                    log.error((Object)String.format("Service [%s] had completely unexpected exception rescheduling", this.serviceName), t);
                }
                break block10;
                catch (Throwable t) {
                    try {
                        log.warn((Object)String.format("Service [%s] had completely unexpected exception somewhere", this.serviceName), t);
                    }
                    catch (Throwable throwable) {
                        try {
                            long ellapsedMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
                            long delayMillis = this.checkRate.getMillis() - ellapsedMillis;
                            this.executor.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
                        }
                        catch (Throwable t2) {
                            log.error((Object)String.format("Service [%s] had completely unexpected exception rescheduling", this.serviceName), t2);
                        }
                        throw throwable;
                    }
                    try {
                        long ellapsedMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
                        long delayMillis = this.checkRate.getMillis() - ellapsedMillis;
                        this.executor.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (Throwable t3) {
                        log.error((Object)String.format("Service [%s] had completely unexpected exception rescheduling", this.serviceName), t3);
                    }
                }
            }
        }

        private void report() {
            ServiceCheck.Status status;
            try {
                status = this.check.checkServiceStatus();
            }
            catch (RuntimeException e) {
                log.warn((Object)String.format("Service [%s] threw exception", this.serviceName), (Throwable)e);
                status = ServiceCheck.Status.unknown("Check threw exception: " + e.getMessage());
            }
            if (status == null) {
                log.warn((Object)String.format("Service [%s] returned null", this.serviceName));
                status = ServiceCheck.Status.unknown("Null status");
            }
            log.info((Object)String.format("Service [%s] would have reported: %s", this.serviceName, status));
        }

        @Override
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        public TimeSpan getCheckRate() {
            return this.checkRate;
        }

        public String toString() {
            return this.serviceName;
        }
    }
}

