/*
 * Decompiled with CFR 0.152.
 */
package com.ning.arecibo.metrics;

import com.ning.arecibo.jmx.AreciboMBeanExporter;
import com.ning.arecibo.jmx.AreciboProfile;
import com.ning.arecibo.jmx.MonitoringType;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.reporting.JmxReporter;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AreciboMetricsReporter
implements Runnable {
    private final ScheduledExecutorService tickThread;
    private final MetricsRegistry metricsRegistry;
    private final AreciboProfile profile;
    private final AreciboMBeanExporter mbeanExporter;

    public static AreciboMetricsReporter enable(AreciboProfile profile) {
        return AreciboMetricsReporter.enable(Metrics.defaultRegistry(), profile);
    }

    public static AreciboMetricsReporter enable(MetricsRegistry metricsRegistry, AreciboProfile profile) {
        AreciboMetricsReporter reporter = new AreciboMetricsReporter(metricsRegistry, profile);
        reporter.start(1L, TimeUnit.MINUTES);
        return reporter;
    }

    public AreciboMetricsReporter(MetricsRegistry metricsRegistry, AreciboProfile profile) {
        this(metricsRegistry, profile, null);
    }

    public AreciboMetricsReporter(MetricsRegistry metricsRegistry, AreciboProfile profile, AreciboMBeanExporter mbeanExporter) {
        this.metricsRegistry = metricsRegistry;
        this.profile = profile;
        this.mbeanExporter = mbeanExporter;
        this.tickThread = metricsRegistry.newScheduledThreadPool(1, "arecibo-reporter");
    }

    public void start(long period, TimeUnit unit) {
        this.tickThread.scheduleAtFixedRate(this, 0L, period, unit);
    }

    @Override
    public void run() {
        for (Map.Entry entry : this.metricsRegistry.allMetrics().entrySet()) {
            MetricName name = (MetricName)entry.getKey();
            Metric metric = (Metric)entry.getValue();
            if (metric == null) continue;
            try {
                if (metric instanceof Gauge) {
                    this.registerGauge((Gauge)metric, name);
                    continue;
                }
                if (metric instanceof Counter) {
                    this.registerCounter((Counter)metric, name);
                    continue;
                }
                if (metric instanceof Histogram) {
                    this.registerHistogram((Histogram)metric, name);
                    continue;
                }
                if (metric instanceof Meter) {
                    this.registerMetered((Meter)metric, name);
                    continue;
                }
                if (metric instanceof Timer) {
                    this.registerTimer((Timer)metric, name);
                    continue;
                }
                if (this.mbeanExporter == null) continue;
                this.mbeanExporter.export(name.getMBeanName(), (Object)metric);
            }
            catch (Exception ignored) {}
        }
    }

    private String getEventName(MetricName name) {
        StringBuilder builder = new StringBuilder();
        builder.append(name.getGroup());
        builder.append(".");
        builder.append(name.getType());
        if (name.getScope() != null) {
            builder.append("-");
            builder.append(name.getScope());
        }
        if (name.getName().length() > 0) {
            builder.append("-");
            builder.append(name.getName());
        }
        return builder.toString();
    }

    private void registerValue(MetricName name, String attributeName, Class<?> type) {
        this.profile.add(name.getMBeanName(), attributeName, attributeName, ".*[Nn]ame=([a-zA-Z0-9_]*).*", this.getEventName(name), new MonitoringType[]{MonitoringType.VALUE}, type);
    }

    private void registerCounter(MetricName name, String attributeName, Class<?> type) {
        this.profile.add(name.getMBeanName(), attributeName, attributeName, ".*[Nn]ame=([a-zA-Z0-9_]*).*", this.getEventName(name), new MonitoringType[]{MonitoringType.COUNTER, MonitoringType.RATE}, type);
    }

    private void registerGauge(Gauge<?> metric, MetricName name) {
        this.profile.register(name.getMBeanName(), metric);
        this.registerValue(name, "Value", JmxReporter.GaugeMBean.class);
    }

    private void registerCounter(Counter metric, MetricName name) {
        this.profile.register(name.getMBeanName(), (Object)metric);
        this.registerCounter(name, "Count", JmxReporter.CounterMBean.class);
    }

    private void registerHistogram(Histogram metric, MetricName name) {
        this.profile.register(name.getMBeanName(), (Object)metric);
        this.registerCounter(name, "Count", JmxReporter.HistogramMBean.class);
        this.registerValue(name, "Min", JmxReporter.HistogramMBean.class);
        this.registerValue(name, "Max", JmxReporter.HistogramMBean.class);
        this.registerValue(name, "Mean", JmxReporter.HistogramMBean.class);
        this.registerValue(name, "StdDev", JmxReporter.HistogramMBean.class);
        this.registerValue(name, "50thPercentile", JmxReporter.HistogramMBean.class);
        this.registerValue(name, "75thPercentile", JmxReporter.HistogramMBean.class);
        this.registerValue(name, "95thPercentile", JmxReporter.HistogramMBean.class);
        this.registerValue(name, "98thPercentile", JmxReporter.HistogramMBean.class);
        this.registerValue(name, "99thPercentile", JmxReporter.HistogramMBean.class);
        this.registerValue(name, "999thPercentile", JmxReporter.HistogramMBean.class);
    }

    private void registerMetered(Meter metric, MetricName name) {
        this.profile.register(name.getMBeanName(), (Object)metric);
        this.registerCounter(name, "Count", JmxReporter.MeterMBean.class);
        this.registerValue(name, "MeanRate", JmxReporter.MeterMBean.class);
        this.registerValue(name, "OneMinuteRate", JmxReporter.MeterMBean.class);
        this.registerValue(name, "FiveMinuteRate", JmxReporter.MeterMBean.class);
        this.registerValue(name, "FifteenMinuteRate", JmxReporter.MeterMBean.class);
    }

    private void registerTimer(Timer metric, MetricName name) {
        this.profile.register(name.getMBeanName(), (Object)metric);
        this.registerCounter(name, "Count", JmxReporter.TimerMBean.class);
        this.registerValue(name, "Min", JmxReporter.TimerMBean.class);
        this.registerValue(name, "Max", JmxReporter.TimerMBean.class);
        this.registerValue(name, "Mean", JmxReporter.TimerMBean.class);
        this.registerValue(name, "StdDev", JmxReporter.TimerMBean.class);
        this.registerValue(name, "50thPercentile", JmxReporter.TimerMBean.class);
        this.registerValue(name, "75thPercentile", JmxReporter.TimerMBean.class);
        this.registerValue(name, "95thPercentile", JmxReporter.TimerMBean.class);
        this.registerValue(name, "98thPercentile", JmxReporter.TimerMBean.class);
        this.registerValue(name, "99thPercentile", JmxReporter.TimerMBean.class);
        this.registerValue(name, "999thPercentile", JmxReporter.TimerMBean.class);
        this.registerValue(name, "MeanRate", JmxReporter.TimerMBean.class);
        this.registerValue(name, "OneMinuteRate", JmxReporter.TimerMBean.class);
        this.registerValue(name, "FiveMinuteRate", JmxReporter.TimerMBean.class);
        this.registerValue(name, "FifteenMinuteRate", JmxReporter.TimerMBean.class);
    }
}

