/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.regex;

import com.networknt.schema.regex.RegularExpression;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JDKRegularExpression
implements RegularExpression {
    private final Pattern pattern;
    private final boolean hasStartAnchor;
    private final boolean hasEndAnchor;

    JDKRegularExpression(String regex) {
        this.hasStartAnchor = '^' == regex.charAt(0);
        this.hasEndAnchor = '$' == regex.charAt(regex.length() - 1);
        String pattern = regex;
        if (this.hasEndAnchor) {
            pattern = pattern.substring(this.hasStartAnchor ? 1 : 0, pattern.length() - 1);
            pattern = '(' + pattern + ")$";
            if (this.hasStartAnchor) {
                pattern = '^' + pattern;
            }
        }
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public boolean matches(String value) {
        Matcher matcher = this.pattern.matcher(value);
        return !(!matcher.find() || this.hasStartAnchor && 0 != matcher.start() || this.hasEndAnchor && matcher.end() != value.length());
    }
}

