/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private List<String> fieldNames = new ArrayList<String>();

    public RequiredValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.REQUIRED, validationContext);
        if (schemaNode.isArray()) {
            for (JsonNode fieldNme : schemaNode) {
                this.fieldNames.add(fieldNme.asText());
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (!node.isObject()) {
            return Collections.emptySet();
        }
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        for (String fieldName : this.fieldNames) {
            JsonNode propertyNode = node.get(fieldName);
            if (propertyNode != null) continue;
            errors.add(this.buildValidationMessage(at, fieldName));
        }
        return Collections.unmodifiableSet(errors);
    }
}

