/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ServerListUpdater;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingServerListUpdater
implements ServerListUpdater {
    private static final Logger logger = LoggerFactory.getLogger(PollingServerListUpdater.class);
    private static long LISTOFSERVERS_CACHE_UPDATE_DELAY = 1000L;
    private static int LISTOFSERVERS_CACHE_REPEAT_INTERVAL = 30000;
    private static int POOL_SIZE = 2;
    private final AtomicBoolean isActive = new AtomicBoolean(false);
    private volatile long lastUpdated = System.currentTimeMillis();
    private final long initialDelayMs;
    private final long refreshIntervalMs;
    private volatile ScheduledFuture<?> scheduledFuture;

    private static ScheduledExecutorService getRefreshExecutor() {
        return LazyHolder._serverListRefreshExecutor;
    }

    public PollingServerListUpdater() {
        this(LISTOFSERVERS_CACHE_UPDATE_DELAY, LISTOFSERVERS_CACHE_REPEAT_INTERVAL);
    }

    public PollingServerListUpdater(IClientConfig clientConfig) {
        this(LISTOFSERVERS_CACHE_UPDATE_DELAY, PollingServerListUpdater.getRefreshIntervalMs(clientConfig));
    }

    public PollingServerListUpdater(long initialDelayMs, long refreshIntervalMs) {
        this.initialDelayMs = initialDelayMs;
        this.refreshIntervalMs = refreshIntervalMs;
    }

    @Override
    public synchronized void start(ServerListUpdater.UpdateAction updateAction) {
        if (this.isActive.compareAndSet(false, true)) {
            Runnable wrapperRunnable = () -> {
                if (!this.isActive.get()) {
                    if (this.scheduledFuture != null) {
                        this.scheduledFuture.cancel(true);
                    }
                    return;
                }
                try {
                    updateAction.doUpdate();
                    this.lastUpdated = System.currentTimeMillis();
                }
                catch (Exception e) {
                    logger.warn("Failed one update cycle", (Throwable)e);
                }
            };
            this.scheduledFuture = PollingServerListUpdater.getRefreshExecutor().scheduleWithFixedDelay(wrapperRunnable, this.initialDelayMs, this.refreshIntervalMs, TimeUnit.MILLISECONDS);
        } else {
            logger.info("Already active, no-op");
        }
    }

    @Override
    public synchronized void stop() {
        if (this.isActive.compareAndSet(true, false)) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
        } else {
            logger.info("Not active, no-op");
        }
    }

    @Override
    public String getLastUpdate() {
        return new Date(this.lastUpdated).toString();
    }

    @Override
    public long getDurationSinceLastUpdateMs() {
        return System.currentTimeMillis() - this.lastUpdated;
    }

    @Override
    public int getNumberMissedCycles() {
        if (!this.isActive.get()) {
            return 0;
        }
        return (int)((long)((int)(System.currentTimeMillis() - this.lastUpdated)) / this.refreshIntervalMs);
    }

    @Override
    public int getCoreThreads() {
        return POOL_SIZE;
    }

    private static long getRefreshIntervalMs(IClientConfig clientConfig) {
        return ((Integer)clientConfig.get(CommonClientConfigKey.ServerListRefreshInterval, (Object)LISTOFSERVERS_CACHE_REPEAT_INTERVAL)).intValue();
    }

    private static class LazyHolder {
        static ScheduledExecutorService _serverListRefreshExecutor = null;

        private LazyHolder() {
        }

        static {
            _serverListRefreshExecutor = Executors.newScheduledThreadPool(POOL_SIZE, new ThreadFactoryBuilder().setNameFormat("PollingServerListUpdater-%d").setDaemon(true).build());
        }
    }
}

