/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.netflix.client.ClientException;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.CommandToObservableConverter;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerCommand;
import com.netflix.loadbalancer.LoadBalancerContext;
import com.netflix.loadbalancer.LoadBalancerObservableCommand;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.utils.RxUtils;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.observers.SafeSubscriber;
import rx.subscriptions.SerialSubscription;

public class LoadBalancerExecutor
extends LoadBalancerContext {
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancerExecutor.class);

    public LoadBalancerExecutor(ILoadBalancer lb) {
        super(lb);
    }

    public LoadBalancerExecutor(ILoadBalancer lb, IClientConfig clientConfig) {
        super(lb, clientConfig);
    }

    public LoadBalancerExecutor(ILoadBalancer lb, IClientConfig clientConfig, RetryHandler defaultRetryHandler) {
        super(lb, clientConfig, defaultRetryHandler);
    }

    public <T> T execute(LoadBalancerCommand<T> command, RetryHandler retryHandler) throws Exception {
        return this.create(command, null, retryHandler, null);
    }

    public <T> T execute(LoadBalancerCommand<T> command) throws Exception {
        return this.create(command, null, null, null);
    }

    protected <T> T create(LoadBalancerCommand<T> command, @Nullable URI loadBalancerURI, @Nullable RetryHandler retryHandler, @Nullable Object loadBalancerKey) throws Exception {
        return RxUtils.getSingleValueWithRealErrorCause(this.create(CommandToObservableConverter.toObsevableCommand(command), loadBalancerURI, retryHandler, loadBalancerKey));
    }

    public <T> Observable<T> create(LoadBalancerObservableCommand<T> observableCommand, @Nullable RetryHandler retryHandler) {
        return this.create(observableCommand, null, retryHandler, null);
    }

    public <T> Observable<T> create(LoadBalancerObservableCommand<T> observableCommand) {
        return this.create(observableCommand, null, null, null);
    }

    protected <T> Observable<T> create(LoadBalancerObservableCommand<T> observableCommand, @Nullable URI loadBalancerURI, @Nullable RetryHandler retryHandler, @Nullable Object loadBalancerKey) {
        Server server = null;
        try {
            server = this.getServerFromLoadBalancer(loadBalancerURI, loadBalancerKey);
        }
        catch (Exception e) {
            return Observable.error((Throwable)e);
        }
        RetryHandler handler = retryHandler == null ? this.getRetryHandler() : retryHandler;
        Observable<T> forSameServer = this.retryWithSameServer(server, observableCommand.run(server), handler);
        if (handler.getMaxRetriesOnNextServer() == 0) {
            return forSameServer;
        }
        return forSameServer.lift(new RetryNextServerOperator<T>(observableCommand, loadBalancerURI, handler, loadBalancerKey));
    }

    public <T> Observable<T> retryWithSameServer(Server server, Observable<T> forServer, RetryHandler errorHandler) {
        RetryHandler handler = errorHandler == null ? this.getRetryHandler() : errorHandler;
        return forServer.lift(new RetrySameServerOperator<T>(server, forServer, handler));
    }

    private class RetrySameServerOperator<T>
    implements Observable.Operator<T, T> {
        private final Server server;
        private final Observable<T> singleHostObservable;
        private final RetryHandler errorHandler;
        private final AtomicInteger counter = new AtomicInteger();

        RetrySameServerOperator(Server server, Observable<T> singleHostObservable, RetryHandler errorHandler) {
            this.server = server;
            this.singleHostObservable = singleHostObservable;
            this.errorHandler = errorHandler == null ? LoadBalancerExecutor.this.getRetryHandler() : errorHandler;
        }

        public Subscriber<? super T> call(final Subscriber<? super T> t1) {
            SerialSubscription serialSubscription = new SerialSubscription();
            t1.add((Subscription)serialSubscription);
            final ServerStats serverStats = LoadBalancerExecutor.this.getServerStats(this.server);
            LoadBalancerExecutor.this.noteOpenConnection(serverStats);
            final Stopwatch tracer = LoadBalancerExecutor.this.getExecuteTracer().start();
            Subscriber subscriber = new Subscriber<T>(){
                private volatile T entity;

                public void onCompleted() {
                    this.recordStats(this.entity, null);
                    t1.onCompleted();
                }

                public void onError(Throwable e) {
                    Throwable finalThrowable;
                    boolean shouldRetry;
                    logger.debug("Got error {} when executed on server {}", (Object)e, (Object)RetrySameServerOperator.this.server);
                    this.recordStats(this.entity, e);
                    int maxRetries = RetrySameServerOperator.this.errorHandler.getMaxRetriesOnSameServer();
                    boolean bl = shouldRetry = maxRetries > 0 && RetrySameServerOperator.this.errorHandler.isRetriableException(e, true);
                    if (shouldRetry && !LoadBalancerExecutor.this.handleSameServerRetry(RetrySameServerOperator.this.server, RetrySameServerOperator.this.counter.incrementAndGet(), maxRetries, e)) {
                        finalThrowable = new ClientException(ClientException.ErrorType.NUMBEROF_RETRIES_EXEEDED, "Number of retries exceeded max " + maxRetries + " retries, while making a call for: " + RetrySameServerOperator.this.server, e);
                        shouldRetry = false;
                    } else {
                        finalThrowable = e;
                    }
                    if (shouldRetry) {
                        RetrySameServerOperator.this.singleHostObservable.lift((Observable.Operator)RetrySameServerOperator.this).subscribe(t1);
                    } else {
                        t1.onError(finalThrowable);
                    }
                }

                public void onNext(T obj) {
                    this.entity = obj;
                    t1.onNext(obj);
                }

                private void recordStats(Object entity, Throwable exception) {
                    tracer.stop();
                    long duration = tracer.getDuration(TimeUnit.MILLISECONDS);
                    LoadBalancerExecutor.this.noteRequestCompletion(serverStats, entity, exception, duration, RetrySameServerOperator.this.errorHandler);
                }
            };
            SafeSubscriber safeSubscriber = new SafeSubscriber(subscriber);
            serialSubscription.set((Subscription)safeSubscriber);
            return safeSubscriber;
        }
    }

    private class RetryNextServerOperator<T>
    implements Observable.Operator<T, T> {
        private LoadBalancerObservableCommand<T> clientObservableProvider;
        private URI loadBalancerURI;
        private RetryHandler retryHandler;
        private Object loadBalancerKey;
        private final AtomicInteger counter = new AtomicInteger();

        public RetryNextServerOperator(@Nullable LoadBalancerObservableCommand<T> clientObservableProvider, @Nullable URI loadBalancerURI, @Nullable RetryHandler retryHandler, Object loadBalancerKey) {
            this.clientObservableProvider = clientObservableProvider;
            this.loadBalancerURI = loadBalancerURI;
            this.retryHandler = retryHandler == null ? LoadBalancerExecutor.this.getRetryHandler() : retryHandler;
            this.loadBalancerKey = loadBalancerKey;
        }

        public Subscriber<? super T> call(final Subscriber<? super T> t1) {
            SerialSubscription serialSubscription = new SerialSubscription();
            t1.add((Subscription)serialSubscription);
            Subscriber subscriber = new Subscriber<T>(){

                public void onCompleted() {
                    t1.onCompleted();
                }

                public void onError(Throwable e) {
                    Throwable finalThrowable;
                    boolean shouldRetry;
                    logger.debug("Get error during retry on next server", (Object)t1);
                    int maxRetriesNextServer = RetryNextServerOperator.this.retryHandler.getMaxRetriesOnNextServer();
                    boolean sameServerRetryExceededLimit = e instanceof ClientException && ((ClientException)e).getErrorType().equals((Object)ClientException.ErrorType.NUMBEROF_RETRIES_EXEEDED);
                    boolean bl = shouldRetry = maxRetriesNextServer > 0 && (sameServerRetryExceededLimit || RetryNextServerOperator.this.retryHandler.isRetriableException(e, false));
                    if (shouldRetry && RetryNextServerOperator.this.counter.incrementAndGet() > maxRetriesNextServer) {
                        finalThrowable = new ClientException(ClientException.ErrorType.NUMBEROF_RETRIES_NEXTSERVER_EXCEEDED, "NUMBER_OF_RETRIES_NEXTSERVER_EXCEEDED :" + maxRetriesNextServer + " retries, while making a call with load balancer: " + LoadBalancerExecutor.this.getDeepestCause(e).getMessage(), e);
                        shouldRetry = false;
                    } else {
                        finalThrowable = e;
                    }
                    if (shouldRetry) {
                        Server server = null;
                        try {
                            server = LoadBalancerExecutor.this.getServerFromLoadBalancer(RetryNextServerOperator.this.loadBalancerURI, RetryNextServerOperator.this.loadBalancerKey);
                        }
                        catch (Exception ex) {
                            logger.error("Unexpected error", (Throwable)ex);
                            t1.onError((Throwable)ex);
                        }
                        LoadBalancerExecutor.this.retryWithSameServer(server, RetryNextServerOperator.this.clientObservableProvider.run(server), RetryNextServerOperator.this.retryHandler).lift((Observable.Operator)RetryNextServerOperator.this).subscribe(t1);
                    } else {
                        t1.onError(finalThrowable);
                    }
                }

                public void onNext(T t) {
                    t1.onNext(t);
                }
            };
            serialSubscription.set((Subscription)subscriber);
            return subscriber;
        }
    }

    static interface OnSubscribeFunc<T> {
        public Subscription onSubscribe(Observer<? super T> var1);
    }
}

