/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.loadbalancer;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryEnabledNIWSServerList
extends AbstractServerList<DiscoveryEnabledServer> {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryEnabledNIWSServerList.class);
    String clientName;
    String vipAddresses;
    boolean isSecure = false;
    boolean prioritizeVipAddressBasedServers = true;
    String datacenter;
    String targetRegion;
    int overridePort = 7001;
    boolean shouldUseOverridePort = false;
    boolean shouldUseIpAddr = false;

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientName = clientConfig.getClientName();
        this.vipAddresses = clientConfig.resolveDeploymentContextbasedVipAddresses();
        if (this.vipAddresses == null && ConfigurationManager.getConfigInstance().getBoolean("DiscoveryEnabledNIWSServerList.failFastOnNullVip", true)) {
            throw new NullPointerException("VIP address for client " + this.clientName + " is null");
        }
        this.isSecure = Boolean.parseBoolean("" + clientConfig.getProperty((IClientConfigKey)CommonClientConfigKey.IsSecure, (Object)"false"));
        this.prioritizeVipAddressBasedServers = Boolean.parseBoolean("" + clientConfig.getProperty((IClientConfigKey)CommonClientConfigKey.PrioritizeVipAddressBasedServers, (Object)this.prioritizeVipAddressBasedServers));
        this.datacenter = ConfigurationManager.getDeploymentContext().getDeploymentDatacenter();
        this.targetRegion = (String)clientConfig.getProperty((IClientConfigKey)CommonClientConfigKey.TargetRegion);
        this.shouldUseIpAddr = clientConfig.getPropertyAsBoolean((IClientConfigKey)CommonClientConfigKey.UseIPAddrForServer, DefaultClientConfigImpl.DEFAULT_USEIPADDRESS_FOR_SERVER);
        if (clientConfig.getPropertyAsBoolean((IClientConfigKey)CommonClientConfigKey.ForceClientPortConfiguration, false)) {
            if (this.isSecure) {
                if (clientConfig.containsProperty((IClientConfigKey)CommonClientConfigKey.SecurePort)) {
                    this.overridePort = clientConfig.getPropertyAsInteger((IClientConfigKey)CommonClientConfigKey.SecurePort, 7001);
                    this.shouldUseOverridePort = true;
                } else {
                    logger.warn(this.clientName + " set to force client port but no secure port is set, so ignoring");
                }
            } else if (clientConfig.containsProperty((IClientConfigKey)CommonClientConfigKey.Port)) {
                this.overridePort = clientConfig.getPropertyAsInteger((IClientConfigKey)CommonClientConfigKey.Port, 7001);
                this.shouldUseOverridePort = true;
            } else {
                logger.warn(this.clientName + " set to force client port but no port is set, so ignoring");
            }
        }
    }

    public List<DiscoveryEnabledServer> getInitialListOfServers() {
        return this.obtainServersViaDiscovery();
    }

    public List<DiscoveryEnabledServer> getUpdatedListOfServers() {
        return this.obtainServersViaDiscovery();
    }

    private List<DiscoveryEnabledServer> obtainServersViaDiscovery() {
        ArrayList<DiscoveryEnabledServer> serverList = new ArrayList<DiscoveryEnabledServer>();
        DiscoveryClient discoveryClient = DiscoveryManager.getInstance().getDiscoveryClient();
        if (discoveryClient == null) {
            return new ArrayList<DiscoveryEnabledServer>();
        }
        if (this.vipAddresses != null) {
            for (String vipAddress : this.vipAddresses.split(",")) {
                List listOfinstanceInfo = discoveryClient.getInstancesByVipAddress(vipAddress, this.isSecure, this.targetRegion);
                for (InstanceInfo ii : listOfinstanceInfo) {
                    if (!ii.getStatus().equals((Object)InstanceInfo.InstanceStatus.UP)) continue;
                    if (this.shouldUseOverridePort) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Overriding port on client name: " + this.clientName + " to " + this.overridePort);
                        }
                        InstanceInfo copy = new InstanceInfo(ii);
                        ii = this.isSecure ? new InstanceInfo.Builder(copy).setSecurePort(this.overridePort).build() : new InstanceInfo.Builder(copy).setPort(this.overridePort).build();
                    }
                    DiscoveryEnabledServer des = new DiscoveryEnabledServer(ii, this.isSecure, this.shouldUseIpAddr);
                    des.setZone(DiscoveryClient.getZone((InstanceInfo)ii));
                    serverList.add(des);
                }
                if (serverList.size() > 0 && this.prioritizeVipAddressBasedServers) break;
            }
        }
        return serverList;
    }

    public String getVipAddresses() {
        return this.vipAddresses;
    }

    public void setVipAddresses(String vipAddresses) {
        this.vipAddresses = vipAddresses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DiscoveryEnabledNIWSServerList:");
        sb.append("; clientName:").append(this.clientName);
        sb.append("; Effective vipAddresses:").append(this.vipAddresses);
        sb.append("; isSecure:").append(this.isSecure);
        sb.append("; datacenter:").append(this.datacenter);
        return sb.toString();
    }
}

