/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.AbstractCommand;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.HystrixInvokableInfo;
import com.netflix.hystrix.HystrixObservable;
import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.util.HystrixTimer;
import java.lang.ref.Reference;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import rx.Observable;
import rx.Subscriber;

public abstract class HystrixCommand<R>
extends AbstractCommand<R>
implements HystrixExecutable<R>,
HystrixInvokableInfo<R>,
HystrixObservable<R> {
    protected HystrixCommand(HystrixCommandGroupKey group) {
        this(new Setter(group));
    }

    protected HystrixCommand(HystrixCommandGroupKey group, HystrixThreadPoolKey threadPool) {
        this(new Setter(group).andThreadPoolKey(threadPool));
    }

    protected HystrixCommand(HystrixCommandGroupKey group, int executionIsolationThreadTimeoutInMilliseconds) {
        this(new Setter(group).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationThreadTimeoutInMilliseconds(executionIsolationThreadTimeoutInMilliseconds)));
    }

    protected HystrixCommand(HystrixCommandGroupKey group, HystrixThreadPoolKey threadPool, int executionIsolationThreadTimeoutInMilliseconds) {
        this(new Setter(group).andThreadPoolKey(threadPool).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationThreadTimeoutInMilliseconds(executionIsolationThreadTimeoutInMilliseconds)));
    }

    protected HystrixCommand(Setter setter) {
        this(setter.groupKey, setter.commandKey, setter.threadPoolKey, null, null, setter.commandPropertiesDefaults, setter.threadPoolPropertiesDefaults, null, null, null, null, null);
    }

    HystrixCommand(HystrixCommandGroupKey group, HystrixCommandKey key, HystrixThreadPoolKey threadPoolKey, HystrixCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, HystrixCommandProperties.Setter commandPropertiesDefaults, HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults, HystrixCommandMetrics metrics, AbstractCommand.TryableSemaphore fallbackSemaphore, AbstractCommand.TryableSemaphore executionSemaphore, HystrixPropertiesStrategy propertiesStrategy, HystrixCommandExecutionHook executionHook) {
        super(group, key, threadPoolKey, circuitBreaker, threadPool, commandPropertiesDefaults, threadPoolPropertiesDefaults, metrics, fallbackSemaphore, executionSemaphore, propertiesStrategy, executionHook);
    }

    protected abstract R run() throws Exception;

    protected R getFallback() {
        throw new UnsupportedOperationException("No fallback available.");
    }

    @Override
    protected final Observable<R> getExecutionObservable() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<R>(){

            public void call(Subscriber<? super R> s) {
                try {
                    s.onNext(HystrixCommand.this.run());
                    s.onCompleted();
                }
                catch (Throwable e) {
                    s.onError(e);
                }
            }
        });
    }

    @Override
    protected final Observable<R> getFallbackObservable() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<R>(){

            public void call(Subscriber<? super R> s) {
                try {
                    s.onNext(HystrixCommand.this.getFallback());
                    s.onCompleted();
                }
                catch (Throwable e) {
                    s.onError(e);
                }
            }
        });
    }

    @Override
    public final R execute() {
        try {
            return this.queue().get();
        }
        catch (Exception e) {
            throw this.decomposeException(e);
        }
    }

    @Override
    public final Future<R> queue() {
        final AbstractCommand.ObservableCommand o = this.toObservable(false);
        final Future f = o.toBlocking().toFuture();
        if (f.isDone()) {
            try {
                f.get();
                return f;
            }
            catch (Exception e) {
                RuntimeException re = this.decomposeException(e);
                if (re instanceof HystrixBadRequestException) {
                    return f;
                }
                if (re instanceof HystrixRuntimeException) {
                    HystrixRuntimeException hre = (HystrixRuntimeException)re;
                    if (hre.getFailureType() == HystrixRuntimeException.FailureType.COMMAND_EXCEPTION || hre.getFailureType() == HystrixRuntimeException.FailureType.TIMEOUT) {
                        return f;
                    }
                    throw hre;
                }
                throw re;
            }
        }
        return new Future<R>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return f.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return f.isCancelled();
            }

            @Override
            public boolean isDone() {
                return f.isDone();
            }

            @Override
            public R get() throws InterruptedException, ExecutionException {
                return this.performBlockingGetWithTimeout(o, f);
            }

            protected R performBlockingGetWithTimeout(AbstractCommand.ObservableCommand<R> o2, Future<R> f2) throws InterruptedException, ExecutionException {
                Reference timer;
                if (f2.isDone()) {
                    return f2.get();
                }
                AbstractCommand originalCommand = o2.getCommand();
                if (originalCommand != null && (timer = (Reference)originalCommand.timeoutTimer.getAndSet(null)) != null) {
                    long timeout;
                    HystrixTimer.TimerListener l = (HystrixTimer.TimerListener)timer.get();
                    timer.clear();
                    long timeRemaining = timeout = (long)originalCommand.properties.executionIsolationThreadTimeoutInMilliseconds().get().intValue();
                    long currTime = System.currentTimeMillis();
                    if (originalCommand.invocationStartTime != -1L) {
                        timeRemaining = originalCommand.invocationStartTime + (long)originalCommand.properties.executionIsolationThreadTimeoutInMilliseconds().get().intValue() - currTime;
                    }
                    if (timeRemaining > 0L) {
                        try {
                            return f2.get(timeRemaining, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e) {
                            if (l != null) {
                                l.tick();
                            }
                        }
                    } else if (!f2.isDone() && l != null) {
                        l.tick();
                    }
                }
                return f2.get();
            }

            @Override
            public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.get();
            }
        };
    }

    public static final class Setter {
        protected final HystrixCommandGroupKey groupKey;
        protected HystrixCommandKey commandKey;
        protected HystrixThreadPoolKey threadPoolKey;
        protected HystrixCommandProperties.Setter commandPropertiesDefaults;
        protected HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults;

        protected Setter(HystrixCommandGroupKey groupKey) {
            this.groupKey = groupKey;
        }

        public static Setter withGroupKey(HystrixCommandGroupKey groupKey) {
            return new Setter(groupKey);
        }

        public Setter andCommandKey(HystrixCommandKey commandKey) {
            this.commandKey = commandKey;
            return this;
        }

        public Setter andThreadPoolKey(HystrixThreadPoolKey threadPoolKey) {
            this.threadPoolKey = threadPoolKey;
            return this;
        }

        public Setter andCommandPropertiesDefaults(HystrixCommandProperties.Setter commandPropertiesDefaults) {
            this.commandPropertiesDefaults = commandPropertiesDefaults;
            return this;
        }

        public Setter andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults) {
            this.threadPoolPropertiesDefaults = threadPoolPropertiesDefaults;
            return this;
        }
    }
}

