/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DataLoaderInstrumentationExtensionProvider;
import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.DgsDataLoaderRegistryConsumer;
import com.netflix.graphql.dgs.exceptions.InvalidDataLoaderTypeException;
import com.netflix.graphql.dgs.exceptions.UnsupportedSecuredDataLoaderException;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018J:\u0010\u0019\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002JN\u0010\u0019\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001a\"\u0004\b\u0000\u0010\u00162\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b2\u0006\u0010\u001c\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J:\u0010\u0019\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002JN\u0010\u0019\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001a\"\u0004\b\u0000\u0010\u00162\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\u0006\u0010\u001c\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\r\u0010\u001f\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b J&\u0010!\u001a\u0002H\u0016\"\u0006\b\u0000\u0010\u0016\u0018\u00012\u0006\u0010\"\u001a\u0002H\u00162\u0006\u0010#\u001a\u00020$H\u0082\b\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0005\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lorg/springframework/context/ApplicationContext;)V", "batchLoaders", "", "Lkotlin/Pair;", "Lorg/dataloader/BatchLoader;", "Lcom/netflix/graphql/dgs/DgsDataLoader;", "batchLoadersWithContext", "Lorg/dataloader/BatchLoaderWithContext;", "mappedBatchLoaders", "Lorg/dataloader/MappedBatchLoader;", "mappedBatchLoadersWithContext", "Lorg/dataloader/MappedBatchLoaderWithContext;", "addDataLoaderComponents", "", "addDataLoaderFields", "buildRegistry", "Lorg/dataloader/DataLoaderRegistry;", "buildRegistryWithContextSupplier", "T", "contextSupplier", "Ljava/util/function/Supplier;", "createDataLoader", "Lorg/dataloader/DataLoader;", "batchLoader", "dgsDataLoader", "dataLoaderRegistry", "supplier", "findDataLoaders", "findDataLoaders$graphql_dgs", "wrappedDataLoader", "loader", "name", "", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "Companion", "graphql-dgs"})
public final class DgsDataLoaderProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final List<Pair<BatchLoader<?, ?>, DgsDataLoader>> batchLoaders;
    @NotNull
    private final List<Pair<BatchLoaderWithContext<?, ?>, DgsDataLoader>> batchLoadersWithContext;
    @NotNull
    private final List<Pair<MappedBatchLoader<?, ?>, DgsDataLoader>> mappedBatchLoaders;
    @NotNull
    private final List<Pair<MappedBatchLoaderWithContext<?, ?>, DgsDataLoader>> mappedBatchLoadersWithContext;
    @Deprecated
    @NotNull
    private static final Logger logger;

    public DgsDataLoaderProvider(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
        boolean bl = false;
        this.batchLoaders = new ArrayList();
        bl = false;
        this.batchLoadersWithContext = new ArrayList();
        bl = false;
        this.mappedBatchLoaders = new ArrayList();
        bl = false;
        this.mappedBatchLoadersWithContext = new ArrayList();
    }

    @NotNull
    public final DataLoaderRegistry buildRegistry() {
        return this.buildRegistryWithContextSupplier(buildRegistry.1.INSTANCE);
    }

    @NotNull
    public final <T> DataLoaderRegistry buildRegistryWithContextSupplier(@NotNull Supplier<T> contextSupplier) {
        Pair it;
        Intrinsics.checkNotNullParameter(contextSupplier, (String)"contextSupplier");
        long startTime = System.currentTimeMillis();
        DataLoaderRegistry dataLoaderRegistry = new DataLoaderRegistry();
        Iterable $this$forEach$iv = this.batchLoaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((BatchLoader)it.getFirst(), (DgsDataLoader)it.getSecond(), dataLoaderRegistry));
        }
        $this$forEach$iv = this.mappedBatchLoaders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((MappedBatchLoader)it.getFirst(), (DgsDataLoader)it.getSecond(), dataLoaderRegistry));
        }
        $this$forEach$iv = this.batchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((BatchLoaderWithContext)it.getFirst(), (DgsDataLoader)it.getSecond(), contextSupplier, dataLoaderRegistry));
        }
        $this$forEach$iv = this.mappedBatchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((MappedBatchLoaderWithContext)it.getFirst(), (DgsDataLoader)it.getSecond(), contextSupplier, dataLoaderRegistry));
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        logger.debug("Created DGS dataloader registry in {}ms", (Object)totalTime);
        return dataLoaderRegistry;
    }

    @PostConstruct
    public final void findDataLoaders$graphql_dgs() {
        this.addDataLoaderComponents();
        this.addDataLoaderFields();
    }

    /*
     * WARNING - void declaration
     */
    private final void addDataLoaderFields() {
        Iterable $this$forEach$iv = this.applicationContext.getBeansWithAnnotation(DgsComponent.class).values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class javaClass = AopUtils.getTargetClass(dgsComponent);
            Sequence sequence = javaClass.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)sequence, (String)"javaClass.declaredFields");
            sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])((Object[])sequence)), (Function1)addDataLoaderFields.1.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl2 = false;
                if (AopUtils.isAopProxy(dgsComponent)) {
                    throw new UnsupportedSecuredDataLoaderException(dgsComponent.getClass());
                }
                DgsDataLoader annotation = field.getAnnotation(DgsDataLoader.class);
                ReflectionUtils.makeAccessible((Field)field);
                Object get = field.get(dgsComponent);
                if (get instanceof BatchLoader) {
                    this.batchLoaders.add(TuplesKt.to((Object)get, (Object)annotation));
                    continue;
                }
                if (get instanceof BatchLoaderWithContext) {
                    this.batchLoadersWithContext.add(TuplesKt.to((Object)get, (Object)annotation));
                    continue;
                }
                if (get instanceof MappedBatchLoader) {
                    this.mappedBatchLoaders.add(TuplesKt.to((Object)get, (Object)annotation));
                    continue;
                }
                if (get instanceof MappedBatchLoaderWithContext) {
                    this.mappedBatchLoadersWithContext.add(TuplesKt.to((Object)get, (Object)annotation));
                    continue;
                }
                throw new InvalidDataLoaderTypeException(dgsComponent.getClass());
            }
        }
    }

    private final void addDataLoaderComponents() {
        Map dataLoaders = this.applicationContext.getBeansWithAnnotation(DgsDataLoader.class);
        Iterable $this$forEach$iv = dataLoaders.values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class javaClass = AopUtils.getTargetClass(dgsComponent);
            DgsDataLoader annotation = javaClass.getAnnotation(DgsDataLoader.class);
            Object t = dgsComponent;
            if (t instanceof BatchLoader) {
                Intrinsics.checkNotNullExpressionValue(dgsComponent, (String)"dgsComponent");
                this.batchLoaders.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            if (t instanceof BatchLoaderWithContext) {
                Intrinsics.checkNotNullExpressionValue(dgsComponent, (String)"dgsComponent");
                this.batchLoadersWithContext.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            if (t instanceof MappedBatchLoader) {
                Intrinsics.checkNotNullExpressionValue(dgsComponent, (String)"dgsComponent");
                this.mappedBatchLoaders.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            if (t instanceof MappedBatchLoaderWithContext) {
                Intrinsics.checkNotNullExpressionValue(dgsComponent, (String)"dgsComponent");
                this.mappedBatchLoadersWithContext.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            throw new InvalidDataLoaderTypeException(dgsComponent.getClass());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final DataLoader<? extends Object, ? extends Object> createDataLoader(BatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, DataLoaderRegistry dataLoaderRegistry) {
        BatchLoader extendedBatchLoader;
        DataLoaderOptions options;
        block11: {
            BatchLoader batchLoader2;
            block12: {
                BatchLoader batchLoader3;
                options = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setCachingEnabled(dgsDataLoader.caching());
                if (dgsDataLoader.maxBatchSize() > 0) {
                    options.setMaxBatchSize(dgsDataLoader.maxBatchSize());
                }
                DgsDataLoaderProvider dgsDataLoaderProvider = this;
                String name$iv = dgsDataLoader.name();
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    void this_$iv;
                    Stream stream$iv = ((DgsDataLoaderProvider)this_$iv).applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    batchLoader3 = batchLoader;
                    if (batchLoader3 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new Consumer(wrappedBatchLoader$iv, name$iv){
                            final /* synthetic */ Ref.ObjectRef<BatchLoader<?, ?>> $wrappedBatchLoader;
                            final /* synthetic */ String $name;
                            {
                                this.$wrappedBatchLoader = $wrappedBatchLoader;
                                this.$name = $name;
                            }

                            public final void accept(DataLoaderInstrumentationExtensionProvider it) {
                                this.$wrappedBatchLoader.element = it.provide((BatchLoader)this.$wrappedBatchLoader.element, this.$name);
                            }
                        });
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = (BatchLoader)object;
                        break block11;
                    }
                    if (batchLoader3 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new Consumer(wrappedBatchLoader$iv, name$iv){
                            final /* synthetic */ Ref.ObjectRef<BatchLoaderWithContext<?, ?>> $wrappedBatchLoader;
                            final /* synthetic */ String $name;
                            {
                                this.$wrappedBatchLoader = $wrappedBatchLoader;
                                this.$name = $name;
                            }

                            public final void accept(DataLoaderInstrumentationExtensionProvider it) {
                                this.$wrappedBatchLoader.element = it.provide((BatchLoaderWithContext)this.$wrappedBatchLoader.element, this.$name);
                            }
                        });
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = (BatchLoader)object;
                        break block11;
                    }
                    if (batchLoader3 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new Consumer(wrappedBatchLoader$iv, name$iv){
                            final /* synthetic */ Ref.ObjectRef<MappedBatchLoader<?, ?>> $wrappedBatchLoader;
                            final /* synthetic */ String $name;
                            {
                                this.$wrappedBatchLoader = $wrappedBatchLoader;
                                this.$name = $name;
                            }

                            public final void accept(DataLoaderInstrumentationExtensionProvider it) {
                                this.$wrappedBatchLoader.element = it.provide((MappedBatchLoader)this.$wrappedBatchLoader.element, this.$name);
                            }
                        });
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = (BatchLoader)object;
                        break block11;
                    }
                    if (!(batchLoader3 instanceof MappedBatchLoaderWithContext)) break block12;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = batchLoader;
                    stream$iv.forEach(new Consumer(wrappedBatchLoader$iv, name$iv){
                        final /* synthetic */ Ref.ObjectRef<MappedBatchLoaderWithContext<?, ?>> $wrappedBatchLoader;
                        final /* synthetic */ String $name;
                        {
                            this.$wrappedBatchLoader = $wrappedBatchLoader;
                            this.$name = $name;
                        }

                        public final void accept(DataLoaderInstrumentationExtensionProvider it) {
                            this.$wrappedBatchLoader.element = it.provide((MappedBatchLoaderWithContext)this.$wrappedBatchLoader.element, this.$name);
                        }
                    });
                    Object object = wrappedBatchLoader$iv.element;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                    }
                    batchLoader2 = (BatchLoader)object;
                    break block11;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    batchLoader3 = new BatchLoader[]{name$iv, batchLoader, ex$iv};
                    DgsDataLoaderProvider.logger.debug("Unable to wrap the [{} : {}]", batchLoader3);
                }
            }
            batchLoader2 = extendedBatchLoader = batchLoader;
        }
        if (extendedBatchLoader instanceof DgsDataLoaderRegistryConsumer) {
            ((DgsDataLoaderRegistryConsumer)extendedBatchLoader).setDataLoaderRegistry(dataLoaderRegistry);
        }
        return DataLoader.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
    }

    /*
     * WARNING - void declaration
     */
    private final DataLoader<? extends Object, ? extends Object> createDataLoader(MappedBatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, DataLoaderRegistry dataLoaderRegistry) {
        MappedBatchLoader extendedBatchLoader;
        DataLoaderOptions options;
        block11: {
            MappedBatchLoader mappedBatchLoader;
            block12: {
                MappedBatchLoader mappedBatchLoader2;
                options = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setCachingEnabled(dgsDataLoader.caching());
                if (dgsDataLoader.maxBatchSize() > 0) {
                    options.setMaxBatchSize(dgsDataLoader.maxBatchSize());
                }
                DgsDataLoaderProvider dgsDataLoaderProvider = this;
                String name$iv = dgsDataLoader.name();
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    void this_$iv;
                    Stream stream$iv = ((DgsDataLoaderProvider)this_$iv).applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    mappedBatchLoader2 = batchLoader;
                    if (mappedBatchLoader2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = (MappedBatchLoader)object;
                        break block11;
                    }
                    if (mappedBatchLoader2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = (MappedBatchLoader)object;
                        break block11;
                    }
                    if (mappedBatchLoader2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = (MappedBatchLoader)object;
                        break block11;
                    }
                    if (!(mappedBatchLoader2 instanceof MappedBatchLoaderWithContext)) break block12;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = batchLoader;
                    stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                    Object object = wrappedBatchLoader$iv.element;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                    }
                    mappedBatchLoader = (MappedBatchLoader)object;
                    break block11;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    mappedBatchLoader2 = new MappedBatchLoader[]{name$iv, batchLoader, ex$iv};
                    DgsDataLoaderProvider.logger.debug("Unable to wrap the [{} : {}]", mappedBatchLoader2);
                }
            }
            mappedBatchLoader = extendedBatchLoader = batchLoader;
        }
        if (extendedBatchLoader instanceof DgsDataLoaderRegistryConsumer) {
            ((DgsDataLoaderRegistryConsumer)extendedBatchLoader).setDataLoaderRegistry(dataLoaderRegistry);
        }
        return DataLoader.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> DataLoader<? extends Object, ? extends Object> createDataLoader(BatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry) {
        BatchLoaderWithContext extendedBatchLoader;
        DataLoaderOptions options;
        block11: {
            BatchLoaderWithContext batchLoaderWithContext;
            block12: {
                BatchLoaderWithContext batchLoaderWithContext2;
                options = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setBatchLoaderContextProvider(supplier::get).setCachingEnabled(dgsDataLoader.caching());
                if (dgsDataLoader.maxBatchSize() > 0) {
                    options.setMaxBatchSize(dgsDataLoader.maxBatchSize());
                }
                DgsDataLoaderProvider dgsDataLoaderProvider = this;
                String name$iv = dgsDataLoader.name();
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    void this_$iv;
                    Stream stream$iv = ((DgsDataLoaderProvider)this_$iv).applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    batchLoaderWithContext2 = batchLoader;
                    if (batchLoaderWithContext2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = (BatchLoaderWithContext)object;
                        break block11;
                    }
                    if (batchLoaderWithContext2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = (BatchLoaderWithContext)object;
                        break block11;
                    }
                    if (batchLoaderWithContext2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = (BatchLoaderWithContext)object;
                        break block11;
                    }
                    if (!(batchLoaderWithContext2 instanceof MappedBatchLoaderWithContext)) break block12;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = batchLoader;
                    stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                    Object object = wrappedBatchLoader$iv.element;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                    }
                    batchLoaderWithContext = (BatchLoaderWithContext)object;
                    break block11;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    batchLoaderWithContext2 = new BatchLoaderWithContext[]{name$iv, batchLoader, ex$iv};
                    DgsDataLoaderProvider.logger.debug("Unable to wrap the [{} : {}]", batchLoaderWithContext2);
                }
            }
            batchLoaderWithContext = extendedBatchLoader = batchLoader;
        }
        if (extendedBatchLoader instanceof DgsDataLoaderRegistryConsumer) {
            ((DgsDataLoaderRegistryConsumer)extendedBatchLoader).setDataLoaderRegistry(dataLoaderRegistry);
        }
        return DataLoader.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> DataLoader<? extends Object, ? extends Object> createDataLoader(MappedBatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry) {
        MappedBatchLoaderWithContext extendedBatchLoader;
        DataLoaderOptions options;
        block11: {
            MappedBatchLoaderWithContext mappedBatchLoaderWithContext;
            block12: {
                MappedBatchLoaderWithContext mappedBatchLoaderWithContext2;
                options = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setBatchLoaderContextProvider(supplier::get).setCachingEnabled(dgsDataLoader.caching());
                if (dgsDataLoader.maxBatchSize() > 0) {
                    options.setMaxBatchSize(dgsDataLoader.maxBatchSize());
                }
                DgsDataLoaderProvider dgsDataLoaderProvider = this;
                String name$iv = dgsDataLoader.name();
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    void this_$iv;
                    Stream stream$iv = ((DgsDataLoaderProvider)this_$iv).applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    mappedBatchLoaderWithContext2 = batchLoader;
                    if (mappedBatchLoaderWithContext2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)object;
                        break block11;
                    }
                    if (mappedBatchLoaderWithContext2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)object;
                        break block11;
                    }
                    if (mappedBatchLoaderWithContext2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)object;
                        break block11;
                    }
                    if (!(mappedBatchLoaderWithContext2 instanceof MappedBatchLoaderWithContext)) break block12;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = batchLoader;
                    stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                    Object object = wrappedBatchLoader$iv.element;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                    }
                    mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)object;
                    break block11;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    mappedBatchLoaderWithContext2 = new MappedBatchLoaderWithContext[]{name$iv, batchLoader, ex$iv};
                    DgsDataLoaderProvider.logger.debug("Unable to wrap the [{} : {}]", mappedBatchLoaderWithContext2);
                }
            }
            mappedBatchLoaderWithContext = extendedBatchLoader = batchLoader;
        }
        if (extendedBatchLoader instanceof DgsDataLoaderRegistryConsumer) {
            ((DgsDataLoaderRegistryConsumer)extendedBatchLoader).setDataLoaderRegistry(dataLoaderRegistry);
        }
        return DataLoader.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
    }

    private final /* synthetic */ <T> T wrappedDataLoader(T loader, String name) {
        boolean $i$f$wrappedDataLoader = false;
        try {
            Stream stream = this.applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
            T t = loader;
            if (t instanceof BatchLoader) {
                Ref.ObjectRef wrappedBatchLoader = new Ref.ObjectRef();
                wrappedBatchLoader.element = loader;
                stream.forEach(new /* invalid duplicate definition of identical inner class */);
                Object object = wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)object;
            }
            if (t instanceof BatchLoaderWithContext) {
                Ref.ObjectRef wrappedBatchLoader = new Ref.ObjectRef();
                wrappedBatchLoader.element = loader;
                stream.forEach(new /* invalid duplicate definition of identical inner class */);
                Object object = wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)object;
            }
            if (t instanceof MappedBatchLoader) {
                Ref.ObjectRef wrappedBatchLoader = new Ref.ObjectRef();
                wrappedBatchLoader.element = loader;
                stream.forEach(new /* invalid duplicate definition of identical inner class */);
                Object object = wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)object;
            }
            if (t instanceof MappedBatchLoaderWithContext) {
                Ref.ObjectRef wrappedBatchLoader = new Ref.ObjectRef();
                wrappedBatchLoader.element = loader;
                stream.forEach(new /* invalid duplicate definition of identical inner class */);
                Object object = wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)object;
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            Object[] objectArray = new Object[]{name, loader, ex};
            DgsDataLoaderProvider.logger.debug("Unable to wrap the [{} : {}]", objectArray);
        }
        return loader;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsDataLoaderProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DgsDataLoaderProvider::class.java)");
        DgsDataLoaderProvider.logger = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

