/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs;

import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.exceptions.MultipleDataLoadersDefinedException;
import com.netflix.graphql.dgs.exceptions.NoDataLoaderFoundException;
import graphql.GraphQLContext;
import graphql.cachecontrol.CacheControl;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.MergedField;
import graphql.execution.directives.QueryDirectives;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001d\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\nJ%\u0010\u000b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u0013\u001a\u0002H\t\"\u0004\b\u0000\u0010\tH\u0017\u00a2\u0006\u0002\u0010\u0014J*\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180\u0016\"\u0004\b\u0000\u0010\u0017\"\u0004\b\u0001\u0010\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aJ*\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180\u0016\"\u0004\b\u0000\u0010\u0017\"\u0004\b\u0001\u0010\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020'0-H\u0017J\u0014\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020/0\u000fH\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\u0013\u00104\u001a\u0002H\t\"\u0004\b\u0000\u0010\tH\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020>H\u0016J\u0013\u0010?\u001a\u0002H\t\"\u0004\b\u0000\u0010\tH\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010@\u001a\u00020AH\u0016J\u0013\u0010B\u001a\u0002H\t\"\u0004\b\u0000\u0010\tH\u0016\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "Lgraphql/schema/DataFetchingEnvironment;", "dfe", "(Lgraphql/schema/DataFetchingEnvironment;)V", "containsArgument", "", "name", "", "getArgument", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "getArgumentOrDefault", "defaultValue", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getArguments", "", "", "getCacheControl", "Lgraphql/cachecontrol/CacheControl;", "getContext", "()Ljava/lang/Object;", "getDataLoader", "Lorg/dataloader/DataLoader;", "K", "V", "loaderClass", "Ljava/lang/Class;", "dataLoaderName", "getDataLoaderRegistry", "Lorg/dataloader/DataLoaderRegistry;", "getDgsContext", "Lcom/netflix/graphql/dgs/context/DgsContext;", "getDocument", "Lgraphql/language/Document;", "getExecutionId", "Lgraphql/execution/ExecutionId;", "getExecutionStepInfo", "Lgraphql/execution/ExecutionStepInfo;", "getField", "Lgraphql/language/Field;", "getFieldDefinition", "Lgraphql/schema/GraphQLFieldDefinition;", "getFieldType", "Lgraphql/schema/GraphQLOutputType;", "getFields", "", "getFragmentsByName", "Lgraphql/language/FragmentDefinition;", "getGraphQLSchema", "Lgraphql/schema/GraphQLSchema;", "getGraphQlContext", "Lgraphql/GraphQLContext;", "getLocalContext", "getLocale", "Ljava/util/Locale;", "getMergedField", "Lgraphql/execution/MergedField;", "getOperationDefinition", "Lgraphql/language/OperationDefinition;", "getParentType", "Lgraphql/schema/GraphQLType;", "getQueryDirectives", "Lgraphql/execution/directives/QueryDirectives;", "getRoot", "getSelectionSet", "Lgraphql/schema/DataFetchingFieldSelectionSet;", "getSource", "getVariables", "graphql-dgs"})
public final class DgsDataFetchingEnvironment
implements DataFetchingEnvironment {
    @NotNull
    private final DataFetchingEnvironment dfe;

    public DgsDataFetchingEnvironment(@NotNull DataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        this.dfe = dfe;
    }

    @NotNull
    public final DgsContext getDgsContext() {
        Object context = this.dfe.getContext();
        if (context instanceof DgsContext) {
            return (DgsContext)context;
        }
        throw new RuntimeException("Context object of type '" + context.getClass().getName() + "' is not a DgsContext. This method does not work if you have a custom implementation of DgsContextBuilder");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <K, V> DataLoader<K, V> getDataLoader(@NotNull Class<?> loaderClass) {
        DataLoader dataLoader;
        Intrinsics.checkNotNullParameter(loaderClass, (String)"loaderClass");
        DgsDataLoader annotation = loaderClass.getAnnotation(DgsDataLoader.class);
        if (annotation != null) {
            DataLoader dataLoader2 = this.dfe.getDataLoader(annotation.name());
            Intrinsics.checkNotNullExpressionValue((Object)dataLoader2, (String)"{\n            dfe.getDat\u2026nnotation.name)\n        }");
            dataLoader = dataLoader2;
        } else {
            DgsDataLoader dgsDataLoader;
            String string;
            void $this$filterTo$iv$iv;
            Field[] fieldArray = loaderClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"loaderClass.fields");
            Object[] $this$filter$iv = fieldArray;
            boolean $i$f$filter = false;
            Object object = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (!it.isAnnotationPresent(DgsDataLoader.class)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List loaders = (List)destination$iv$iv;
            if (loaders.size() > 1) {
                throw new MultipleDataLoadersDefinedException(loaderClass);
            }
            object = (Field)CollectionsKt.firstOrNull((List)loaders);
            String string2 = object == null ? null : (string = (dgsDataLoader = ((Field)object).getAnnotation(DgsDataLoader.class)) == null ? null : dgsDataLoader.name());
            if (string == null) {
                throw new NoDataLoaderFoundException(loaderClass);
            }
            String loaderName = string;
            DataLoader dataLoader3 = this.dfe.getDataLoader(loaderName);
            Intrinsics.checkNotNullExpressionValue((Object)dataLoader3, (String)"{\n            val loader\u2026der(loaderName)\n        }");
            dataLoader = dataLoader3;
        }
        return dataLoader;
    }

    public <T> T getSource() {
        return (T)this.dfe.getSource();
    }

    @NotNull
    public Map<String, Object> getArguments() {
        Map map = this.dfe.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"dfe.arguments");
        return map;
    }

    public boolean containsArgument(@Nullable String name) {
        return this.dfe.containsArgument(name);
    }

    public <T> T getArgument(@Nullable String name) {
        return (T)this.dfe.getArgument(name);
    }

    public <T> T getArgumentOrDefault(@Nullable String name, T defaultValue) {
        return (T)this.dfe.getArgumentOrDefault(name, defaultValue);
    }

    @Deprecated(message="Use getGraphQLContext() instead.", replaceWith=@ReplaceWith(expression="getGraphQLContext().get()", imports={}))
    public <T> T getContext() {
        return (T)this.dfe.getContext();
    }

    @NotNull
    public GraphQLContext getGraphQlContext() {
        GraphQLContext graphQLContext = this.dfe.getGraphQlContext();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLContext, (String)"dfe.graphQlContext");
        return graphQLContext;
    }

    public <T> T getLocalContext() {
        return (T)this.dfe.getLocalContext();
    }

    public <T> T getRoot() {
        return (T)this.dfe.getRoot();
    }

    @NotNull
    public GraphQLFieldDefinition getFieldDefinition() {
        GraphQLFieldDefinition graphQLFieldDefinition = this.dfe.getFieldDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition, (String)"dfe.fieldDefinition");
        return graphQLFieldDefinition;
    }

    @Deprecated(message="Use getMergedField()")
    @NotNull
    public List<graphql.language.Field> getFields() {
        List list = this.dfe.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dfe.fields");
        return list;
    }

    @NotNull
    public MergedField getMergedField() {
        MergedField mergedField = this.dfe.getMergedField();
        Intrinsics.checkNotNullExpressionValue((Object)mergedField, (String)"dfe.mergedField");
        return mergedField;
    }

    @NotNull
    public graphql.language.Field getField() {
        graphql.language.Field field = this.dfe.getField();
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"dfe.field");
        return field;
    }

    @NotNull
    public GraphQLOutputType getFieldType() {
        GraphQLOutputType graphQLOutputType = this.dfe.getFieldType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType, (String)"dfe.fieldType");
        return graphQLOutputType;
    }

    @NotNull
    public ExecutionStepInfo getExecutionStepInfo() {
        ExecutionStepInfo executionStepInfo = this.dfe.getExecutionStepInfo();
        Intrinsics.checkNotNullExpressionValue((Object)executionStepInfo, (String)"dfe.executionStepInfo");
        return executionStepInfo;
    }

    @NotNull
    public GraphQLType getParentType() {
        GraphQLType graphQLType = this.dfe.getParentType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLType, (String)"dfe.parentType");
        return graphQLType;
    }

    @NotNull
    public GraphQLSchema getGraphQLSchema() {
        GraphQLSchema graphQLSchema = this.dfe.getGraphQLSchema();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema, (String)"dfe.graphQLSchema");
        return graphQLSchema;
    }

    @NotNull
    public Map<String, FragmentDefinition> getFragmentsByName() {
        Map map = this.dfe.getFragmentsByName();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"dfe.fragmentsByName");
        return map;
    }

    @NotNull
    public ExecutionId getExecutionId() {
        ExecutionId executionId = this.dfe.getExecutionId();
        Intrinsics.checkNotNullExpressionValue((Object)executionId, (String)"dfe.executionId");
        return executionId;
    }

    @NotNull
    public DataFetchingFieldSelectionSet getSelectionSet() {
        DataFetchingFieldSelectionSet dataFetchingFieldSelectionSet = this.dfe.getSelectionSet();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetchingFieldSelectionSet, (String)"dfe.selectionSet");
        return dataFetchingFieldSelectionSet;
    }

    @NotNull
    public QueryDirectives getQueryDirectives() {
        QueryDirectives queryDirectives = this.dfe.getQueryDirectives();
        Intrinsics.checkNotNullExpressionValue((Object)queryDirectives, (String)"dfe.queryDirectives");
        return queryDirectives;
    }

    @NotNull
    public <K, V> DataLoader<K, V> getDataLoader(@Nullable String dataLoaderName) {
        DataLoader dataLoader = this.dfe.getDataLoader(dataLoaderName);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"dfe.getDataLoader(dataLoaderName)");
        return dataLoader;
    }

    @NotNull
    public DataLoaderRegistry getDataLoaderRegistry() {
        DataLoaderRegistry dataLoaderRegistry = this.dfe.getDataLoaderRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)dataLoaderRegistry, (String)"dfe.dataLoaderRegistry");
        return dataLoaderRegistry;
    }

    @NotNull
    public CacheControl getCacheControl() {
        CacheControl cacheControl = this.dfe.getCacheControl();
        Intrinsics.checkNotNullExpressionValue((Object)cacheControl, (String)"dfe.cacheControl");
        return cacheControl;
    }

    @NotNull
    public Locale getLocale() {
        Locale locale = this.dfe.getLocale();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"dfe.locale");
        return locale;
    }

    @NotNull
    public OperationDefinition getOperationDefinition() {
        OperationDefinition operationDefinition = this.dfe.getOperationDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)operationDefinition, (String)"dfe.operationDefinition");
        return operationDefinition;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.dfe.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"dfe.document");
        return document;
    }

    @NotNull
    public Map<String, Object> getVariables() {
        Map map = this.dfe.getVariables();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"dfe.variables");
        return map;
    }
}

