/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DataLoaderInstrumentationExtensionProvider;
import com.netflix.graphql.dgs.DgsDataLoaderCustomizer;
import com.netflix.graphql.dgs.DgsDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.internal.DefaultDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.internal.DefaultDgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016J\u0006\u0010\u0018\u001a\u00020\u0010J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010!\u001a\u00020\u0010J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/netflix/graphql/dgs/internal/ReloadableDgsDataLoaderProvider;", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "extensionProviders", "", "Lcom/netflix/graphql/dgs/DataLoaderInstrumentationExtensionProvider;", "customizers", "Lcom/netflix/graphql/dgs/DgsDataLoaderCustomizer;", "dataLoaderOptionsProvider", "Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;", "scheduleDuration", "Ljava/time/Duration;", "enableTickerMode", "", "<init>", "(Lorg/springframework/context/ApplicationContext;Ljava/util/concurrent/ScheduledExecutorService;Ljava/util/List;Ljava/util/List;Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;Ljava/time/Duration;Z)V", "currentProvider", "Lcom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderProvider;", "lastReloadTime", "Ljava/time/Instant;", "getLastReloadTime", "isInitialized", "buildRegistry", "Lorg/dataloader/DataLoaderRegistry;", "buildRegistryWithContextSupplier", "T", "contextSupplier", "Ljava/util/function/Supplier;", "getOrCreateProvider", "createNewProvider", "forceReload", "Companion", "graphql-dgs"})
public final class ReloadableDgsDataLoaderProvider
implements DgsDataLoaderProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile ApplicationContext applicationContext;
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    private final List<DataLoaderInstrumentationExtensionProvider> extensionProviders;
    @NotNull
    private final List<DgsDataLoaderCustomizer> customizers;
    @NotNull
    private final DgsDataLoaderOptionsProvider dataLoaderOptionsProvider;
    @NotNull
    private final Duration scheduleDuration;
    private final boolean enableTickerMode;
    @Nullable
    private volatile DefaultDgsDataLoaderProvider currentProvider;
    @Nullable
    private volatile Instant lastReloadTime;
    @NotNull
    private static final Logger logger;

    public ReloadableDgsDataLoaderProvider(@NotNull ApplicationContext applicationContext, @NotNull ScheduledExecutorService scheduledExecutorService, @NotNull List<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders, @NotNull List<? extends DgsDataLoaderCustomizer> customizers, @NotNull DgsDataLoaderOptionsProvider dataLoaderOptionsProvider, @NotNull Duration scheduleDuration, boolean enableTickerMode) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorService, (String)"scheduledExecutorService");
        Intrinsics.checkNotNullParameter(extensionProviders, (String)"extensionProviders");
        Intrinsics.checkNotNullParameter(customizers, (String)"customizers");
        Intrinsics.checkNotNullParameter((Object)dataLoaderOptionsProvider, (String)"dataLoaderOptionsProvider");
        Intrinsics.checkNotNullParameter((Object)scheduleDuration, (String)"scheduleDuration");
        this.applicationContext = applicationContext;
        this.scheduledExecutorService = scheduledExecutorService;
        this.extensionProviders = extensionProviders;
        this.customizers = customizers;
        this.dataLoaderOptionsProvider = dataLoaderOptionsProvider;
        this.scheduleDuration = scheduleDuration;
        this.enableTickerMode = enableTickerMode;
    }

    public /* synthetic */ ReloadableDgsDataLoaderProvider(ApplicationContext applicationContext, ScheduledExecutorService scheduledExecutorService, List list, List list2, DgsDataLoaderOptionsProvider dgsDataLoaderOptionsProvider, Duration duration, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            dgsDataLoaderOptionsProvider = new DefaultDataLoaderOptionsProvider();
        }
        if ((n & 0x20) != 0) {
            Duration duration2 = Duration.ofMillis(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
            duration = duration2;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        this(applicationContext, scheduledExecutorService, list, list2, dgsDataLoaderOptionsProvider, duration, bl);
    }

    @Nullable
    public final Instant getLastReloadTime() {
        return this.lastReloadTime;
    }

    public final boolean isInitialized() {
        return this.currentProvider != null;
    }

    @Override
    @NotNull
    public DataLoaderRegistry buildRegistry() {
        DefaultDgsDataLoaderProvider provider = this.getOrCreateProvider();
        return provider.buildRegistry();
    }

    @Override
    @NotNull
    public <T> DataLoaderRegistry buildRegistryWithContextSupplier(@NotNull Supplier<T> contextSupplier) {
        Intrinsics.checkNotNullParameter(contextSupplier, (String)"contextSupplier");
        DefaultDgsDataLoaderProvider provider = this.getOrCreateProvider();
        return provider.buildRegistryWithContextSupplier(contextSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DefaultDgsDataLoaderProvider getOrCreateProvider() {
        if (this.currentProvider == null) {
            ReloadableDgsDataLoaderProvider reloadableDgsDataLoaderProvider = this;
            synchronized (reloadableDgsDataLoaderProvider) {
                boolean bl = false;
                if (this.currentProvider == null) {
                    logger.info("Reloading data loaders due to indicator signal");
                    this.currentProvider = this.createNewProvider(this.applicationContext);
                    this.lastReloadTime = Instant.now();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        DefaultDgsDataLoaderProvider defaultDgsDataLoaderProvider = this.currentProvider;
        Intrinsics.checkNotNull((Object)defaultDgsDataLoaderProvider);
        return defaultDgsDataLoaderProvider;
    }

    private final DefaultDgsDataLoaderProvider createNewProvider(ApplicationContext applicationContext) {
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutorService;
        List<DataLoaderInstrumentationExtensionProvider> list = this.extensionProviders;
        List<DgsDataLoaderCustomizer> list2 = this.customizers;
        DgsDataLoaderOptionsProvider dgsDataLoaderOptionsProvider = this.dataLoaderOptionsProvider;
        Duration duration = this.scheduleDuration;
        boolean bl = this.enableTickerMode;
        DefaultDgsDataLoaderProvider newProvider = new DefaultDgsDataLoaderProvider(applicationContext, list, list2, dgsDataLoaderOptionsProvider, scheduledExecutorService, duration, bl);
        newProvider.findDataLoaders$graphql_dgs();
        return newProvider;
    }

    public final boolean forceReload() {
        return this.forceReload(this.applicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean forceReload(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        try {
            logger.info("Forcing reload data loaders for application context {},{}", (Object)applicationContext.getId(), (Object)applicationContext.getApplicationName());
            ReloadableDgsDataLoaderProvider reloadableDgsDataLoaderProvider = this;
            synchronized (reloadableDgsDataLoaderProvider) {
                boolean $i$a$-synchronized-ReloadableDgsDataLoaderProvider$forceReload$22 = false;
                this.currentProvider = this.createNewProvider(applicationContext);
                this.applicationContext = applicationContext;
                this.lastReloadTime = Instant.now();
                Unit $i$a$-synchronized-ReloadableDgsDataLoaderProvider$forceReload$22 = Unit.INSTANCE;
            }
            logger.debug("Reload application context successfully");
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to force reload of data loaders", (Throwable)e);
            return false;
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(ReloadableDgsDataLoaderProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ReloadableDgsDataLoaderProvider.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/internal/ReloadableDgsDataLoaderProvider$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

