/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.exceptions.DgsInvalidInputArgumentException;
import com.netflix.graphql.dgs.internal.InputObjectMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.CollectionUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J7\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0014H\u0002J3\u0010\u0015\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J7\u0010\u0018\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\b2\b\u0010\u001b\u001a\u0004\u0018\u0001H\bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\u001a\"\u0004\b\u0000\u0010\b2\b\u0010\u001b\u001a\u0004\u0018\u0001H\bH\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultInputObjectMapper;", "Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "customInputObjectMapper", "<init>", "(Lcom/netflix/graphql/dgs/internal/InputObjectMapper;)V", "conversionService", "Lorg/springframework/core/convert/support/DefaultConversionService;", "mapToKotlinObject", "T", "", "inputMap", "", "", "targetClass", "Lkotlin/reflect/KClass;", "(Ljava/util/Map;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "maybeConvert", "input", "parameterType", "Lkotlin/reflect/KType;", "Ljava/lang/reflect/Type;", "mapToJavaObject", "Ljava/lang/Class;", "(Ljava/util/Map;Ljava/lang/Class;)Ljava/lang/Object;", "handleRecordClass", "fieldAccessor", "Lorg/springframework/beans/ConfigurablePropertyAccessor;", "instance", "(Ljava/lang/Object;)Lorg/springframework/beans/ConfigurablePropertyAccessor;", "setterAccessor", "Companion", "Converter", "graphql-dgs"})
public final class DefaultInputObjectMapper
implements InputObjectMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultConversionService conversionService;
    @NotNull
    private static final Logger logger;

    public DefaultInputObjectMapper(@Nullable InputObjectMapper customInputObjectMapper) {
        this.conversionService = new DefaultConversionService();
        InputObjectMapper inputObjectMapper = customInputObjectMapper;
        if (inputObjectMapper == null) {
            inputObjectMapper = this;
        }
        this.conversionService.addConverter((GenericConverter)new Converter(inputObjectMapper));
    }

    public /* synthetic */ DefaultInputObjectMapper(InputObjectMapper inputObjectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            inputObjectMapper = null;
        }
        this(inputObjectMapper);
    }

    @Override
    @NotNull
    public <T> T mapToKotlinObject(@NotNull Map<String, ?> inputMap, @NotNull KClass<T> targetClass) {
        Object object;
        Intrinsics.checkNotNullParameter(inputMap, (String)"inputMap");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        KFunction kFunction = KClasses.getPrimaryConstructor(targetClass);
        if (kFunction == null) {
            throw new DgsInvalidInputArgumentException("No primary constructor found for class " + targetClass, null, 2, null);
        }
        KFunction constructor = kFunction;
        List parameters = constructor.getParameters();
        LinkedHashMap linkedHashMap = CollectionUtils.newLinkedHashMap((int)parameters.size());
        Intrinsics.checkNotNullExpressionValue((Object)linkedHashMap, (String)"newLinkedHashMap(...)");
        LinkedHashMap parametersByName = linkedHashMap;
        for (KParameter parameter : parameters) {
            if (!inputMap.containsKey(parameter.getName())) {
                if (parameter.isOptional()) continue;
                if (parameter.getType().isMarkedNullable()) {
                    ((Map)parametersByName).put(parameter, null);
                    continue;
                }
                throw new DgsInvalidInputArgumentException("No value specified for required parameter " + parameter.getName() + " of class " + targetClass, null, 2, null);
            }
            Object input = inputMap.get(parameter.getName());
            ((Map)parametersByName).put(parameter, this.maybeConvert(input, parameter.getType()));
        }
        try {
            object = constructor.callBy((Map)parametersByName);
        }
        catch (Exception ex) {
            throw new DgsInvalidInputArgumentException("Provided input arguments do not match arguments of data class `" + targetClass + "`", ex);
        }
        return (T)object;
    }

    private final Object maybeConvert(Object input, KType parameterType) {
        if (parameterType.getArguments().isEmpty() && KTypesJvm.getJvmErasure((KType)parameterType).isInstance(input)) {
            return input;
        }
        return this.maybeConvert(input, ReflectJvmMapping.getJavaType((KType)parameterType));
    }

    private final Object maybeConvert(Object input, Type parameterType) {
        TypeDescriptor targetType = null;
        if (parameterType instanceof Class) {
            if (((Class)parameterType).isInstance(input)) {
                return input;
            }
            TypeDescriptor typeDescriptor = TypeDescriptor.valueOf((Class)((Class)parameterType));
            Intrinsics.checkNotNullExpressionValue((Object)typeDescriptor, (String)"valueOf(...)");
            targetType = typeDescriptor;
        } else {
            targetType = new TypeDescriptor(ResolvableType.forType((Type)parameterType), null, null);
        }
        TypeDescriptor sourceType = TypeDescriptor.forObject((Object)input);
        try {
            return this.conversionService.convert(input, sourceType, targetType);
        }
        catch (ConversionException exc) {
            throw new DgsInvalidInputArgumentException("Failed to convert value " + input + " to " + targetType, (Exception)((Object)exc));
        }
    }

    @Override
    public <T> T mapToJavaObject(@NotNull Map<String, ?> inputMap, @NotNull Class<T> targetClass) {
        Intrinsics.checkNotNullParameter(inputMap, (String)"inputMap");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        if (targetClass.isAssignableFrom(inputMap.getClass())) {
            return (T)inputMap;
        }
        if (targetClass.isRecord()) {
            return this.handleRecordClass(inputMap, targetClass);
        }
        Constructor<T> constructor = targetClass.getDeclaredConstructor(new Class[0]);
        Intrinsics.checkNotNull(constructor, (String)"null cannot be cast to non-null type java.lang.reflect.Constructor<T of com.netflix.graphql.dgs.internal.DefaultInputObjectMapper.mapToJavaObject>");
        Constructor<T> ctor = constructor;
        ctor.trySetAccessible();
        T instance = ctor.newInstance(new Object[0]);
        ConfigurablePropertyAccessor setterAccessor = this.setterAccessor(instance);
        ConfigurablePropertyAccessor fieldAccessor = this.fieldAccessor(instance);
        int nrOfPropertyErrors = 0;
        for (Map.Entry<String, ?> entry : inputMap.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            try {
                if (setterAccessor.isWritableProperty(name)) {
                    setterAccessor.setPropertyValue(name, value);
                    continue;
                }
                if (fieldAccessor.isWritableProperty(name)) {
                    fieldAccessor.setPropertyValue(name, value);
                    continue;
                }
                ++nrOfPropertyErrors;
                logger.warn("Field or property '{}' was not found on Input object of type '{}'", (Object)name, targetClass);
            }
            catch (Exception ex) {
                throw new DgsInvalidInputArgumentException("Invalid input argument `" + value + "` for field/property `" + name + "` on type `" + targetClass.getName() + "`", ex);
            }
        }
        if (!inputMap.isEmpty() && nrOfPropertyErrors == inputMap.size()) {
            throw new DgsInvalidInputArgumentException("Input argument type '" + targetClass + "' doesn't match input " + inputMap, null, 2, null);
        }
        return instance;
    }

    private final <T> T handleRecordClass(Map<String, ? extends Object> inputMap, Class<T> targetClass) {
        RecordComponent[] recordComponents = targetClass.getRecordComponents();
        Object[] args = new Object[recordComponents.length];
        Intrinsics.checkNotNull((Object)recordComponents);
        RecordComponent[] recordComponentArray = recordComponents;
        int n = recordComponentArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            RecordComponent component = recordComponentArray[i];
            if (!inputMap.containsKey(component.getName())) continue;
            Object object = inputMap.get(component.getName());
            Type type = component.getGenericType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getGenericType(...)");
            args[index] = this.maybeConvert(object, type);
        }
        Constructor<?>[] constructorArray = targetClass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getDeclaredConstructors(...)");
        Object object = ArraysKt.first((Object[])constructorArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.reflect.Constructor<T of com.netflix.graphql.dgs.internal.DefaultInputObjectMapper.handleRecordClass>");
        Constructor ctor = (Constructor)object;
        ctor.trySetAccessible();
        try {
            return ctor.newInstance(Arrays.copyOf(args, args.length));
        }
        catch (ReflectiveOperationException exc) {
            throw new DgsInvalidInputArgumentException("Failed to construct record, class=" + targetClass.getSimpleName(), exc);
        }
    }

    private final <T> ConfigurablePropertyAccessor fieldAccessor(T instance) {
        Intrinsics.checkNotNull(instance, (String)"null cannot be cast to non-null type kotlin.Any");
        ConfigurablePropertyAccessor configurablePropertyAccessor = PropertyAccessorFactory.forDirectFieldAccess(instance);
        Intrinsics.checkNotNullExpressionValue((Object)configurablePropertyAccessor, (String)"forDirectFieldAccess(...)");
        ConfigurablePropertyAccessor accessor = configurablePropertyAccessor;
        accessor.setConversionService((ConversionService)this.conversionService);
        return accessor;
    }

    private final <T> ConfigurablePropertyAccessor setterAccessor(T instance) {
        Intrinsics.checkNotNull(instance, (String)"null cannot be cast to non-null type kotlin.Any");
        BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess(instance);
        Intrinsics.checkNotNullExpressionValue((Object)beanWrapper, (String)"forBeanPropertyAccess(...)");
        BeanWrapper accessor = beanWrapper;
        accessor.setConversionService((ConversionService)this.conversionService);
        return (ConfigurablePropertyAccessor)accessor;
    }

    public DefaultInputObjectMapper() {
        this(null, 1, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(InputObjectMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DefaultInputObjectMapper.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultInputObjectMapper$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J$\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultInputObjectMapper$Converter;", "Lorg/springframework/core/convert/converter/ConditionalGenericConverter;", "mapper", "Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "<init>", "(Lcom/netflix/graphql/dgs/internal/InputObjectMapper;)V", "getConvertibleTypes", "", "Lorg/springframework/core/convert/converter/GenericConverter$ConvertiblePair;", "matches", "", "sourceType", "Lorg/springframework/core/convert/TypeDescriptor;", "targetType", "convert", "", "source", "graphql-dgs"})
    private static final class Converter
    implements ConditionalGenericConverter {
        @NotNull
        private final InputObjectMapper mapper;

        public Converter(@NotNull InputObjectMapper mapper) {
            Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
            this.mapper = mapper;
        }

        @NotNull
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return SetsKt.setOf((Object)new GenericConverter.ConvertiblePair(Map.class, Object.class));
        }

        public boolean matches(@NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
            Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            if (Intrinsics.areEqual((Object)targetType.getType(), Optional.class)) {
                return false;
            }
            if (sourceType.isMap()) {
                TypeDescriptor keyDescriptor = sourceType.getMapKeyTypeDescriptor();
                return keyDescriptor == null || Intrinsics.areEqual((Object)keyDescriptor.getType(), String.class);
            }
            return false;
        }

        @Nullable
        public Object convert(@Nullable Object source, @NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
            Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Intrinsics.checkNotNull((Object)source, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            Map sourceMap = (Map)source;
            if (KotlinDetector.isKotlinType((Class)targetType.getType())) {
                Class clazz = targetType.getType();
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getType(...)");
                return this.mapper.mapToKotlinObject(sourceMap, JvmClassMappingKt.getKotlinClass((Class)clazz));
            }
            Class clazz = targetType.getType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getType(...)");
            return this.mapper.mapToJavaObject(sourceMap, clazz);
        }
    }
}

