/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DgsDataLoaderReloadController;
import com.netflix.graphql.dgs.internal.ReloadableDgsDataLoaderProvider;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderReloadController;", "Lcom/netflix/graphql/dgs/DgsDataLoaderReloadController;", "reloadableProvider", "Lcom/netflix/graphql/dgs/internal/ReloadableDgsDataLoaderProvider;", "<init>", "(Lcom/netflix/graphql/dgs/internal/ReloadableDgsDataLoaderProvider;)V", "lastReloadTime", "Ljava/time/Instant;", "lastReloadDuration", "", "Ljava/lang/Long;", "totalReloads", "Ljava/util/concurrent/atomic/AtomicLong;", "reloadDataLoaders", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "isReloadEnabled", "getLastReloadTime", "getReloadStats", "Lcom/netflix/graphql/dgs/DgsDataLoaderReloadController$DgsDataLoaderReloadStats;", "Companion", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDefaultDgsDataLoaderReloadController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDgsDataLoaderReloadController.kt\ncom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderReloadController\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,171:1\n29#2,3:172\n29#2,3:175\n*S KotlinDebug\n*F\n+ 1 DefaultDgsDataLoaderReloadController.kt\ncom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderReloadController\n*L\n65#1:172,3\n103#1:175,3\n*E\n"})
public final class DefaultDgsDataLoaderReloadController
implements DgsDataLoaderReloadController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReloadableDgsDataLoaderProvider reloadableProvider;
    @Nullable
    private volatile Instant lastReloadTime;
    @Nullable
    private volatile Long lastReloadDuration;
    @NotNull
    private final AtomicLong totalReloads;
    @NotNull
    private static final Logger logger;

    public DefaultDgsDataLoaderReloadController(@NotNull ReloadableDgsDataLoaderProvider reloadableProvider) {
        Intrinsics.checkNotNullParameter((Object)reloadableProvider, (String)"reloadableProvider");
        this.reloadableProvider = reloadableProvider;
        this.totalReloads = new AtomicLong(0L);
    }

    @Override
    public boolean reloadDataLoaders() {
        boolean bl;
        logger.info("Programmatic data loader reload requested");
        try {
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl2 = false;
            boolean success = this.reloadableProvider.forceReload();
            if (!success) {
                logger.warn("Data loader reload reported failure");
                return false;
            }
            long duration = System.currentTimeMillis() - start$iv;
            this.lastReloadTime = Instant.now();
            this.lastReloadDuration = duration;
            this.totalReloads.incrementAndGet();
            logger.info("Data loader reload completed successfully in {}ms", (Object)duration);
            bl = true;
        }
        catch (Exception e) {
            logger.error("Failed to reload data loaders", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean reloadDataLoaders(@NotNull ApplicationContext applicationContext) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        logger.info("Programmatic data loader reload requested for application context {}:{}.", (Object)applicationContext.getId(), (Object)applicationContext.getApplicationName());
        try {
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl2 = false;
            boolean success = this.reloadableProvider.forceReload(applicationContext);
            if (!success) {
                logger.warn("Unsuccessful data loader reload reported for application context {}:{}.", (Object)applicationContext.getId(), (Object)applicationContext.getApplicationName());
                return false;
            }
            long duration = System.currentTimeMillis() - start$iv;
            this.lastReloadTime = Instant.now();
            this.lastReloadDuration = duration;
            this.totalReloads.incrementAndGet();
            Object[] objectArray = new Object[]{duration, applicationContext.getId(), applicationContext.getApplicationName()};
            logger.info("Data loader reload completed successfully in {}ms {}:{}", objectArray);
            bl = true;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{applicationContext.getId(), applicationContext.getApplicationName(), e};
            logger.error("Failed to reload data loader for application context {}:{}.", objectArray);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isReloadEnabled() {
        return true;
    }

    @Override
    @Nullable
    public Instant getLastReloadTime() {
        return this.lastReloadTime;
    }

    @Override
    @NotNull
    public DgsDataLoaderReloadController.DgsDataLoaderReloadStats getReloadStats() {
        return new DgsDataLoaderReloadController.DgsDataLoaderReloadStats(this.totalReloads.get(), this.lastReloadTime, this.lastReloadDuration, true);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDgsDataLoaderReloadController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DefaultDgsDataLoaderReloadController.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderReloadController$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

