/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DataLoaderInstrumentationExtensionProvider;
import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.DgsDataLoaderCustomizer;
import com.netflix.graphql.dgs.DgsDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.DgsDataLoaderRegistryConsumer;
import com.netflix.graphql.dgs.DgsDispatchPredicate;
import com.netflix.graphql.dgs.exceptions.DgsUnnamedDataLoaderOnFieldException;
import com.netflix.graphql.dgs.exceptions.InvalidDataLoaderTypeException;
import com.netflix.graphql.dgs.exceptions.MultipleDataLoadersDefinedException;
import com.netflix.graphql.dgs.exceptions.UnsupportedSecuredDataLoaderException;
import com.netflix.graphql.dgs.internal.DefaultDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.internal.DefaultDgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.utils.DataLoaderNameUtil;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.dataloader.registries.DispatchPredicate;
import org.dataloader.registries.ScheduledDataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 H2\u00020\u0001:\u0002GHBW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010!\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u00020\"\"\u0004\b\u0000\u0010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0&H\u0016J\r\u0010'\u001a\u00020(H\u0001\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020(H\u0002JG\u0010,\u001a\u00020(\"\b\b\u0000\u0010$*\u00020-2\u0006\u0010.\u001a\u0002H$2\u0006\u0010/\u001a\u00020\u00152\n\u00100\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u00101\u001a\u0002022\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0002\u00a2\u0006\u0002\u00105J$\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020-2\u0006\u00108\u001a\u00020\u00152\n\u00100\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002JF\u00109\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030:2\u000e\u0010;\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a2\u0006\u0010<\u001a\u0002022\u0006\u0010/\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\"2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060>H\u0002JF\u00109\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030:2\u000e\u0010;\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e2\u0006\u0010<\u001a\u0002022\u0006\u0010/\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\"2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060>H\u0002J^\u00109\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030:\"\b\b\u0000\u0010$*\u00020-2\u000e\u0010;\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001c2\u0006\u0010<\u001a\u0002022\u0006\u0010/\u001a\u00020\u00152\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H$0&2\u0006\u0010=\u001a\u00020\"2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060>H\u0002J^\u00109\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030:\"\b\b\u0000\u0010$*\u00020-2\u000e\u0010;\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030 2\u0006\u0010<\u001a\u0002022\u0006\u0010/\u001a\u00020\u00152\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H$0&2\u0006\u0010=\u001a\u00020\"2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060>H\u0002J6\u0010@\u001a\u00020(2\n\u0010A\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010B\u001a\u00020C2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060>H\u0002J4\u0010D\u001a\u0002H$\"\u0006\b\u0000\u0010$\u0018\u00012\u0006\u0010E\u001a\u0002H$2\u0006\u00108\u001a\u00020\u00152\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060>H\u0082\b\u00a2\u0006\u0002\u0010FR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001c0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001d\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030 0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderProvider;", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "extensionProviders", "", "Lcom/netflix/graphql/dgs/DataLoaderInstrumentationExtensionProvider;", "customizers", "Lcom/netflix/graphql/dgs/DgsDataLoaderCustomizer;", "dataLoaderOptionsProvider", "Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "scheduleDuration", "Ljava/time/Duration;", "enableTickerMode", "", "<init>", "(Lorg/springframework/context/ApplicationContext;Ljava/util/List;Ljava/util/List;Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;Ljava/util/concurrent/ScheduledExecutorService;Ljava/time/Duration;Z)V", "dataLoaders", "", "", "Ljava/lang/Class;", "batchLoaders", "", "Lcom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderProvider$LoaderHolder;", "Lorg/dataloader/BatchLoader;", "batchLoadersWithContext", "Lorg/dataloader/BatchLoaderWithContext;", "mappedBatchLoaders", "Lorg/dataloader/MappedBatchLoader;", "mappedBatchLoadersWithContext", "Lorg/dataloader/MappedBatchLoaderWithContext;", "buildRegistry", "Lorg/dataloader/DataLoaderRegistry;", "buildRegistryWithContextSupplier", "T", "contextSupplier", "Ljava/util/function/Supplier;", "findDataLoaders", "", "findDataLoaders$graphql_dgs", "addDataLoaderFields", "addDataLoaderComponents", "addDataLoader", "", "dataLoader", "dataLoaderName", "dgsComponentClass", "annotation", "Lcom/netflix/graphql/dgs/DgsDataLoader;", "dispatchPredicate", "Lorg/dataloader/registries/DispatchPredicate;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Class;Lcom/netflix/graphql/dgs/DgsDataLoader;Lorg/dataloader/registries/DispatchPredicate;)V", "runCustomizers", "originalDataLoader", "name", "createDataLoader", "Lorg/dataloader/DataLoader;", "batchLoader", "dgsDataLoader", "dataLoaderRegistry", "", "supplier", "registerDataLoader", "holder", "registry", "Lorg/dataloader/registries/ScheduledDataLoaderRegistry;", "wrappedDataLoader", "loader", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Iterable;)Ljava/lang/Object;", "LoaderHolder", "Companion", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDefaultDgsDataLoaderProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDgsDataLoaderProvider.kt\ncom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderProvider\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,392:1\n359#1,5:413\n364#1,22:420\n359#1,5:442\n364#1,22:449\n359#1,5:471\n364#1,22:478\n359#1,5:500\n364#1,22:507\n29#2,2:393\n31#2:403\n1869#3,2:395\n1869#3,2:397\n1869#3,2:399\n1869#3,2:401\n1869#3:404\n1870#3:407\n1869#3,2:411\n1869#3,2:418\n1869#3,2:447\n1869#3,2:476\n1869#3,2:505\n1869#3,2:529\n1869#3,2:531\n1869#3,2:533\n1869#3,2:535\n1321#4,2:405\n216#5:408\n217#5:410\n1#6:409\n*S KotlinDebug\n*F\n+ 1 DefaultDgsDataLoaderProvider.kt\ncom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderProvider\n*L\n231#1:413,5\n231#1:420,22\n247#1:442,5\n247#1:449,22\n269#1:471,5\n269#1:478,22\n290#1:500,5\n290#1:507,22\n96#1:393,2\n96#1:403\n97#1:395,2\n98#1:397,2\n99#1:399,2\n100#1:401,2\n114#1:404\n114#1:407\n204#1:411,2\n231#1:418,2\n247#1:447,2\n269#1:476,2\n290#1:505,2\n363#1:529,2\n368#1:531,2\n373#1:533,2\n378#1:535,2\n120#1:405,2\n139#1:408\n139#1:410\n*E\n"})
public final class DefaultDgsDataLoaderProvider
implements DgsDataLoaderProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final List<DataLoaderInstrumentationExtensionProvider> extensionProviders;
    @NotNull
    private final List<DgsDataLoaderCustomizer> customizers;
    @NotNull
    private final DgsDataLoaderOptionsProvider dataLoaderOptionsProvider;
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    private final Duration scheduleDuration;
    private final boolean enableTickerMode;
    @NotNull
    private final Map<String, Class<?>> dataLoaders;
    @NotNull
    private final List<LoaderHolder<BatchLoader<?, ?>>> batchLoaders;
    @NotNull
    private final List<LoaderHolder<BatchLoaderWithContext<?, ?>>> batchLoadersWithContext;
    @NotNull
    private final List<LoaderHolder<MappedBatchLoader<?, ?>>> mappedBatchLoaders;
    @NotNull
    private final List<LoaderHolder<MappedBatchLoaderWithContext<?, ?>>> mappedBatchLoadersWithContext;
    @NotNull
    private static final Logger logger;

    public DefaultDgsDataLoaderProvider(@NotNull ApplicationContext applicationContext, @NotNull List<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders, @NotNull List<? extends DgsDataLoaderCustomizer> customizers, @NotNull DgsDataLoaderOptionsProvider dataLoaderOptionsProvider, @NotNull ScheduledExecutorService scheduledExecutorService, @NotNull Duration scheduleDuration, boolean enableTickerMode) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(extensionProviders, (String)"extensionProviders");
        Intrinsics.checkNotNullParameter(customizers, (String)"customizers");
        Intrinsics.checkNotNullParameter((Object)dataLoaderOptionsProvider, (String)"dataLoaderOptionsProvider");
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorService, (String)"scheduledExecutorService");
        Intrinsics.checkNotNullParameter((Object)scheduleDuration, (String)"scheduleDuration");
        this.applicationContext = applicationContext;
        this.extensionProviders = extensionProviders;
        this.customizers = customizers;
        this.dataLoaderOptionsProvider = dataLoaderOptionsProvider;
        this.scheduledExecutorService = scheduledExecutorService;
        this.scheduleDuration = scheduleDuration;
        this.enableTickerMode = enableTickerMode;
        this.dataLoaders = new LinkedHashMap();
        this.batchLoaders = new ArrayList();
        this.batchLoadersWithContext = new ArrayList();
        this.mappedBatchLoaders = new ArrayList();
        this.mappedBatchLoadersWithContext = new ArrayList();
    }

    public /* synthetic */ DefaultDgsDataLoaderProvider(ApplicationContext applicationContext, List list, List list2, DgsDataLoaderOptionsProvider dgsDataLoaderOptionsProvider, ScheduledExecutorService scheduledExecutorService, Duration duration, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            dgsDataLoaderOptionsProvider = new DefaultDataLoaderOptionsProvider();
        }
        if ((n & 0x10) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"newSingleThreadScheduledExecutor(...)");
            scheduledExecutorService = scheduledExecutorService2;
        }
        if ((n & 0x20) != 0) {
            Duration duration2 = Duration.ofMillis(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
            duration = duration2;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        this(applicationContext, list, list2, dgsDataLoaderOptionsProvider, scheduledExecutorService, duration, bl);
    }

    @Override
    @NotNull
    public DataLoaderRegistry buildRegistry() {
        return this.buildRegistryWithContextSupplier(buildRegistry.1.INSTANCE);
    }

    @Override
    @NotNull
    public <T> DataLoaderRegistry buildRegistryWithContextSupplier(@NotNull Supplier<T> contextSupplier) {
        LoaderHolder it;
        Intrinsics.checkNotNullParameter(contextSupplier, (String)"contextSupplier");
        ScheduledDataLoaderRegistry scheduledDataLoaderRegistry = ScheduledDataLoaderRegistry.newScheduledRegistry().scheduledExecutorService(this.scheduledExecutorService).tickerMode(this.enableTickerMode).schedule(this.scheduleDuration).dispatchPredicate(DispatchPredicate.DISPATCH_NEVER).build();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledDataLoaderRegistry, (String)"build(...)");
        ScheduledDataLoaderRegistry registry = scheduledDataLoaderRegistry;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Iterable $this$forEach$iv = this.batchLoaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl2 = false;
            this.registerDataLoader(it, registry, contextSupplier, (Iterable<? extends DataLoaderInstrumentationExtensionProvider>)this.extensionProviders);
        }
        $this$forEach$iv = this.batchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl3 = false;
            this.registerDataLoader(it, registry, contextSupplier, (Iterable<? extends DataLoaderInstrumentationExtensionProvider>)this.extensionProviders);
        }
        $this$forEach$iv = this.mappedBatchLoaders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl4 = false;
            this.registerDataLoader(it, registry, contextSupplier, (Iterable<? extends DataLoaderInstrumentationExtensionProvider>)this.extensionProviders);
        }
        $this$forEach$iv = this.mappedBatchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl5 = false;
            this.registerDataLoader(it, registry, contextSupplier, (Iterable<? extends DataLoaderInstrumentationExtensionProvider>)this.extensionProviders);
        }
        long totalTime = System.currentTimeMillis() - start$iv;
        logger.debug("Created DGS dataloader registry in {}ms", (Object)totalTime);
        return (DataLoaderRegistry)registry;
    }

    @PostConstruct
    public final void findDataLoaders$graphql_dgs() {
        this.addDataLoaderComponents();
        this.addDataLoaderFields();
    }

    /*
     * WARNING - void declaration
     */
    private final void addDataLoaderFields() {
        Map map = this.applicationContext.getBeansWithAnnotation(DgsComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getBeansWithAnnotation(...)");
        Map dataLoaders = map;
        Iterable $this$forEach$iv = dataLoaders.values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Class javaClass;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)AopUtils.getTargetClass(dgsComponent), (String)"getTargetClass(...)");
            Field[] fieldArray = javaClass.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])fieldArray), DefaultDgsDataLoaderProvider::addDataLoaderFields$lambda$0$0);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl2 = false;
                if (AopUtils.isAopProxy(dgsComponent)) {
                    throw new UnsupportedSecuredDataLoaderException(dgsComponent.getClass());
                }
                DgsDataLoader annotation = field.getAnnotation(DgsDataLoader.class);
                ReflectionUtils.makeAccessible((Field)field);
                if (Intrinsics.areEqual((Object)annotation.name(), (Object)"NETFLIX_DGS_GENERATE_DATALOADER_NAME")) {
                    Intrinsics.checkNotNull((Object)field);
                    throw new DgsUnnamedDataLoaderOnFieldException(field);
                }
                Object object = field.get(dgsComponent);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                String string = annotation.name();
                Class<?> clazz = dgsComponent.getClass();
                Intrinsics.checkNotNull((Object)annotation);
                DefaultDgsDataLoaderProvider.addDataLoader$default(this, object, string, clazz, annotation, null, 16, null);
            }
        }
    }

    private final void addDataLoaderComponents() {
        Map dataLoaders;
        Map map = this.applicationContext.getBeansWithAnnotation(DgsDataLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getBeansWithAnnotation(...)");
        Map $this$forEach$iv = dataLoaders = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Method method;
            BeanDefinition beanDefinition;
            Class javaClass;
            Object beanInstance;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            String beanName = (String)k;
            Intrinsics.checkNotNullExpressionValue(entry.getValue(), (String)"component2(...)");
            Intrinsics.checkNotNullExpressionValue((Object)AopUtils.getTargetClass(beanInstance), (String)"getTargetClass(...)");
            DgsDataLoader annotation = javaClass.getAnnotation(DgsDataLoader.class);
            if (annotation != null) {
                Object object;
                String dataLoaderName;
                block4: {
                    dataLoaderName = DataLoaderNameUtil.INSTANCE.getDataLoaderName(javaClass, annotation);
                    Field[] fieldArray = javaClass.getDeclaredFields();
                    Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
                    for (Object object2 : (Object[])fieldArray) {
                        Field it = (Field)object2;
                        boolean bl2 = false;
                        if (!it.isAnnotationPresent(DgsDispatchPredicate.class)) continue;
                        object = object2;
                        break block4;
                    }
                    object = null;
                }
                Field predicateField = (Field)object;
                if (predicateField != null) {
                    ReflectionUtils.makeAccessible((Field)predicateField);
                    Object dispatchPredicate = predicateField.get(beanInstance);
                    if (!(dispatchPredicate instanceof DispatchPredicate)) continue;
                    this.addDataLoader(beanInstance, dataLoaderName, javaClass, annotation, (DispatchPredicate)dispatchPredicate);
                    continue;
                }
                DefaultDgsDataLoaderProvider.addDataLoader$default(this, beanInstance, dataLoaderName, javaClass, annotation, null, 16, null);
                continue;
            }
            if (!(this.applicationContext instanceof ConfigurableApplicationContext)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().getBeanDefinition(beanName), (String)"getBeanDefinition(...)");
            if (!(beanDefinition.getSource() instanceof StandardMethodMetadata)) continue;
            Object object = beanDefinition.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.springframework.core.type.StandardMethodMetadata");
            StandardMethodMetadata methodMetadata = (StandardMethodMetadata)object;
            Intrinsics.checkNotNullExpressionValue((Object)methodMetadata.getIntrospectedMethod(), (String)"getIntrospectedMethod(...)");
            DgsDataLoader methodAnnotation = method.getAnnotation(DgsDataLoader.class);
            if (methodAnnotation == null) continue;
            String dataLoaderName = DataLoaderNameUtil.INSTANCE.getDataLoaderName(javaClass, methodAnnotation);
            this.addDataLoader(beanInstance, dataLoaderName, javaClass, methodAnnotation, null);
        }
    }

    private final <T> void addDataLoader(T dataLoader, String dataLoaderName, Class<?> dgsComponentClass, DgsDataLoader annotation, DispatchPredicate dispatchPredicate) {
        if (this.dataLoaders.containsKey(dataLoaderName)) {
            Class[] classArray = new Class[]{dgsComponentClass, MapsKt.getValue(this.dataLoaders, (Object)dataLoaderName)};
            throw new MultipleDataLoadersDefinedException(classArray);
        }
        this.dataLoaders.put(dataLoaderName, dgsComponentClass);
        Object customizedDataLoader = this.runCustomizers(dataLoader, dataLoaderName, dgsComponentClass);
        if (customizedDataLoader instanceof BatchLoader) {
            v0 = this.batchLoaders.add(DefaultDgsDataLoaderProvider.addDataLoader$createHolder(annotation, dataLoaderName, dispatchPredicate, customizedDataLoader));
        } else if (customizedDataLoader instanceof BatchLoaderWithContext) {
            v0 = this.batchLoadersWithContext.add(DefaultDgsDataLoaderProvider.addDataLoader$createHolder(annotation, dataLoaderName, dispatchPredicate, customizedDataLoader));
        } else if (customizedDataLoader instanceof MappedBatchLoader) {
            v0 = this.mappedBatchLoaders.add(DefaultDgsDataLoaderProvider.addDataLoader$createHolder(annotation, dataLoaderName, dispatchPredicate, customizedDataLoader));
        } else if (customizedDataLoader instanceof MappedBatchLoaderWithContext) {
            v0 = this.mappedBatchLoadersWithContext.add(DefaultDgsDataLoaderProvider.addDataLoader$createHolder(annotation, dataLoaderName, dispatchPredicate, customizedDataLoader));
        } else {
            throw new InvalidDataLoaderTypeException(dgsComponentClass);
        }
    }

    static /* synthetic */ void addDataLoader$default(DefaultDgsDataLoaderProvider defaultDgsDataLoaderProvider, Object object, String string, Class clazz, DgsDataLoader dgsDataLoader, DispatchPredicate dispatchPredicate, int n, Object object2) {
        if ((n & 0x10) != 0) {
            dispatchPredicate = null;
        }
        defaultDgsDataLoaderProvider.addDataLoader(object, string, clazz, dgsDataLoader, dispatchPredicate);
    }

    private final Object runCustomizers(Object originalDataLoader, String name, Class<?> dgsComponentClass) {
        Object dataLoader = null;
        dataLoader = originalDataLoader;
        Iterable $this$forEach$iv = this.customizers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            DgsDataLoaderCustomizer it = (DgsDataLoaderCustomizer)element$iv;
            boolean bl = false;
            Object object2 = dataLoader;
            if (object2 instanceof BatchLoader) {
                Object object3 = dataLoader;
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                object = it.provide((BatchLoader)object3, name);
            } else if (object2 instanceof BatchLoaderWithContext) {
                Object object4 = dataLoader;
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                object = it.provide((BatchLoaderWithContext)object4, name);
            } else if (object2 instanceof MappedBatchLoader) {
                Object object5 = dataLoader;
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                object = it.provide((MappedBatchLoader)object5, name);
            } else if (object2 instanceof MappedBatchLoaderWithContext) {
                Object object6 = dataLoader;
                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                object = it.provide((MappedBatchLoaderWithContext)object6, name);
            } else {
                throw new InvalidDataLoaderTypeException(dgsComponentClass);
            }
            dataLoader = object;
        }
        return dataLoader;
    }

    /*
     * WARNING - void declaration
     */
    private final DataLoader<?, ?> createDataLoader(BatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        BatchLoader<?, ?> batchLoader2;
        DataLoaderOptions.Builder options;
        block14: {
            void loader$iv;
            block15: {
                void name$iv;
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DefaultDgsDataLoaderProvider defaultDgsDataLoaderProvider = this;
                BatchLoader<?, ?> batchLoader3 = batchLoader;
                String string = dataLoaderName;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders$iv = extensionProviders;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    BatchLoader<?, ?> wrappedBatchLoader$iv;
                    void var13_12 = loader$iv;
                    if (var13_12 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, (String)name$iv);
                        }
                        batchLoader2 = wrappedBatchLoader$iv;
                        if (batchLoader2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        break block14;
                    }
                    if (var13_12 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoaderWithContext)wrappedBatchLoader$iv, (String)name$iv);
                        }
                        BatchLoader<?, ?> batchLoader4 = wrappedBatchLoader$iv;
                        if (batchLoader4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = batchLoader4;
                        break block14;
                    }
                    if (var13_12 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoader)wrappedBatchLoader$iv, (String)name$iv);
                        }
                        BatchLoader<?, ?> batchLoader5 = wrappedBatchLoader$iv;
                        if (batchLoader5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = batchLoader5;
                        break block14;
                    }
                    if (!(var13_12 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = loader$iv;
                    $this$forEach$iv$iv = extensionProviders$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoaderWithContext)wrappedBatchLoader$iv, (String)name$iv);
                    }
                    BatchLoader<?, ?> batchLoader6 = wrappedBatchLoader$iv;
                    if (batchLoader6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                    }
                    batchLoader2 = batchLoader6;
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{name$iv, loader$iv, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            batchLoader2 = loader$iv;
        }
        void extendedBatchLoader = batchLoader2;
        DataLoader dataLoader = DataLoaderFactory.newDataLoader((String)dataLoaderName, (BatchLoader)extendedBatchLoader, (DataLoaderOptions)options.build());
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newDataLoader(...)");
        return dataLoader;
    }

    /*
     * WARNING - void declaration
     */
    private final DataLoader<?, ?> createDataLoader(MappedBatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        MappedBatchLoader mappedBatchLoader;
        DataLoaderOptions.Builder options;
        block14: {
            void loader$iv;
            block15: {
                void name$iv;
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DefaultDgsDataLoaderProvider defaultDgsDataLoaderProvider = this;
                MappedBatchLoader<?, ?> mappedBatchLoader2 = batchLoader;
                String string = dataLoaderName;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders$iv = extensionProviders;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    MappedBatchLoader wrappedBatchLoader$iv;
                    void var13_12 = loader$iv;
                    if (var13_12 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoader)wrappedBatchLoader$iv, (String)name$iv);
                        }
                        MappedBatchLoader mappedBatchLoader3 = wrappedBatchLoader$iv;
                        if (mappedBatchLoader3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = mappedBatchLoader3;
                        break block14;
                    }
                    if (var13_12 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoaderWithContext)wrappedBatchLoader$iv, (String)name$iv);
                        }
                        MappedBatchLoader mappedBatchLoader4 = wrappedBatchLoader$iv;
                        if (mappedBatchLoader4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = mappedBatchLoader4;
                        break block14;
                    }
                    if (var13_12 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, (String)name$iv);
                        }
                        mappedBatchLoader = wrappedBatchLoader$iv;
                        if (mappedBatchLoader == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        break block14;
                    }
                    if (!(var13_12 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = loader$iv;
                    $this$forEach$iv$iv = extensionProviders$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoaderWithContext)wrappedBatchLoader$iv, (String)name$iv);
                    }
                    MappedBatchLoader mappedBatchLoader5 = wrappedBatchLoader$iv;
                    if (mappedBatchLoader5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                    }
                    mappedBatchLoader = mappedBatchLoader5;
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{name$iv, loader$iv, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            mappedBatchLoader = loader$iv;
        }
        void extendedBatchLoader = mappedBatchLoader;
        DataLoader dataLoader = DataLoaderFactory.newMappedDataLoader((MappedBatchLoader)extendedBatchLoader, (DataLoaderOptions)options.build());
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newMappedDataLoader(...)");
        return dataLoader;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> DataLoader<?, ?> createDataLoader(BatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        BatchLoaderWithContext batchLoaderWithContext;
        DataLoaderOptions.Builder options;
        block14: {
            void loader$iv;
            block15: {
                void name$iv;
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader).setBatchLoaderContextProvider(supplier::get);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DefaultDgsDataLoaderProvider defaultDgsDataLoaderProvider = this;
                BatchLoaderWithContext<?, ?> batchLoaderWithContext2 = batchLoader;
                String string = dataLoaderName;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders$iv = extensionProviders;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    BatchLoaderWithContext wrappedBatchLoader$iv;
                    void var14_13 = loader$iv;
                    if (var14_13 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoader)wrappedBatchLoader$iv, (String)name$iv);
                        }
                        BatchLoaderWithContext batchLoaderWithContext3 = wrappedBatchLoader$iv;
                        if (batchLoaderWithContext3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = batchLoaderWithContext3;
                        break block14;
                    }
                    if (var14_13 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, (String)name$iv);
                        }
                        batchLoaderWithContext = wrappedBatchLoader$iv;
                        if (batchLoaderWithContext == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        break block14;
                    }
                    if (var14_13 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoader)wrappedBatchLoader$iv, (String)name$iv);
                        }
                        BatchLoaderWithContext batchLoaderWithContext4 = wrappedBatchLoader$iv;
                        if (batchLoaderWithContext4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = batchLoaderWithContext4;
                        break block14;
                    }
                    if (!(var14_13 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = loader$iv;
                    $this$forEach$iv$iv = extensionProviders$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoaderWithContext)wrappedBatchLoader$iv, (String)name$iv);
                    }
                    BatchLoaderWithContext batchLoaderWithContext5 = wrappedBatchLoader$iv;
                    if (batchLoaderWithContext5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                    }
                    batchLoaderWithContext = batchLoaderWithContext5;
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{name$iv, loader$iv, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            batchLoaderWithContext = loader$iv;
        }
        void extendedBatchLoader = batchLoaderWithContext;
        DataLoader dataLoader = DataLoaderFactory.newDataLoader((String)dataLoaderName, (BatchLoaderWithContext)extendedBatchLoader, (DataLoaderOptions)options.build());
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newDataLoader(...)");
        return dataLoader;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> DataLoader<?, ?> createDataLoader(MappedBatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        MappedBatchLoaderWithContext mappedBatchLoaderWithContext;
        DataLoaderOptions.Builder options;
        block14: {
            void loader$iv;
            block15: {
                void name$iv;
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader).setBatchLoaderContextProvider(supplier::get);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DefaultDgsDataLoaderProvider defaultDgsDataLoaderProvider = this;
                MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext2 = batchLoader;
                String string = dataLoaderName;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders$iv = extensionProviders;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    MappedBatchLoaderWithContext wrappedBatchLoader$iv;
                    void var14_13 = loader$iv;
                    if (var14_13 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoader)wrappedBatchLoader$iv, (String)name$iv);
                        }
                        MappedBatchLoaderWithContext mappedBatchLoaderWithContext3 = wrappedBatchLoader$iv;
                        if (mappedBatchLoaderWithContext3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = mappedBatchLoaderWithContext3;
                        break block14;
                    }
                    if (var14_13 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoaderWithContext)wrappedBatchLoader$iv, (String)name$iv);
                        }
                        MappedBatchLoaderWithContext mappedBatchLoaderWithContext4 = wrappedBatchLoader$iv;
                        if (mappedBatchLoaderWithContext4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = mappedBatchLoaderWithContext4;
                        break block14;
                    }
                    if (var14_13 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = loader$iv;
                        $this$forEach$iv$iv = extensionProviders$iv;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoader)wrappedBatchLoader$iv, (String)name$iv);
                        }
                        MappedBatchLoaderWithContext mappedBatchLoaderWithContext5 = wrappedBatchLoader$iv;
                        if (mappedBatchLoaderWithContext5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = mappedBatchLoaderWithContext5;
                        break block14;
                    }
                    if (!(var14_13 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = loader$iv;
                    $this$forEach$iv$iv = extensionProviders$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, (String)name$iv);
                    }
                    mappedBatchLoaderWithContext = wrappedBatchLoader$iv;
                    if (mappedBatchLoaderWithContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                    }
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{name$iv, loader$iv, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            mappedBatchLoaderWithContext = loader$iv;
        }
        void extendedBatchLoader = mappedBatchLoaderWithContext;
        DataLoader dataLoader = DataLoaderFactory.newMappedDataLoader((String)dataLoaderName, (MappedBatchLoaderWithContext)extendedBatchLoader, (DataLoaderOptions)options.build());
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newMappedDataLoader(...)");
        return dataLoader;
    }

    private final void registerDataLoader(LoaderHolder<?> holder, ScheduledDataLoaderRegistry registry, Supplier<?> contextSupplier, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        DataLoader<?, ?> dataLoader;
        Object object = holder.getTheLoader();
        if (object instanceof BatchLoader) {
            dataLoader = this.createDataLoader((BatchLoader)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), (DataLoaderRegistry)registry, extensionProviders);
        } else if (object instanceof BatchLoaderWithContext) {
            dataLoader = this.createDataLoader((BatchLoaderWithContext)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), contextSupplier, (DataLoaderRegistry)registry, extensionProviders);
        } else if (object instanceof MappedBatchLoader) {
            dataLoader = this.createDataLoader((MappedBatchLoader)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), (DataLoaderRegistry)registry, extensionProviders);
        } else if (object instanceof MappedBatchLoaderWithContext) {
            dataLoader = this.createDataLoader((MappedBatchLoaderWithContext)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), contextSupplier, (DataLoaderRegistry)registry, extensionProviders);
        } else {
            throw new IllegalArgumentException("Data loader " + holder.getName() + " has unknown type");
        }
        DataLoader<?, ?> loader = dataLoader;
        if (registry.getKeys().contains(holder.getName())) {
            object = new Class[]{holder.getTheLoader().getClass()};
            throw new MultipleDataLoadersDefinedException((Class<?>)object);
        }
        ScheduledDataLoaderRegistry scheduledDataLoaderRegistry = holder.getDispatchPredicate() == null ? registry.register(holder.getName(), loader, DispatchPredicate.DISPATCH_ALWAYS) : registry.register(holder.getName(), loader, holder.getDispatchPredicate());
    }

    private final /* synthetic */ <T> T wrappedDataLoader(T loader, String name, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        boolean $i$f$wrappedDataLoader = false;
        try {
            T t = loader;
            if (t instanceof BatchLoader) {
                BatchLoader<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (BatchLoader<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((BatchLoader)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
            if (t instanceof BatchLoaderWithContext) {
                BatchLoaderWithContext<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (BatchLoaderWithContext<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((BatchLoaderWithContext)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
            if (t instanceof MappedBatchLoader) {
                MappedBatchLoader<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (MappedBatchLoader<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((MappedBatchLoader)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
            if (t instanceof MappedBatchLoaderWithContext) {
                MappedBatchLoaderWithContext<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (MappedBatchLoaderWithContext<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((MappedBatchLoaderWithContext)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            Object[] objectArray = new Object[]{name, loader, ex};
            logger.debug("Unable to wrap the [{} : {}]", objectArray);
        }
        return loader;
    }

    private static final boolean addDataLoaderFields$lambda$0$0(Field it) {
        return it.isAnnotationPresent(DgsDataLoader.class);
    }

    private static final <T> LoaderHolder<T> addDataLoader$createHolder(DgsDataLoader $annotation, String $dataLoaderName, DispatchPredicate $dispatchPredicate, T t) {
        return new LoaderHolder<T>(t, $annotation, $dataLoaderName, $dispatchPredicate);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDgsDataLoaderProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DefaultDgsDataLoaderProvider.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderProvider$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0015\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u00c6\u0003J>\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderProvider$LoaderHolder;", "T", "", "theLoader", "annotation", "Lcom/netflix/graphql/dgs/DgsDataLoader;", "name", "", "dispatchPredicate", "Lorg/dataloader/registries/DispatchPredicate;", "<init>", "(Ljava/lang/Object;Lcom/netflix/graphql/dgs/DgsDataLoader;Ljava/lang/String;Lorg/dataloader/registries/DispatchPredicate;)V", "getTheLoader", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getAnnotation", "()Lcom/netflix/graphql/dgs/DgsDataLoader;", "getName", "()Ljava/lang/String;", "getDispatchPredicate", "()Lorg/dataloader/registries/DispatchPredicate;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;Lcom/netflix/graphql/dgs/DgsDataLoader;Ljava/lang/String;Lorg/dataloader/registries/DispatchPredicate;)Lcom/netflix/graphql/dgs/internal/DefaultDgsDataLoaderProvider$LoaderHolder;", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs"})
    private static final class LoaderHolder<T> {
        private final T theLoader;
        @NotNull
        private final DgsDataLoader annotation;
        @NotNull
        private final String name;
        @Nullable
        private final DispatchPredicate dispatchPredicate;

        public LoaderHolder(T theLoader, @NotNull DgsDataLoader annotation, @NotNull String name, @Nullable DispatchPredicate dispatchPredicate) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.theLoader = theLoader;
            this.annotation = annotation;
            this.name = name;
            this.dispatchPredicate = dispatchPredicate;
        }

        public /* synthetic */ LoaderHolder(Object object, DgsDataLoader dgsDataLoader, String string, DispatchPredicate dispatchPredicate, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                dispatchPredicate = null;
            }
            this(object, dgsDataLoader, string, dispatchPredicate);
        }

        public final T getTheLoader() {
            return this.theLoader;
        }

        @NotNull
        public final DgsDataLoader getAnnotation() {
            return this.annotation;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final DispatchPredicate getDispatchPredicate() {
            return this.dispatchPredicate;
        }

        public final T component1() {
            return this.theLoader;
        }

        @NotNull
        public final DgsDataLoader component2() {
            return this.annotation;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @Nullable
        public final DispatchPredicate component4() {
            return this.dispatchPredicate;
        }

        @NotNull
        public final LoaderHolder<T> copy(T theLoader, @NotNull DgsDataLoader annotation, @NotNull String name, @Nullable DispatchPredicate dispatchPredicate) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new LoaderHolder<T>(theLoader, annotation, name, dispatchPredicate);
        }

        public static /* synthetic */ LoaderHolder copy$default(LoaderHolder loaderHolder, Object object, DgsDataLoader dgsDataLoader, String string, DispatchPredicate dispatchPredicate, int n, Object object2) {
            if ((n & 1) != 0) {
                object = loaderHolder.theLoader;
            }
            if ((n & 2) != 0) {
                dgsDataLoader = loaderHolder.annotation;
            }
            if ((n & 4) != 0) {
                string = loaderHolder.name;
            }
            if ((n & 8) != 0) {
                dispatchPredicate = loaderHolder.dispatchPredicate;
            }
            return loaderHolder.copy(object, dgsDataLoader, string, dispatchPredicate);
        }

        @NotNull
        public String toString() {
            return "LoaderHolder(theLoader=" + this.theLoader + ", annotation=" + this.annotation + ", name=" + this.name + ", dispatchPredicate=" + this.dispatchPredicate + ")";
        }

        public int hashCode() {
            int result = this.theLoader == null ? 0 : this.theLoader.hashCode();
            result = result * 31 + this.annotation.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + (this.dispatchPredicate == null ? 0 : this.dispatchPredicate.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoaderHolder)) {
                return false;
            }
            LoaderHolder loaderHolder = (LoaderHolder)other;
            if (!Intrinsics.areEqual(this.theLoader, loaderHolder.theLoader)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.annotation, (Object)loaderHolder.annotation)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)loaderHolder.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dispatchPredicate, (Object)loaderHolder.dispatchPredicate);
        }
    }
}

