/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DgsDataLoaderRegistryConsumer;
import java.util.List;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0005B\u001b\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/netflix/graphql/dgs/internal/BatchLoaderWithContextWrapper;", "K", "", "V", "Lorg/dataloader/BatchLoaderWithContext;", "Lcom/netflix/graphql/dgs/DgsDataLoaderRegistryConsumer;", "original", "Lorg/dataloader/BatchLoader;", "<init>", "(Lorg/dataloader/BatchLoader;)V", "load", "Ljava/util/concurrent/CompletionStage;", "", "keys", "environment", "Lorg/dataloader/BatchLoaderEnvironment;", "setDataLoaderRegistry", "", "dataLoaderRegistry", "Lorg/dataloader/DataLoaderRegistry;", "graphql-dgs"})
public final class BatchLoaderWithContextWrapper<K, V>
implements BatchLoaderWithContext<K, V>,
DgsDataLoaderRegistryConsumer {
    @NotNull
    private final BatchLoader<K, V> original;

    public BatchLoaderWithContextWrapper(@NotNull BatchLoader<K, V> original) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        this.original = original;
    }

    @NotNull
    public CompletionStage<List<V>> load(@NotNull List<? extends K> keys, @NotNull BatchLoaderEnvironment environment) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        CompletionStage completionStage = this.original.load(keys);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"load(...)");
        return completionStage;
    }

    @Override
    public void setDataLoaderRegistry(@Nullable DataLoaderRegistry dataLoaderRegistry) {
        if (this.original instanceof DgsDataLoaderRegistryConsumer) {
            BatchLoader<K, V> batchLoader = this.original;
            Intrinsics.checkNotNull(batchLoader, (String)"null cannot be cast to non-null type com.netflix.graphql.dgs.DgsDataLoaderRegistryConsumer");
            ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
        }
    }
}

