/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.webflux.handlers.WebsocketGraphQLTransportWSProtocolHandler;
import com.netflix.graphql.dgs.webflux.handlers.WebsocketReactiveProtocolHandler;
import com.netflix.graphql.types.subscription.websockets.CloseCode;
import com.netflix.graphql.types.subscription.websockets.Message;
import graphql.ExecutionResult;
import graphql.GraphqlErrorBuilder;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\u00130\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketGraphQLTransportWSProtocolHandler;", "Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketReactiveProtocolHandler;", "dgsReactiveQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "connectionInitTimeout", "Ljava/time/Duration;", "(Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;Ljava/time/Duration;)V", "connections", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "decoder", "Lorg/springframework/http/codec/json/Jackson2JsonDecoder;", "encoder", "Lorg/springframework/http/codec/json/Jackson2JsonEncoder;", "resolvableType", "Lorg/springframework/core/ResolvableType;", "kotlin.jvm.PlatformType", "sessions", "", "Lorg/reactivestreams/Subscription;", "handle", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "webSocketSession", "Lorg/springframework/web/reactive/socket/WebSocketSession;", "toWebsocketMessage", "Lorg/springframework/web/reactive/socket/WebSocketMessage;", "operationMessage", "Lcom/netflix/graphql/types/subscription/websockets/Message;", "session", "Companion", "graphql-dgs-spring-webflux-autoconfigure"})
public final class WebsocketGraphQLTransportWSProtocolHandler
implements WebsocketReactiveProtocolHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsReactiveQueryExecutor dgsReactiveQueryExecutor;
    @NotNull
    private final Duration connectionInitTimeout;
    private final ResolvableType resolvableType;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, Subscription>> sessions;
    @NotNull
    private final ConcurrentHashMap<String, Boolean> connections;
    @NotNull
    private final Jackson2JsonDecoder decoder;
    @NotNull
    private final Jackson2JsonEncoder encoder;
    @NotNull
    private static final Logger logger;

    public WebsocketGraphQLTransportWSProtocolHandler(@NotNull DgsReactiveQueryExecutor dgsReactiveQueryExecutor, @NotNull Duration connectionInitTimeout) {
        Intrinsics.checkNotNullParameter((Object)dgsReactiveQueryExecutor, (String)"dgsReactiveQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)connectionInitTimeout, (String)"connectionInitTimeout");
        this.dgsReactiveQueryExecutor = dgsReactiveQueryExecutor;
        this.connectionInitTimeout = connectionInitTimeout;
        this.resolvableType = ResolvableType.forType((Type)((Type)((Object)Message.class)));
        this.sessions = new ConcurrentHashMap();
        this.connections = new ConcurrentHashMap();
        this.decoder = new Jackson2JsonDecoder();
        this.encoder = new Jackson2JsonEncoder(this.decoder.getObjectMapper(), new MimeType[0]);
    }

    @Override
    @NotNull
    public Mono<Void> handle(@NotNull WebSocketSession webSocketSession) {
        Intrinsics.checkNotNullParameter((Object)webSocketSession, (String)"webSocketSession");
        Map map = this.connections;
        String string = webSocketSession.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"webSocketSession.id");
        String string2 = string;
        Boolean bl = false;
        map.put(string2, bl);
        Mono.delay((Duration)this.connectionInitTimeout).then(Mono.defer(() -> WebsocketGraphQLTransportWSProtocolHandler.handle$lambda$0(this, webSocketSession))).subscribe();
        map = webSocketSession.send((Publisher)webSocketSession.receive().flatMap(arg_0 -> WebsocketGraphQLTransportWSProtocolHandler.handle$lambda$1((Function1)new Function1<WebSocketMessage, Publisher<? extends WebSocketMessage>>(this, webSocketSession){
            final /* synthetic */ WebsocketGraphQLTransportWSProtocolHandler this$0;
            final /* synthetic */ WebSocketSession $webSocketSession;
            {
                this.this$0 = $receiver;
                this.$webSocketSession = $webSocketSession;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Publisher<? extends WebSocketMessage> invoke(WebSocketMessage message) {
                Flux flux;
                Message operationMessage;
                DataBuffer dataBuffer = DataBufferUtils.retain((DataBuffer)message.getPayload());
                Intrinsics.checkNotNullExpressionValue((Object)dataBuffer, (String)"retain(message.payload)");
                DataBuffer buffer = dataBuffer;
                Object object = WebsocketGraphQLTransportWSProtocolHandler.access$getDecoder$p(this.this$0).decode(buffer, WebsocketGraphQLTransportWSProtocolHandler.access$getResolvableType$p(this.this$0), MimeTypeUtils.APPLICATION_JSON, null);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.netflix.graphql.types.subscription.websockets.Message");
                Message message2 = operationMessage = (Message)object;
                if (message2 instanceof Message.ConnectionInitMessage) {
                    V v = WebsocketGraphQLTransportWSProtocolHandler.access$getConnections$p(this.this$0).get(this.$webSocketSession.getId());
                    Intrinsics.checkNotNull(v);
                    if (((Boolean)v).booleanValue()) {
                        return (Publisher)this.$webSocketSession.close(new CloseStatus(CloseCode.TooManyInitialisationRequests.getCode(), "Too many connection initialisation requests")).thenMany((Publisher)Mono.empty());
                    }
                    Map map = WebsocketGraphQLTransportWSProtocolHandler.access$getConnections$p(this.this$0);
                    String string = this.$webSocketSession.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"webSocketSession.id");
                    String string2 = string;
                    Boolean bl = true;
                    map.put(string2, bl);
                    flux = Flux.just((Object)WebsocketGraphQLTransportWSProtocolHandler.access$toWebsocketMessage(this.this$0, (Message)new Message.ConnectionAckMessage(null, 1, null), this.$webSocketSession));
                } else if (message2 instanceof Message.SubscribeMessage) {
                    void from$iv;
                    void $this$convertValue$iv;
                    ObjectMapper objectMapper = WebsocketGraphQLTransportWSProtocolHandler.access$getDecoder$p(this.this$0).getObjectMapper();
                    Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"decoder.objectMapper");
                    ObjectMapper objectMapper2 = objectMapper;
                    Message.SubscribeMessage.Payload payload = ((Message.SubscribeMessage)operationMessage).getPayload();
                    boolean $i$f$convertValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    Message.SubscribeMessage.Payload queryPayload = (Message.SubscribeMessage.Payload)$this$convertValue$iv.convertValue((Object)from$iv, (TypeReference)new TypeReference<Message.SubscribeMessage.Payload>(){});
                    if (WebsocketGraphQLTransportWSProtocolHandler.access$getSessions$p(this.this$0).containsKey(this.$webSocketSession.getId())) {
                        return (Publisher)this.$webSocketSession.close(new CloseStatus(CloseCode.SubscriberAlreadyExists.getCode(), "Subscriber for " + this.$webSocketSession.getId() + " already exists")).thenMany((Publisher)Mono.empty());
                    }
                    WebsocketGraphQLTransportWSProtocolHandler.access$getLogger$cp().debug("Starting subscription {} for session {}", (Object)queryPayload, (Object)this.$webSocketSession.getId());
                    flux = WebsocketGraphQLTransportWSProtocolHandler.access$getDgsReactiveQueryExecutor$p(this.this$0).execute(queryPayload.getQuery(), queryPayload.getVariables()).flatMapMany(arg_0 -> handle.2.invoke$lambda$0((Function1)new Function1<ExecutionResult, Publisher<? extends WebSocketMessage>>(this.this$0, operationMessage, this.$webSocketSession, queryPayload){
                        final /* synthetic */ WebsocketGraphQLTransportWSProtocolHandler this$0;
                        final /* synthetic */ Message $operationMessage;
                        final /* synthetic */ WebSocketSession $webSocketSession;
                        final /* synthetic */ Message.SubscribeMessage.Payload $queryPayload;
                        {
                            this.this$0 = $receiver;
                            this.$operationMessage = $operationMessage;
                            this.$webSocketSession = $webSocketSession;
                            this.$queryPayload = $queryPayload;
                            super(1);
                        }

                        public final Publisher<? extends WebSocketMessage> invoke(ExecutionResult executionResult2) {
                            Object object = executionResult2.getData();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executionResult.getData()");
                            Publisher publisher = (Publisher)object;
                            return (Publisher)Flux.from((Publisher)publisher).map(arg_0 -> handle.1.invoke$lambda$0((Function1)new Function1<ExecutionResult, WebSocketMessage>(this.this$0, this.$operationMessage, this.$webSocketSession){
                                final /* synthetic */ WebsocketGraphQLTransportWSProtocolHandler this$0;
                                final /* synthetic */ Message $operationMessage;
                                final /* synthetic */ WebSocketSession $webSocketSession;
                                {
                                    this.this$0 = $receiver;
                                    this.$operationMessage = $operationMessage;
                                    this.$webSocketSession = $webSocketSession;
                                    super(1);
                                }

                                public final WebSocketMessage invoke(ExecutionResult er) {
                                    Object object = er.getData();
                                    List list = er.getErrors();
                                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"er.errors");
                                    com.netflix.graphql.types.subscription.websockets.ExecutionResult executionResult2 = new com.netflix.graphql.types.subscription.websockets.ExecutionResult(object, list);
                                    String string = ((Message.SubscribeMessage)this.$operationMessage).getId();
                                    return WebsocketGraphQLTransportWSProtocolHandler.access$toWebsocketMessage(this.this$0, (Message)new Message.NextMessage(string, executionResult2), this.$webSocketSession);
                                }
                            }, arg_0)).doOnSubscribe(arg_0 -> handle.1.invoke$lambda$1((Function1)new Function1<Subscription, Unit>(this.$operationMessage, this.this$0, this.$webSocketSession){
                                final /* synthetic */ Message $operationMessage;
                                final /* synthetic */ WebsocketGraphQLTransportWSProtocolHandler this$0;
                                final /* synthetic */ WebSocketSession $webSocketSession;
                                {
                                    this.$operationMessage = $operationMessage;
                                    this.this$0 = $receiver;
                                    this.$webSocketSession = $webSocketSession;
                                    super(1);
                                }

                                public final void invoke(Subscription it) {
                                    if (((Message.SubscribeMessage)this.$operationMessage).getId() != null) {
                                        Map map = WebsocketGraphQLTransportWSProtocolHandler.access$getSessions$p(this.this$0);
                                        String string = this.$webSocketSession.getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"webSocketSession.id");
                                        String string2 = string;
                                        Object object = new Pair[]{TuplesKt.to((Object)((Message.SubscribeMessage)this.$operationMessage).getId(), (Object)it)};
                                        object = MapsKt.mutableMapOf((Pair[])object);
                                        map.put(string2, object);
                                    }
                                }
                            }, arg_0)).doOnComplete(() -> handle.1.invoke$lambda$2(this.$webSocketSession, this.this$0, this.$operationMessage)).doOnError(arg_0 -> handle.1.invoke$lambda$3((Function1)new Function1<Throwable, Unit>(this.$webSocketSession, this.this$0, this.$operationMessage, this.$queryPayload){
                                final /* synthetic */ WebSocketSession $webSocketSession;
                                final /* synthetic */ WebsocketGraphQLTransportWSProtocolHandler this$0;
                                final /* synthetic */ Message $operationMessage;
                                final /* synthetic */ Message.SubscribeMessage.Payload $queryPayload;
                                {
                                    this.$webSocketSession = $webSocketSession;
                                    this.this$0 = $receiver;
                                    this.$operationMessage = $operationMessage;
                                    this.$queryPayload = $queryPayload;
                                    super(1);
                                }

                                public final void invoke(Throwable it) {
                                    Object[] objectArray = CollectionsKt.listOf((Object)GraphqlErrorBuilder.newError().message(it.getMessage(), new Object[0]).build());
                                    String string = ((Message.SubscribeMessage)this.$operationMessage).getId();
                                    this.$webSocketSession.send((Publisher)Flux.just((Object)WebsocketGraphQLTransportWSProtocolHandler.access$toWebsocketMessage(this.this$0, (Message)new Message.ErrorMessage(string, (List)objectArray), this.$webSocketSession))).subscribe();
                                    Map map = (Map)WebsocketGraphQLTransportWSProtocolHandler.access$getSessions$p(this.this$0).get(this.$webSocketSession.getId());
                                    if (map != null) {
                                        Subscription cfr_ignored_0 = (Subscription)map.remove(((Message.SubscribeMessage)this.$operationMessage).getId());
                                    }
                                    objectArray = new Object[]{this.$queryPayload, ((Message.SubscribeMessage)this.$operationMessage).getId(), this.$webSocketSession.getId(), it};
                                    WebsocketGraphQLTransportWSProtocolHandler.access$getLogger$cp().debug("Subscription publisher error for input {} for subscription {} for connection {}", objectArray);
                                }
                            }, arg_0));
                        }

                        private static final WebSocketMessage invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            return (WebSocketMessage)$tmp0.invoke(p0);
                        }

                        private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            $tmp0.invoke(p0);
                        }

                        private static final void invoke$lambda$2(WebSocketSession $webSocketSession, WebsocketGraphQLTransportWSProtocolHandler this$0, Message $operationMessage) {
                            Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Intrinsics.checkNotNullParameter((Object)$operationMessage, (String)"$operationMessage");
                            $webSocketSession.send((Publisher)Flux.just((Object)WebsocketGraphQLTransportWSProtocolHandler.access$toWebsocketMessage(this$0, (Message)new Message.CompleteMessage(((Message.SubscribeMessage)$operationMessage).getId()), $webSocketSession))).subscribe();
                            Map map = (Map)WebsocketGraphQLTransportWSProtocolHandler.access$getSessions$p(this$0).get($webSocketSession.getId());
                            if (map != null) {
                                Subscription cfr_ignored_0 = (Subscription)map.remove(((Message.SubscribeMessage)$operationMessage).getId());
                            }
                            WebsocketGraphQLTransportWSProtocolHandler.access$getLogger$cp().debug("Completing subscription {} for connection {}", (Object)((Message.SubscribeMessage)$operationMessage).getId(), (Object)$webSocketSession.getId());
                        }

                        private static final void invoke$lambda$3(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            $tmp0.invoke(p0);
                        }
                    }, arg_0));
                } else if (message2 instanceof Message.PingMessage) {
                    flux = Flux.just((Object)WebsocketGraphQLTransportWSProtocolHandler.access$toWebsocketMessage(this.this$0, (Message)new Message.PongMessage(null, 1, null), this.$webSocketSession));
                } else if (message2 instanceof Message.PongMessage) {
                    flux = Flux.empty();
                } else if (message2 instanceof Message.CompleteMessage) {
                    Map map = (Map)WebsocketGraphQLTransportWSProtocolHandler.access$getSessions$p(this.this$0).get(this.$webSocketSession.getId());
                    if (map != null && (map = (Subscription)map.remove(((Message.CompleteMessage)operationMessage).getId())) != null) {
                        map.cancel();
                    }
                    WebsocketGraphQLTransportWSProtocolHandler.access$getLogger$cp().debug("Client stopped subscription {} for connection {}", (Object)((Message.CompleteMessage)operationMessage).getId(), (Object)this.$webSocketSession.getId());
                    flux = Flux.empty();
                } else {
                    return (Publisher)this.$webSocketSession.close(new CloseStatus(CloseCode.BadRequest.getCode(), "Unrecognized message")).thenMany((Publisher)Mono.empty());
                }
                return (Publisher)flux;
            }

            private static final Publisher invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Publisher)$tmp0.invoke(p0);
            }
        }, arg_0)).log().doFinally(arg_0 -> WebsocketGraphQLTransportWSProtocolHandler.handle$lambda$3(webSocketSession, this, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"override fun handle(webS\u2026        }\n        )\n    }");
        return map;
    }

    private final WebSocketMessage toWebsocketMessage(Message operationMessage, WebSocketSession session) {
        return new WebSocketMessage(WebSocketMessage.Type.TEXT, this.encoder.encodeValue((Object)operationMessage, session.bufferFactory(), this.resolvableType, MimeTypeUtils.APPLICATION_JSON, null));
    }

    private static final Mono handle$lambda$0(WebsocketGraphQLTransportWSProtocolHandler this$0, WebSocketSession $webSocketSession) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        return Intrinsics.areEqual((Object)this$0.connections.get($webSocketSession.getId()), (Object)false) ? $webSocketSession.close(new CloseStatus(CloseCode.ConnectionInitialisationTimeout.getCode(), "Did not receive a ConnectionInitMessage")) : Mono.empty();
    }

    private static final Publisher handle$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final void handle$lambda$3(WebSocketSession $webSocketSession, WebsocketGraphQLTransportWSProtocolHandler this$0, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)$webSocketSession, (String)"$webSocketSession");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        logger.debug("Cleaning up subscriptions for session " + $webSocketSession.getId());
        Map<String, Subscription> map = this$0.sessions.get($webSocketSession.getId());
        if (map != null) {
            Map<String, Subscription> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Subscription>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Subscription> element$iv;
                Map.Entry<String, Subscription> it2 = element$iv = iterator.next();
                boolean bl = false;
                it2.getValue().cancel();
            }
        }
        this$0.sessions.remove($webSocketSession.getId());
        this$0.connections.remove($webSocketSession.getId());
    }

    public static final /* synthetic */ Jackson2JsonDecoder access$getDecoder$p(WebsocketGraphQLTransportWSProtocolHandler $this) {
        return $this.decoder;
    }

    public static final /* synthetic */ ResolvableType access$getResolvableType$p(WebsocketGraphQLTransportWSProtocolHandler $this) {
        return $this.resolvableType;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getConnections$p(WebsocketGraphQLTransportWSProtocolHandler $this) {
        return $this.connections;
    }

    public static final /* synthetic */ WebSocketMessage access$toWebsocketMessage(WebsocketGraphQLTransportWSProtocolHandler $this, Message operationMessage, WebSocketSession session) {
        return $this.toWebsocketMessage(operationMessage, session);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSessions$p(WebsocketGraphQLTransportWSProtocolHandler $this) {
        return $this.sessions;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ DgsReactiveQueryExecutor access$getDgsReactiveQueryExecutor$p(WebsocketGraphQLTransportWSProtocolHandler $this) {
        return $this.dgsReactiveQueryExecutor;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsReactiveQueryExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DgsReactiveQueryExecutor::class.java)");
        WebsocketGraphQLTransportWSProtocolHandler.logger = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/webflux/handlers/WebsocketGraphQLTransportWSProtocolHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

