/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.webmvc;

import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.context.GraphQLContextContributor;
import com.netflix.graphql.dgs.internal.DefaultDgsGraphQLContextBuilder;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsWebMvcRequestData;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsSpringGraphQLConfigurationProperties;
import graphql.ExecutionInput;
import graphql.GraphQLContext;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/webmvc/DgsWebMvcGraphQLInterceptor;", "Lorg/springframework/graphql/server/WebGraphQlInterceptor;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "dgsContextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "dgsSpringConfigurationProperties", "Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLConfigurationProperties;", "graphQLContextContributors", "", "Lcom/netflix/graphql/dgs/context/GraphQLContextContributor;", "<init>", "(Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLConfigurationProperties;Ljava/util/List;)V", "intercept", "Lreactor/core/publisher/Mono;", "Lorg/springframework/graphql/server/WebGraphQlResponse;", "request", "Lorg/springframework/graphql/server/WebGraphQlRequest;", "chain", "Lorg/springframework/graphql/server/WebGraphQlInterceptor$Chain;", "graphql-dgs-spring-graphql"})
public final class DgsWebMvcGraphQLInterceptor
implements WebGraphQlInterceptor {
    @NotNull
    private final DgsDataLoaderProvider dgsDataLoaderProvider;
    @NotNull
    private final DefaultDgsGraphQLContextBuilder dgsContextBuilder;
    @NotNull
    private final DgsSpringGraphQLConfigurationProperties dgsSpringConfigurationProperties;
    @NotNull
    private final List<GraphQLContextContributor> graphQLContextContributors;

    public DgsWebMvcGraphQLInterceptor(@NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsGraphQLContextBuilder dgsContextBuilder, @NotNull DgsSpringGraphQLConfigurationProperties dgsSpringConfigurationProperties, @NotNull List<? extends GraphQLContextContributor> graphQLContextContributors) {
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
        Intrinsics.checkNotNullParameter((Object)dgsSpringConfigurationProperties, (String)"dgsSpringConfigurationProperties");
        Intrinsics.checkNotNullParameter(graphQLContextContributors, (String)"graphQLContextContributors");
        this.dgsDataLoaderProvider = dgsDataLoaderProvider;
        this.dgsContextBuilder = dgsContextBuilder;
        this.dgsSpringConfigurationProperties = dgsSpringConfigurationProperties;
        this.graphQLContextContributors = graphQLContextContributors;
    }

    @NotNull
    public Mono<WebGraphQlResponse> intercept(@NotNull WebGraphQlRequest request, @NotNull WebGraphQlInterceptor.Chain chain) {
        DgsContext dgsContext;
        ServletRequestAttributes servletRequestAttributes;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        if (RequestContextHolder.getRequestAttributes() instanceof ServletRequestAttributes) {
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            Intrinsics.checkNotNull((Object)requestAttributes, (String)"null cannot be cast to non-null type org.springframework.web.context.request.ServletRequestAttributes");
            v1 = (ServletRequestAttributes)requestAttributes;
        } else {
            v1 = servletRequestAttributes = null;
        }
        if (servletRequestAttributes != null) {
            WebRequest webRequest = (WebRequest)new ServletWebRequest(servletRequestAttributes.getRequest(), servletRequestAttributes.getResponse());
            dgsContext = this.dgsContextBuilder.build(new DgsWebMvcRequestData(request.getExtensions(), request.getHeaders(), webRequest));
        } else {
            dgsContext = this.dgsContextBuilder.build(new DgsWebMvcRequestData(request.getExtensions(), request.getHeaders(), null, 4, null));
        }
        DgsContext dgsContext2 = dgsContext;
        Ref.ObjectRef dataLoaderRegistry = new Ref.ObjectRef();
        request.configureExecutionInput((arg_0, arg_1) -> DgsWebMvcGraphQLInterceptor.intercept$lambda$0(dataLoaderRegistry, this, dgsContext2, arg_0, arg_1));
        if (!this.dgsSpringConfigurationProperties.getWebmvc().getAsyncdispatch().getEnabled()) {
            Object object = chain.next(request).block();
            Intrinsics.checkNotNull((Object)object);
            WebGraphQlResponse response = (WebGraphQlResponse)object;
            if (dataLoaderRegistry.element instanceof AutoCloseable) {
                Object object2 = dataLoaderRegistry.element;
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.lang.AutoCloseable");
                ((AutoCloseable)object2).close();
            }
            Mono mono = Mono.just((Object)response);
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
            return mono;
        }
        Mono mono = chain.next(request).doFinally(arg_0 -> DgsWebMvcGraphQLInterceptor.intercept$lambda$1(dataLoaderRegistry, arg_0));
        Intrinsics.checkNotNull((Object)mono);
        return mono;
    }

    private static final ExecutionInput intercept$lambda$0(Ref.ObjectRef $dataLoaderRegistry, DgsWebMvcGraphQLInterceptor this$0, DgsContext $dgsContext, ExecutionInput e, ExecutionInput.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        $dataLoaderRegistry.element = this$0.dgsDataLoaderProvider.buildRegistryWithContextSupplier(() -> DgsWebMvcGraphQLInterceptor.intercept$lambda$0$0(e));
        return builder.graphQLContext((Consumer)$dgsContext).dataLoaderRegistry((DataLoaderRegistry)$dataLoaderRegistry.element).build();
    }

    private static final GraphQLContext intercept$lambda$0$0(ExecutionInput $e) {
        return $e.getGraphQLContext();
    }

    private static final void intercept$lambda$1(Ref.ObjectRef $dataLoaderRegistry, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($dataLoaderRegistry.element instanceof AutoCloseable) {
            Object object = $dataLoaderRegistry.element;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.AutoCloseable");
            ((AutoCloseable)object).close();
        }
    }
}

