/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.mocking;

import com.netflix.graphql.mocking.MockGraphQLVisitor;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import net.datafaker.Faker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0016\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001eH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\r\u001a \u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/netflix/graphql/mocking/MockGraphQLVisitor;", "Lgraphql/schema/GraphQLTypeVisitorStub;", "mockConfig", "", "", "", "mockFetchers", "", "Lgraphql/schema/FieldCoordinates;", "Lgraphql/schema/DataFetcher;", "(Ljava/util/Map;Ljava/util/Map;)V", "faker", "Lnet/datafaker/Faker;", "getPathForNode", "Lkotlin/Function2;", "", "Lgraphql/schema/GraphQLSchemaElement;", "Lgraphql/schema/GraphQLFieldDefinition;", "logger", "Lorg/slf4j/Logger;", "providedRoots", "", "generateDataForScalar", "type", "getProvidedMockData", "pathForNode", "visitGraphQLFieldDefinition", "Lgraphql/util/TraversalControl;", "node", "context", "Lgraphql/util/TraverserContext;", "graphql-dgs-mocking"})
public final class MockGraphQLVisitor
extends GraphQLTypeVisitorStub {
    @NotNull
    private final Map<String, Object> mockConfig;
    @NotNull
    private final Map<FieldCoordinates, DataFetcher<?>> mockFetchers;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<String> providedRoots;
    @NotNull
    private final Faker faker;
    @NotNull
    private final Function2<List<? extends GraphQLSchemaElement>, GraphQLFieldDefinition, String> getPathForNode;

    public MockGraphQLVisitor(@NotNull Map<String, ? extends Object> mockConfig, @NotNull Map<FieldCoordinates, DataFetcher<?>> mockFetchers) {
        Intrinsics.checkNotNullParameter(mockConfig, (String)"mockConfig");
        Intrinsics.checkNotNullParameter(mockFetchers, (String)"mockFetchers");
        this.mockConfig = mockConfig;
        this.mockFetchers = mockFetchers;
        Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this.javaClass)");
        this.logger = logger;
        this.providedRoots = new ArrayList();
        this.faker = new Faker();
        this.getPathForNode = getPathForNode.1.INSTANCE;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public TraversalControl visitGraphQLFieldDefinition(@Nullable GraphQLFieldDefinition node, @Nullable TraverserContext<GraphQLSchemaElement> context) {
        block22: {
            int n;
            Object object;
            boolean bl;
            String it;
            String pathForNode;
            block21: {
                boolean bl2;
                Iterable $this$any$iv;
                block23: {
                    boolean bl3;
                    boolean $i$f$any;
                    block20: {
                        TraverserContext<GraphQLSchemaElement> traverserContext = context;
                        pathForNode = (String)this.getPathForNode.invoke((Object)(traverserContext != null ? traverserContext.getParentNodes() : null), (Object)node);
                        $this$any$iv = this.mockConfig.keySet();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it = (String)element$iv2;
                                boolean bl4 = false;
                                String string = pathForNode;
                                boolean bl5 = string != null ? StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null) : false;
                                if (!bl5) continue;
                                bl3 = true;
                                break block20;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) break block22;
                    $this$any$iv = this.providedRoots;
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block23;
                    bl = false;
                    break block21;
                }
                object = $this$any$iv.iterator();
                do {
                    block25: {
                        boolean bl6;
                        block28: {
                            char c;
                            char element$iv;
                            int n2;
                            int count$iv;
                            boolean $i$f$count;
                            CharSequence $this$count$iv;
                            block27: {
                                block24: {
                                    block26: {
                                        boolean bl7;
                                        Object element$iv2;
                                        if (!object.hasNext()) break block24;
                                        element$iv2 = object.next();
                                        it = (String)element$iv2;
                                        boolean bl8 = false;
                                        String string = pathForNode;
                                        if (string != null) {
                                            String string2 = it;
                                            Intrinsics.checkNotNull((Object)string2);
                                            bl7 = StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null);
                                        } else {
                                            bl7 = false;
                                        }
                                        if (!bl7) break block25;
                                        if (it == null) break block26;
                                        $this$count$iv = pathForNode;
                                        $i$f$count = false;
                                        count$iv = 0;
                                        break block27;
                                    }
                                    bl6 = false;
                                    break block28;
                                }
                                bl = false;
                                break block21;
                            }
                            for (n2 = 0; n2 < $this$count$iv.length(); ++n2) {
                                c = element$iv = $this$count$iv.charAt(n2);
                                boolean bl9 = false;
                                if (!(c == '.')) continue;
                                ++count$iv;
                            }
                            $this$count$iv = it;
                            int n3 = count$iv;
                            $i$f$count = false;
                            count$iv = 0;
                            for (n2 = 0; n2 < $this$count$iv.length(); ++n2) {
                                c = element$iv = $this$count$iv.charAt(n2);
                                n = 0;
                                if (!(c == '.')) continue;
                                ++count$iv;
                            }
                            int n4 = count$iv;
                            bl6 = n3 == n4;
                        }
                        if (!bl6) {
                            bl2 = true;
                            continue;
                        }
                    }
                    bl2 = false;
                } while (!bl2);
                bl = true;
            }
            if (!bl) {
                DataFetcher dataFetcher;
                GraphQLType type;
                GraphQLFieldDefinition graphQLFieldDefinition = node;
                if ((graphQLFieldDefinition != null ? graphQLFieldDefinition.getType() : null) instanceof GraphQLNonNull) {
                    GraphQLOutputType graphQLOutputType = node.getType();
                    Intrinsics.checkNotNull((Object)graphQLOutputType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLNonNull");
                    v12 = ((GraphQLNonNull)graphQLOutputType).getWrappedType();
                } else {
                    GraphQLFieldDefinition graphQLFieldDefinition2 = node;
                    v12 = type = (GraphQLType)(graphQLFieldDefinition2 != null ? graphQLFieldDefinition2.getType() : null);
                }
                if (this.mockConfig.get(pathForNode) != null) {
                    this.logger.info("Returning provided mock data for {}", (Object)pathForNode);
                    this.providedRoots.add(pathForNode);
                    dataFetcher = this.getProvidedMockData(pathForNode);
                } else {
                    this.logger.info("Generating mock data for {}", (Object)pathForNode);
                    object = type;
                    if (object instanceof GraphQLScalarType) {
                        dataFetcher = arg_0 -> MockGraphQLVisitor.visitGraphQLFieldDefinition$lambda$4(this, type, arg_0);
                    } else if (object instanceof GraphQLList) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        if (!(((GraphQLList)type).getWrappedType() instanceof GraphQLNamedType)) {
                            TraversalControl traversalControl = super.visitGraphQLFieldDefinition(node, context);
                            Intrinsics.checkNotNullExpressionValue((Object)traversalControl, (String)"super.visitGraphQLFieldDefinition(node, context)");
                            return traversalControl;
                        }
                        GraphQLType graphQLType = ((GraphQLList)type).getWrappedType();
                        Intrinsics.checkNotNull((Object)graphQLType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLNamedType");
                        it = ((GraphQLNamedType)graphQLType).getName();
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"when (type.wrappedType) \u2026                        }");
                        String wrappedType = it;
                        Iterable bl8 = (Iterable)new IntRange(0, this.faker.number().numberBetween(0, 10));
                        boolean $i$f$map = false;
                        void $i$f$count = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            int item$iv$iv;
                            n = item$iv$iv = ((IntIterator)iterator).nextInt();
                            Collection collection = destination$iv$iv;
                            boolean bl10 = false;
                            collection.add(this.generateDataForScalar(wrappedType));
                        }
                        List mockedValues = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                        dataFetcher = arg_0 -> MockGraphQLVisitor.visitGraphQLFieldDefinition$lambda$6(mockedValues, arg_0);
                    } else {
                        dataFetcher = MockGraphQLVisitor::visitGraphQLFieldDefinition$lambda$7;
                    }
                }
                DataFetcher dataFetcher2 = dataFetcher;
                object = this.mockFetchers;
                TraverserContext<GraphQLSchemaElement> traverserContext = context;
                Object object2 = traverserContext != null ? (GraphQLSchemaElement)traverserContext.getParentNode() : null;
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type graphql.schema.GraphQLObjectType");
                GraphQLFieldDefinition graphQLFieldDefinition3 = node;
                FieldCoordinates fieldCoordinates = FieldCoordinates.coordinates((String)((GraphQLObjectType)object2).getName(), (String)(graphQLFieldDefinition3 != null ? graphQLFieldDefinition3.getName() : null));
                Intrinsics.checkNotNullExpressionValue((Object)fieldCoordinates, (String)"coordinates((context?.pa\u2026ctType).name, node?.name)");
                object.put(fieldCoordinates, dataFetcher2);
            }
        }
        TraversalControl traversalControl = super.visitGraphQLFieldDefinition(node, context);
        Intrinsics.checkNotNullExpressionValue((Object)traversalControl, (String)"super.visitGraphQLFieldDefinition(node, context)");
        return traversalControl;
    }

    private final Object generateDataForScalar(String type) {
        Object object = switch (type) {
            case "String" -> this.faker.book().title();
            case "Boolean" -> this.faker.bool().bool();
            case "Int" -> this.faker.number().randomDigit();
            case "Float" -> this.faker.number().randomDouble(2, 0, 100000);
            case "ID" -> this.faker.number().digit();
            default -> new Object();
        };
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when (type) {\n          \u2026lse -> Object()\n        }");
        return object;
    }

    private final DataFetcher<?> getProvidedMockData(String pathForNode) {
        Object provided = this.mockConfig.get(pathForNode);
        return provided instanceof DataFetcher ? (DataFetcher)provided : arg_0 -> MockGraphQLVisitor.getProvidedMockData$lambda$8(provided, arg_0);
    }

    private static final Object visitGraphQLFieldDefinition$lambda$4(MockGraphQLVisitor this$0, GraphQLType $type, DataFetchingEnvironment it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        String string = ((GraphQLScalarType)$type).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.name");
        return this$0.generateDataForScalar(string);
    }

    private static final List visitGraphQLFieldDefinition$lambda$6(List $mockedValues, DataFetchingEnvironment it) {
        Intrinsics.checkNotNullParameter((Object)$mockedValues, (String)"$mockedValues");
        return $mockedValues;
    }

    private static final Object visitGraphQLFieldDefinition$lambda$7(DataFetchingEnvironment it) {
        return new Object();
    }

    private static final Object getProvidedMockData$lambda$8(Object $provided, DataFetchingEnvironment it) {
        return $provided;
    }
}

