/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.exception.ConductorClientException;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.client.http.ClientRequestHandler;
import com.netflix.conductor.client.telemetry.MetricsContainer;
import com.netflix.conductor.common.metadata.workflow.RerunWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.StartWorkflowRequest;
import com.netflix.conductor.common.model.BulkResponse;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.common.run.WorkflowSummary;
import com.netflix.conductor.common.run.WorkflowTestRequest;
import com.netflix.conductor.common.utils.ExternalPayloadStorage;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowClient
extends ClientBase {
    private static final GenericType<SearchResult<WorkflowSummary>> searchResultWorkflowSummary = new GenericType<SearchResult<WorkflowSummary>>(){};
    private static final GenericType<SearchResult<Workflow>> searchResultWorkflow = new GenericType<SearchResult<Workflow>>(){};
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowClient.class);

    public WorkflowClient() {
        this((ClientConfig)new DefaultClientConfig(), new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public WorkflowClient(ClientConfig config) {
        this(config, new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public WorkflowClient(ClientConfig config, ClientHandler handler) {
        this(config, new DefaultConductorClientConfiguration(), handler, new ClientFilter[0]);
    }

    public WorkflowClient(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        this(config, new DefaultConductorClientConfiguration(), handler, filters);
    }

    public WorkflowClient(ClientConfig config, ConductorClientConfiguration clientConfiguration, ClientHandler handler, ClientFilter ... filters) {
        super(new ClientRequestHandler(config, handler, filters), clientConfiguration);
    }

    WorkflowClient(ClientRequestHandler requestHandler) {
        super(requestHandler, null);
    }

    public String startWorkflow(StartWorkflowRequest startWorkflowRequest) {
        Validate.notNull((Object)startWorkflowRequest, (String)"StartWorkflowRequest cannot be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)startWorkflowRequest.getName(), (String)"Workflow name cannot be null or empty", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)startWorkflowRequest.getExternalInputPayloadStoragePath()), (String)"External Storage Path must not be set", (Object[])new Object[0]);
        String version = startWorkflowRequest.getVersion() != null ? startWorkflowRequest.getVersion().toString() : "latest";
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.objectMapper.writeValue((OutputStream)byteArrayOutputStream, (Object)startWorkflowRequest.getInput());
            byte[] workflowInputBytes = byteArrayOutputStream.toByteArray();
            long workflowInputSize = workflowInputBytes.length;
            MetricsContainer.recordWorkflowInputPayloadSize(startWorkflowRequest.getName(), version, workflowInputSize);
            if (workflowInputSize > (long)this.conductorClientConfiguration.getWorkflowInputPayloadThresholdKB() * 1024L) {
                if (!this.conductorClientConfiguration.isExternalPayloadStorageEnabled() || workflowInputSize > (long)this.conductorClientConfiguration.getWorkflowInputMaxPayloadThresholdKB() * 1024L) {
                    String errorMsg = String.format("Input payload larger than the allowed threshold of: %d KB", this.conductorClientConfiguration.getWorkflowInputPayloadThresholdKB());
                    throw new ConductorClientException(errorMsg);
                }
                MetricsContainer.incrementExternalPayloadUsedCount(startWorkflowRequest.getName(), ExternalPayloadStorage.Operation.WRITE.name(), ExternalPayloadStorage.PayloadType.WORKFLOW_INPUT.name());
                String externalStoragePath = this.uploadToExternalPayloadStorage(ExternalPayloadStorage.PayloadType.WORKFLOW_INPUT, workflowInputBytes, workflowInputSize);
                startWorkflowRequest.setExternalInputPayloadStoragePath(externalStoragePath);
                startWorkflowRequest.setInput(null);
            }
        }
        catch (IOException e) {
            String errorMsg = String.format("Unable to start workflow:%s, version:%s", startWorkflowRequest.getName(), version);
            LOGGER.error(errorMsg, (Throwable)e);
            MetricsContainer.incrementWorkflowStartErrorCount(startWorkflowRequest.getName(), e);
            throw new ConductorClientException(errorMsg, e);
        }
        try {
            return this.postForEntity("workflow", (Object)startWorkflowRequest, null, String.class, startWorkflowRequest.getName());
        }
        catch (ConductorClientException e) {
            String errorMsg = String.format("Unable to send start workflow request:%s, version:%s", startWorkflowRequest.getName(), version);
            LOGGER.error(errorMsg, (Throwable)e);
            MetricsContainer.incrementWorkflowStartErrorCount(startWorkflowRequest.getName(), e);
            throw e;
        }
    }

    public Workflow getWorkflow(String workflowId, boolean includeTasks) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        Workflow workflow = this.getForEntity("workflow/{workflowId}", new Object[]{"includeTasks", includeTasks}, Workflow.class, workflowId);
        this.populateWorkflowOutput(workflow);
        return workflow;
    }

    public List<Workflow> getWorkflows(String name, String correlationId, boolean includeClosed, boolean includeTasks) {
        Validate.notBlank((CharSequence)name, (String)"name cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)correlationId, (String)"correlationId cannot be blank", (Object[])new Object[0]);
        Object[] params = new Object[]{"includeClosed", includeClosed, "includeTasks", includeTasks};
        List<Workflow> workflows = this.getForEntity("workflow/{name}/correlated/{correlationId}", params, new GenericType<List<Workflow>>(){}, name, correlationId);
        workflows.forEach(this::populateWorkflowOutput);
        return workflows;
    }

    private void populateWorkflowOutput(Workflow workflow) {
        if (StringUtils.isNotBlank((CharSequence)workflow.getExternalOutputPayloadStoragePath())) {
            MetricsContainer.incrementExternalPayloadUsedCount(workflow.getWorkflowName(), ExternalPayloadStorage.Operation.READ.name(), ExternalPayloadStorage.PayloadType.WORKFLOW_OUTPUT.name());
            workflow.setOutput(this.downloadFromExternalStorage(ExternalPayloadStorage.PayloadType.WORKFLOW_OUTPUT, workflow.getExternalOutputPayloadStoragePath()));
        }
    }

    public void deleteWorkflow(String workflowId, boolean archiveWorkflow) {
        Validate.notBlank((CharSequence)workflowId, (String)"Workflow id cannot be blank", (Object[])new Object[0]);
        Object[] params = new Object[]{"archiveWorkflow", archiveWorkflow};
        this.deleteWithUriVariables(params, "workflow/{workflowId}/remove", workflowId);
    }

    public BulkResponse terminateWorkflows(List<String> workflowIds, String reason) {
        Validate.isTrue((!workflowIds.isEmpty() ? 1 : 0) != 0, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        return this.postForEntity("workflow/bulk/terminate", workflowIds, new Object[]{"reason", reason}, BulkResponse.class, new Object[0]);
    }

    public List<String> getRunningWorkflow(String workflowName, Integer version) {
        Validate.notBlank((CharSequence)workflowName, (String)"Workflow name cannot be blank", (Object[])new Object[0]);
        return this.getForEntity("workflow/running/{name}", new Object[]{"version", version}, new GenericType<List<String>>(){}, workflowName);
    }

    public List<String> getWorkflowsByTimePeriod(String workflowName, int version, Long startTime, Long endTime) {
        Validate.notBlank((CharSequence)workflowName, (String)"Workflow name cannot be blank", (Object[])new Object[0]);
        Validate.notNull((Object)startTime, (String)"Start time cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)endTime, (String)"End time cannot be null", (Object[])new Object[0]);
        Object[] params = new Object[]{"version", version, "startTime", startTime, "endTime", endTime};
        return this.getForEntity("workflow/running/{name}", params, new GenericType<List<String>>(){}, workflowName);
    }

    public void runDecider(String workflowId) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        this.put("workflow/decide/{workflowId}", null, null, workflowId);
    }

    public void pauseWorkflow(String workflowId) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        this.put("workflow/{workflowId}/pause", null, null, workflowId);
    }

    public void resumeWorkflow(String workflowId) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        this.put("workflow/{workflowId}/resume", null, null, workflowId);
    }

    public void skipTaskFromWorkflow(String workflowId, String taskReferenceName) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)taskReferenceName, (String)"Task reference name cannot be blank", (Object[])new Object[0]);
        this.put("workflow/{workflowId}/skiptask/{taskReferenceName}", null, null, workflowId, taskReferenceName);
    }

    public String rerunWorkflow(String workflowId, RerunWorkflowRequest rerunWorkflowRequest) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        Validate.notNull((Object)rerunWorkflowRequest, (String)"RerunWorkflowRequest cannot be null", (Object[])new Object[0]);
        return this.postForEntity("workflow/{workflowId}/rerun", (Object)rerunWorkflowRequest, null, String.class, workflowId);
    }

    public void restart(String workflowId, boolean useLatestDefinitions) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        Object[] params = new Object[]{"useLatestDefinitions", useLatestDefinitions};
        this.postForEntity("workflow/{workflowId}/restart", null, params, Void.TYPE, workflowId);
    }

    public void retryLastFailedTask(String workflowId) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        this.postForEntityWithUriVariablesOnly("workflow/{workflowId}/retry", workflowId);
    }

    public void resetCallbacksForInProgressTasks(String workflowId) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        this.postForEntityWithUriVariablesOnly("workflow/{workflowId}/resetcallbacks", workflowId);
    }

    public void terminateWorkflow(String workflowId, String reason) {
        Validate.notBlank((CharSequence)workflowId, (String)"workflow id cannot be blank", (Object[])new Object[0]);
        this.deleteWithUriVariables(new Object[]{"reason", reason}, "workflow/{workflowId}", workflowId);
    }

    public SearchResult<WorkflowSummary> search(String query) {
        return this.getForEntity("workflow/search", new Object[]{"query", query}, searchResultWorkflowSummary, new Object[0]);
    }

    public SearchResult<Workflow> searchV2(String query) {
        return this.getForEntity("workflow/search-v2", new Object[]{"query", query}, searchResultWorkflow, new Object[0]);
    }

    public SearchResult<WorkflowSummary> search(Integer start, Integer size, String sort, String freeText, String query) {
        Object[] params = new Object[]{"start", start, "size", size, "sort", sort, "freeText", freeText, "query", query};
        return this.getForEntity("workflow/search", params, searchResultWorkflowSummary, new Object[0]);
    }

    public SearchResult<Workflow> searchV2(Integer start, Integer size, String sort, String freeText, String query) {
        Object[] params = new Object[]{"start", start, "size", size, "sort", sort, "freeText", freeText, "query", query};
        return this.getForEntity("workflow/search-v2", params, searchResultWorkflow, new Object[0]);
    }

    public Workflow testWorkflow(WorkflowTestRequest testRequest) {
        Validate.notNull((Object)testRequest, (String)"testRequest cannot be null", (Object[])new Object[0]);
        if (testRequest.getWorkflowDef() != null) {
            testRequest.setName(testRequest.getWorkflowDef().getName());
            testRequest.setVersion(Integer.valueOf(testRequest.getWorkflowDef().getVersion()));
        }
        return this.postForEntity("workflow/test", (Object)testRequest, null, Workflow.class, new Object[0]);
    }
}

