/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.netflix.conductor.client.config.ConductorClientConfiguration;
import com.netflix.conductor.client.config.DefaultConductorClientConfiguration;
import com.netflix.conductor.client.http.ClientBase;
import com.netflix.conductor.client.http.ClientRequestHandler;
import com.netflix.conductor.common.metadata.events.EventHandler;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class EventClient
extends ClientBase {
    private static final GenericType<List<EventHandler>> eventHandlerList = new GenericType<List<EventHandler>>(){};

    public EventClient() {
        this((ClientConfig)new DefaultClientConfig(), new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public EventClient(ClientConfig clientConfig) {
        this(clientConfig, new DefaultConductorClientConfiguration(), null, new ClientFilter[0]);
    }

    public EventClient(ClientConfig clientConfig, ClientHandler clientHandler) {
        this(clientConfig, new DefaultConductorClientConfiguration(), clientHandler, new ClientFilter[0]);
    }

    public EventClient(ClientConfig config, ClientHandler handler, ClientFilter ... filters) {
        this(config, new DefaultConductorClientConfiguration(), handler, filters);
    }

    public EventClient(ClientConfig config, ConductorClientConfiguration clientConfiguration, ClientHandler handler, ClientFilter ... filters) {
        super(new ClientRequestHandler(config, handler, filters), clientConfiguration);
    }

    EventClient(ClientRequestHandler requestHandler) {
        super(requestHandler, null);
    }

    public void registerEventHandler(EventHandler eventHandler) {
        Validate.notNull((Object)eventHandler, (String)"Event Handler definition cannot be null", (Object[])new Object[0]);
        this.postForEntityWithRequestOnly("event", eventHandler);
    }

    public void updateEventHandler(EventHandler eventHandler) {
        Validate.notNull((Object)eventHandler, (String)"Event Handler definition cannot be null", (Object[])new Object[0]);
        this.put("event", null, eventHandler, new Object[0]);
    }

    public List<EventHandler> getEventHandlers(String event, boolean activeOnly) {
        Validate.notBlank((CharSequence)event, (String)"Event cannot be blank", (Object[])new Object[0]);
        return this.getForEntity("event/{event}", new Object[]{"activeOnly", activeOnly}, eventHandlerList, event);
    }

    public void unregisterEventHandler(String name) {
        Validate.notBlank((CharSequence)name, (String)"Event handler name cannot be blank", (Object[])new Object[0]);
        this.delete("event/{name}", name);
    }
}

