/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.serializers.UUIDSerializer;
import com.netflix.astyanax.util.TimeUUIDUtils;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.cassandra.db.marshal.TimeUUIDType;

public class TimeUUIDSerializer
extends UUIDSerializer {
    private static final TimeUUIDSerializer instance = new TimeUUIDSerializer();

    public static TimeUUIDSerializer get() {
        return instance;
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.TIMEUUIDTYPE;
    }

    @Override
    public ByteBuffer fromString(String str) {
        return TimeUUIDType.instance.fromString(str);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        long micros = TimeUUIDUtils.getMicrosTimeFromUUID((UUID)this.fromByteBuffer(byteBuffer.duplicate()));
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date(micros / 1000L));
    }

    @Override
    public ByteBuffer getNext(ByteBuffer byteBuffer) {
        UUID uuid = this.fromByteBuffer(byteBuffer.duplicate());
        return this.toByteBuffer(new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits() + 1L));
    }
}

