/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpressionBase;
import com.mysema.query.types.Visitor;
import java.util.Collections;
import java.util.List;

public class EnumConversion<T>
extends FactoryExpressionBase<T> {
    private static final long serialVersionUID = 7840412008633901748L;
    private final List<Expression<?>> exprs;
    private final Enum<?>[] values;

    public EnumConversion(Expression<T> expr) {
        super(expr.getType());
        this.exprs = Collections.singletonList(expr);
        try {
            this.values = (Enum[])expr.getType().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.exprs;
    }

    @Override
    public T newInstance(Object ... args) {
        if (args[0] != null) {
            if (args[0] instanceof String) {
                return Enum.valueOf(this.getType(), (String)args[0]);
            }
            if (args[0] instanceof Number) {
                return (T)this.values[((Number)args[0]).intValue()];
            }
            return (T)args[0];
        }
        return null;
    }
}

