/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.ExpressionException;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Visitor;
import com.mysema.util.BeanMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QBean<T>
extends ExpressionBase<T>
implements FactoryExpression<T> {
    private static final long serialVersionUID = -8210214512730989778L;
    private final ImmutableMap<String, Expression<?>> bindings;
    private final transient Map<String, Field> fields = new HashMap<String, Field>();
    private final boolean fieldAccess;

    private static ImmutableMap<String, Expression<?>> createBindings(Expression<?> ... args) {
        ImmutableMap.Builder rv = ImmutableMap.builder();
        for (Expression<?> expr : args) {
            if (expr instanceof Path) {
                Path path = (Path)expr;
                rv.put((Object)path.getMetadata().getName(), expr);
                continue;
            }
            if (expr instanceof Operation) {
                Operation operation = (Operation)expr;
                if (operation.getOperator() == Ops.ALIAS && operation.getArg(1) instanceof Path) {
                    Path path = (Path)operation.getArg(1);
                    rv.put((Object)path.getMetadata().getName(), operation.getArg(0));
                    continue;
                }
                throw new IllegalArgumentException("Unsupported expression " + expr);
            }
            throw new IllegalArgumentException("Unsupported expression " + expr);
        }
        return rv.build();
    }

    public QBean(Path<T> type, Expression<?> ... args) {
        this(type.getType(), false, args);
    }

    public QBean(Path<T> type, Map<String, ? extends Expression<?>> bindings) {
        this(type.getType(), false, bindings);
    }

    public QBean(Path<T> type, boolean fieldAccess, Expression<?> ... args) {
        this(type.getType(), fieldAccess, args);
    }

    public QBean(Path<T> type, boolean fieldAccess, Map<String, ? extends Expression<?>> bindings) {
        this(type.getType(), fieldAccess, bindings);
    }

    public QBean(Class<T> type, Map<String, ? extends Expression<?>> bindings) {
        this(type, false, bindings);
    }

    public QBean(Class<T> type, Expression<?> ... args) {
        this(type, false, args);
    }

    public QBean(Class<T> type, boolean fieldAccess, Expression<?> ... args) {
        this(type, fieldAccess, (Map<String, Expression<?>>)QBean.createBindings(args));
    }

    public QBean(Class<T> type, boolean fieldAccess, Map<String, ? extends Expression<?>> bindings) {
        super(type);
        this.bindings = ImmutableMap.copyOf(bindings);
        this.fieldAccess = fieldAccess;
        if (fieldAccess) {
            this.initFields();
        }
    }

    private void initFields() {
        for (String property : this.bindings.keySet()) {
            Class<Object> beanType = this.getType();
            while (!beanType.equals(Object.class)) {
                try {
                    Field field = beanType.getDeclaredField(property);
                    field.setAccessible(true);
                    this.fields.put(property, field);
                    beanType = Object.class;
                }
                catch (SecurityException e) {
                }
                catch (NoSuchFieldException e) {
                    beanType = beanType.getSuperclass();
                }
            }
        }
    }

    @Override
    public T newInstance(Object ... a) {
        try {
            Object rv = this.getType().newInstance();
            if (this.fieldAccess) {
                ImmutableList keys = this.bindings.keySet().asList();
                for (int i = 0; i < keys.size(); ++i) {
                    Object value = a[i];
                    if (value == null) continue;
                    this.fields.get(keys.get(i)).set(rv, value);
                }
            } else {
                BeanMap beanMap = new BeanMap(rv);
                ImmutableList keys = this.bindings.keySet().asList();
                for (int i = 0; i < keys.size(); ++i) {
                    Object value = a[i];
                    if (value == null) continue;
                    beanMap.put(keys.get(i), value);
                }
            }
            return rv;
        }
        catch (InstantiationException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }

    public Expression<T> as(Path<T> alias) {
        return OperationImpl.create(this.getType(), Ops.ALIAS, this, alias);
    }

    public Expression<T> as(String alias) {
        return this.as(new PathImpl(this.getType(), alias));
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QBean) {
            QBean c = (QBean)obj;
            return this.getArgs().equals(c.getArgs()) && this.getType().equals(c.getType());
        }
        return false;
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.bindings.values().asList();
    }
}

