/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.JoinExpression;
import com.mysema.query.QueryMetadata;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.Visitor;
import java.util.List;
import java.util.Map;

public final class ParamsVisitor
implements Visitor<Void, QueryMetadata> {
    public static final ParamsVisitor DEFAULT = new ParamsVisitor();

    private ParamsVisitor() {
    }

    @Override
    public Void visit(Constant<?> expr, QueryMetadata context) {
        return null;
    }

    @Override
    public Void visit(FactoryExpression<?> expr, QueryMetadata context) {
        this.visit(expr.getArgs(), context);
        return null;
    }

    @Override
    public Void visit(Operation<?> expr, QueryMetadata context) {
        this.visit(expr.getArgs(), context);
        return null;
    }

    @Override
    public Void visit(ParamExpression<?> expr, QueryMetadata context) {
        return null;
    }

    @Override
    public Void visit(Path<?> expr, QueryMetadata context) {
        return null;
    }

    @Override
    public Void visit(SubQueryExpression<?> expr, QueryMetadata context) {
        QueryMetadata md = expr.getMetadata();
        for (Map.Entry<ParamExpression<?>, Object> entry : md.getParams().entrySet()) {
            context.setParam(entry.getKey(), entry.getValue());
        }
        this.visit(md.getGroupBy(), context);
        this.visit(md.getHaving(), context);
        for (JoinExpression join : md.getJoins()) {
            this.visit(join.getTarget(), context);
            this.visit(join.getCondition(), context);
        }
        this.visit(md.getProjection(), context);
        this.visit(md.getWhere(), context);
        return null;
    }

    @Override
    public Void visit(TemplateExpression<?> expr, QueryMetadata context) {
        for (Object arg : expr.getArgs()) {
            if (!(arg instanceof Expression)) continue;
            ((Expression)arg).accept(this, context);
        }
        return null;
    }

    @Override
    private void visit(Expression<?> expr, QueryMetadata context) {
        if (expr != null) {
            expr.accept(this, context);
        }
    }

    @Override
    private void visit(List<Expression<?>> exprs, QueryMetadata context) {
        for (Expression<?> arg : exprs) {
            arg.accept(this, context);
        }
    }
}

