/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.collect.ImmutableList;
import com.mysema.query.Tuple;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Visitor;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class QTuple
extends ExpressionBase<Tuple>
implements FactoryExpression<Tuple> {
    private static final long serialVersionUID = -2640616030595420465L;
    private final ImmutableList<Expression<?>> args;

    public QTuple(Expression<?> ... args) {
        super(Tuple.class);
        this.args = ImmutableList.copyOf((Object[])args);
    }

    public QTuple(ImmutableList<Expression<?>> args) {
        super(Tuple.class);
        this.args = args;
    }

    public QTuple(Expression<?>[] ... args) {
        super(Tuple.class);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object[] objectArray : args) {
            builder.add(objectArray);
        }
        this.args = builder.build();
    }

    @Override
    public Tuple newInstance(Object ... a) {
        return new TupleImpl(a);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FactoryExpression) {
            FactoryExpression c = (FactoryExpression)obj;
            return this.args.equals(c.getArgs()) && this.getType().equals(c.getType());
        }
        return false;
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.args;
    }

    private final class TupleImpl
    implements Tuple {
        private final Object[] a;

        private TupleImpl(Object[] a) {
            this.a = a;
        }

        @Override
        public <T> T get(int index, Class<T> type) {
            return (T)this.a[index];
        }

        @Override
        public <T> T get(Expression<T> expr) {
            int index = QTuple.this.args.indexOf(expr);
            return (T)(index != -1 ? this.a[index] : null);
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object[] toArray() {
            return this.a;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Tuple) {
                return Arrays.equals(this.a, ((Tuple)obj).toArray());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.a);
        }

        public String toString() {
            return Arrays.toString(this.a);
        }
    }
}

