/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.group;

import com.mysema.query.ResultTransformer;
import com.mysema.query.group.Group;
import com.mysema.query.group.GroupBy;
import com.mysema.query.group.GroupExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GroupByBuilder<K> {
    private final Expression<K> key;

    public GroupByBuilder(Expression<K> key) {
        this.key = key;
    }

    public ResultTransformer<Map<K, Group>> as(Expression<?> ... expressions) {
        return new GroupBy(this.key, expressions);
    }

    public <V> ResultTransformer<Map<K, V>> as(Expression<V> expression) {
        final Expression<V> lookup = expression instanceof GroupExpression ? ((GroupExpression)expression).getExpression() : expression;
        return new GroupBy<K, V>(this.key, new Expression[]{expression}){

            @Override
            protected Map<K, V> transform(Map<K, Group> groups) {
                LinkedHashMap results = new LinkedHashMap((int)Math.ceil((double)groups.size() / 0.75), 0.75f);
                for (Map.Entry entry : groups.entrySet()) {
                    results.put(entry.getKey(), entry.getValue().getOne(lookup));
                }
                return results;
            }
        };
    }

    public <V> ResultTransformer<Map<K, V>> as(FactoryExpression<V> expression) {
        final FactoryExpression<V> transformation = FactoryExpressionUtils.wrap(expression);
        List<Expression<?>> args = transformation.getArgs();
        return new GroupBy<K, V>(this.key, args.toArray(new Expression[args.size()])){

            @Override
            protected Map<K, V> transform(Map<K, Group> groups) {
                LinkedHashMap results = new LinkedHashMap((int)Math.ceil((double)groups.size() / 0.75), 0.75f);
                for (Map.Entry entry : groups.entrySet()) {
                    results.put(entry.getKey(), this.transform(entry.getValue()));
                }
                return results;
            }

            protected V transform(Group group) {
                ArrayList args = new ArrayList(this.groupExpressions.size() - 1);
                for (int i = 1; i < this.groupExpressions.size(); ++i) {
                    args.add(group.getGroup((GroupExpression)this.groupExpressions.get(i)));
                }
                return transformation.newInstance(args.toArray());
            }
        };
    }
}

