/*
 * Decompiled with CFR 0.152.
 */
package mydataharbor.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtil {
    private static final Logger log = LoggerFactory.getLogger(NetworkUtil.class);

    public static String getIpAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            log.error("ip\u5730\u5740\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("ip\u5730\u5740\u83b7\u53d6\u5931\u8d25", e);
        }
        throw new RuntimeException("\u83b7\u53d6\u4e0d\u5230\u53ef\u7528\u7684ip");
    }
}

