/*
 * Decompiled with CFR 0.152.
 */
package mydataharbor.plugin.api.node;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import mydataharbor.plugin.api.exception.RenameException;
import mydataharbor.plugin.api.node.JvmSystemInfo;
import mydataharbor.plugin.api.plugin.PluginServerConfig;
import mydataharbor.util.NetworkUtil;
import mydataharbor.util.RandomStringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInfo
extends JvmSystemInfo {
    private static final Logger log = LoggerFactory.getLogger(NodeInfo.class);
    private String nodeName;
    private String ip;
    private Integer port;
    private String hostName;
    private long startTime = System.currentTimeMillis();
    private String runJarPath;
    private boolean staticNodeName = false;
    private String group;
    private AtomicLong taskNum = new AtomicLong();
    private boolean leader = false;
    private volatile boolean leaderElected = false;
    private String version;

    public NodeInfo() {
    }

    public void setLeader(boolean leader) {
        this.leader = leader;
        this.leaderElected = true;
    }

    public NodeInfo(PluginServerConfig pluginServerConfig) {
        if (StringUtils.isBlank((CharSequence)pluginServerConfig.getNodeName())) {
            this.nodeName = RandomStringUtil.generateRandomStr(10);
        } else {
            this.staticNodeName = true;
            this.nodeName = pluginServerConfig.getNodeName();
        }
        this.group = pluginServerConfig.getGroup();
        this.port = pluginServerConfig.getPort();
        this.ip = StringUtils.isNotBlank((CharSequence)pluginServerConfig.getIp()) ? pluginServerConfig.getIp() : NetworkUtil.getIpAddress();
        try {
            InetAddress ia = InetAddress.getLocalHost();
            this.hostName = ia.getHostName();
        }
        catch (UnknownHostException e) {
            log.error("\u83b7\u53d6\u4e3b\u673a\u540d\u5931\u8d25", (Throwable)e);
        }
    }

    public void rename() throws RenameException {
        if (this.staticNodeName) {
            throw new RenameException("\u7528\u6237\u91c7\u7528\u9759\u6001\u8282\u70b9\u540d\u914d\u7f6e\uff0c\u65e0\u6cd5\u91cd\u65b0\u547d\u540d");
        }
        this.nodeName = RandomStringUtil.generateRandomStr(10);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeInfo nodeInfo = (NodeInfo)o;
        return Objects.equals(this.nodeName, nodeInfo.nodeName) && Objects.equals(this.ip, nodeInfo.ip) && Objects.equals(this.port, nodeInfo.port) && Objects.equals(this.hostName, nodeInfo.hostName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nodeName, this.ip, this.port, this.hostName);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getIp() {
        return this.ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getRunJarPath() {
        return this.runJarPath;
    }

    public boolean isStaticNodeName() {
        return this.staticNodeName;
    }

    public String getGroup() {
        return this.group;
    }

    public AtomicLong getTaskNum() {
        return this.taskNum;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public boolean isLeaderElected() {
        return this.leaderElected;
    }

    public String getVersion() {
        return this.version;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setRunJarPath(String runJarPath) {
        this.runJarPath = runJarPath;
    }

    public void setStaticNodeName(boolean staticNodeName) {
        this.staticNodeName = staticNodeName;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setTaskNum(AtomicLong taskNum) {
        this.taskNum = taskNum;
    }

    public void setLeaderElected(boolean leaderElected) {
        this.leaderElected = leaderElected;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "NodeInfo(nodeName=" + this.getNodeName() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", hostName=" + this.getHostName() + ", startTime=" + this.getStartTime() + ", runJarPath=" + this.getRunJarPath() + ", staticNodeName=" + this.isStaticNodeName() + ", group=" + this.getGroup() + ", taskNum=" + this.getTaskNum() + ", leader=" + this.isLeader() + ", leaderElected=" + this.isLeaderElected() + ", version=" + this.getVersion() + ")";
    }
}

