/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.dialect;

import com.mybatisflex.core.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class JdbcTypeMapping {
    private static final Map<String, String> mapping = new HashMap<String, String>();
    private static JdbcTypeMapper mapper;

    private JdbcTypeMapping() {
    }

    public static void registerMapping(Class<?> from, Class<?> to) {
        JdbcTypeMapping.registerMapping(from.getName(), to.getName());
    }

    public static void registerMapping(String from, String to) {
        mapping.put(from, to);
    }

    public static Map<String, String> getMapping() {
        return mapping;
    }

    public static JdbcTypeMapper getMapper() {
        return mapper;
    }

    public static void setMapper(JdbcTypeMapper mapper) {
        JdbcTypeMapping.mapper = mapper;
    }

    public static void registerDateTypes() {
        JdbcTypeMapping.registerMapping("java.sql.Time", "java.util.Date");
        JdbcTypeMapping.registerMapping("java.sql.Timestamp", "java.util.Date");
        JdbcTypeMapping.registerMapping("java.time.LocalDateTime", "java.util.Date");
        JdbcTypeMapping.registerMapping("java.time.LocalDate", "java.util.Date");
    }

    static String getType(String jdbcType, int length) {
        if (mapper != null) {
            return mapper.getType(jdbcType, length);
        }
        String registered = mapping.get(jdbcType);
        return StringUtil.isNotBlank((String)registered) ? registered : jdbcType;
    }

    static {
        JdbcTypeMapping.registerMapping("[B", "byte[]");
        JdbcTypeMapping.registerMapping("oracle.jdbc.OracleBlob", "byte[]");
    }

    public static interface JdbcTypeMapper {
        public String getType(String var1, int var2);
    }
}

