/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.kits;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import com.mparticle.MParticle;
import com.mparticle.consent.CCPAConsent;
import com.mparticle.consent.ConsentState;
import com.mparticle.consent.GDPRConsent;
import com.mparticle.identity.MParticleUser;
import com.mparticle.internal.Logger;
import com.mparticle.kits.FilteredIdentityApiRequest;
import com.mparticle.kits.KitIntegration;
import com.mparticle.kits.ReportingMessage;
import com.onetrust.otpublishers.headless.Public.OTPublishersHeadlessSDK;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u0003:;<B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J*\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u001c\u0010#\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u001c\u0010$\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010%\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J#\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\b\u0010'\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b(J\r\u0010)\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b*J\u0018\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u000e2\b\u0010-\u001a\u0004\u0018\u00010\u000eJ!\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u000f2\b\u00100\u001a\u0004\u0018\u000101H\u0000\u00a2\u0006\u0004\b2\u00103J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u00105\u001a\u000206H\u0016J)\u00107\u001a\u00020\u00172\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u00108\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b9R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/mparticle/kits/OneTrustKit;", "Lcom/mparticle/kits/KitIntegration;", "Lcom/mparticle/kits/KitIntegration$IdentityListener;", "()V", "consentUpdatedReceiver", "Landroid/content/BroadcastReceiver;", "oneTrustSdk", "Lcom/onetrust/otpublishers/headless/Public/OTPublishersHeadlessSDK;", "getOneTrustSdk", "()Lcom/onetrust/otpublishers/headless/Public/OTPublishersHeadlessSDK;", "oneTrustSdk$delegate", "Lkotlin/Lazy;", "purposeConsentMapping", "", "", "Lcom/mparticle/kits/OneTrustKit$OneTrustConsent;", "venderGeneralConsentMapping", "venderGoogleConsentMapping", "venderIABConsentMapping", "getInstance", "", "getName", "onIdentifyCompleted", "", "mParticleUser", "Lcom/mparticle/identity/MParticleUser;", "identityApiRequest", "Lcom/mparticle/kits/FilteredIdentityApiRequest;", "onKitCreate", "", "Lcom/mparticle/kits/ReportingMessage;", "settings", "context", "Landroid/content/Context;", "onLoginCompleted", "onLogoutCompleted", "onModifyCompleted", "onUserIdentified", "parseConsentMapping", "json", "parseConsentMapping$android_onetrust_kit_release", "processOneTrustConsents", "processOneTrustConsents$android_onetrust_kit_release", "saveToDisk", "key", "mappingData", "setConsentStateEvent", "consentMapping", "status", "", "setConsentStateEvent$android_onetrust_kit_release", "(Lcom/mparticle/kits/OneTrustKit$OneTrustConsent;Ljava/lang/Integer;)V", "setOptOut", "optedOut", "", "updateVendorConsents", "mode", "updateVendorConsents$android_onetrust_kit_release", "Companion", "ConsentRegulation", "OneTrustConsent", "android-onetrust-kit_release"})
public final class OneTrustKit
extends KitIntegration
implements KitIntegration.IdentityListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BroadcastReceiver consentUpdatedReceiver = new BroadcastReceiver(this){
        final /* synthetic */ OneTrustKit this$0;
        {
            this.this$0 = $receiver;
        }

        public void onReceive(@Nullable Context context, @Nullable Intent intent) {
            this.this$0.processOneTrustConsents$android_onetrust_kit_release();
        }
    };
    @NotNull
    private final Lazy oneTrustSdk$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OTPublishersHeadlessSDK>(this){
        final /* synthetic */ OneTrustKit this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final OTPublishersHeadlessSDK invoke() {
            return new OTPublishersHeadlessSDK(this.this$0.getContext());
        }
    }));
    private Map<String, OneTrustConsent> purposeConsentMapping;
    private Map<String, OneTrustConsent> venderGeneralConsentMapping;
    private Map<String, OneTrustConsent> venderIABConsentMapping;
    private Map<String, OneTrustConsent> venderGoogleConsentMapping;
    @NotNull
    private static final String MobileConsentGroups = "mobileConsentGroups";
    @NotNull
    private static final String IabConsentGroups = "vendorIABConsentGroups";
    @NotNull
    private static final String GoogleConsentGroups = "vendorGoogleConsentGroups";
    @NotNull
    private static final String GeneralConsentGroups = "vendorGeneralConsentGroups";
    @NotNull
    private static final String MappingSharedPrefsKey = "OT_mP_Mapping";
    @NotNull
    private static final String IABSharedPrefsKey = "OT_Vendor_IAB_mP_Mapping";
    @NotNull
    private static final String GoogleSharedPrefsKey = "OT_Vendor_Google_mP_Mapping";
    @NotNull
    private static final String GeneralSharedPrefsKey = "OT_Vendor_General_mP_Mapping";
    @NotNull
    public static final String CCPAPurposeValue = "data_sale_opt_out";

    private final OTPublishersHeadlessSDK getOneTrustSdk() {
        Lazy lazy = this.oneTrustSdk$delegate;
        return (OTPublishersHeadlessSDK)lazy.getValue();
    }

    @NotNull
    public String getName() {
        return "OneTrust";
    }

    @NotNull
    public List<ReportingMessage> setOptOut(boolean optedOut) {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<ReportingMessage> onKitCreate(@NotNull Map<String, String> settings, @NotNull Context context) {
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String mobileMappingValues = settings.get(MobileConsentGroups);
        String mpVendorIABConsentMapping = settings.get(IabConsentGroups);
        String mpVendorGoogleConsentMapping = settings.get(GoogleConsentGroups);
        String mpVendorGeneralConsentMapping = settings.get(GeneralConsentGroups);
        this.saveToDisk(MappingSharedPrefsKey, mobileMappingValues);
        this.saveToDisk(IABSharedPrefsKey, mpVendorIABConsentMapping);
        this.saveToDisk(GoogleSharedPrefsKey, mpVendorGoogleConsentMapping);
        this.saveToDisk(GeneralSharedPrefsKey, mpVendorGeneralConsentMapping);
        this.purposeConsentMapping = this.parseConsentMapping$android_onetrust_kit_release(mobileMappingValues);
        this.venderIABConsentMapping = this.parseConsentMapping$android_onetrust_kit_release(mpVendorIABConsentMapping);
        this.venderGoogleConsentMapping = this.parseConsentMapping$android_onetrust_kit_release(mpVendorGoogleConsentMapping);
        this.venderGeneralConsentMapping = this.parseConsentMapping$android_onetrust_kit_release(mpVendorGeneralConsentMapping);
        Map<String, OneTrustConsent> map = this.venderIABConsentMapping;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"venderIABConsentMapping");
            map = null;
        }
        this.updateVendorConsents$android_onetrust_kit_release(map, "iab");
        Map<String, OneTrustConsent> map2 = this.venderGoogleConsentMapping;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"venderGoogleConsentMapping");
            map2 = null;
        }
        this.updateVendorConsents$android_onetrust_kit_release(map2, "google");
        Map<String, OneTrustConsent> map3 = this.venderGeneralConsentMapping;
        if (map3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"venderGeneralConsentMapping");
            map3 = null;
        }
        this.updateVendorConsents$android_onetrust_kit_release(map3, "general");
        context.registerReceiver(this.consentUpdatedReceiver, new IntentFilter("OTConsentUpdated"));
        return CollectionsKt.emptyList();
    }

    @NotNull
    public Object getInstance() {
        return this.getOneTrustSdk();
    }

    public final void processOneTrustConsents$android_onetrust_kit_release() {
        block4: {
            Unit unit;
            MParticle mParticle = MParticle.getInstance();
            if (mParticle != null && (mParticle = mParticle.Identity()) != null && (mParticle = mParticle.getCurrentUser()) != null) {
                MParticle user = mParticle;
                boolean bl = false;
                Map<String, OneTrustConsent> map = this.purposeConsentMapping;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"purposeConsentMapping");
                    map = null;
                }
                Map<String, OneTrustConsent> $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, OneTrustConsent>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, OneTrustConsent> element$iv;
                    Map.Entry<String, OneTrustConsent> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    int status = this.getOneTrustSdk().getConsentStatusForGroupId(entry.getKey());
                    if (status == -1) continue;
                    this.setConsentStateEvent$android_onetrust_kit_release(entry.getValue(), status);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block4;
            OneTrustKit $this$processOneTrustConsents_u24lambda_u242 = this;
            boolean bl = false;
            String[] stringArray = new String[]{"MParticle user is not set"};
            Logger.warning((String[])stringArray);
        }
    }

    public final void saveToDisk(@NotNull String key, @Nullable String mappingData) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Context context = this.getContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.onetrust.consent.sdk", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, mappingData);
        editor.apply();
    }

    public final void updateVendorConsents$android_onetrust_kit_release(@NotNull Map<String, OneTrustConsent> consentMapping, @NotNull String mode) {
        Intrinsics.checkNotNullParameter(consentMapping, (String)"consentMapping");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Iterator<Map.Entry<String, OneTrustConsent>> $this$forEach$iv = consentMapping.entrySet().iterator();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, OneTrustConsent>> iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            Map.Entry<String, OneTrustConsent> element$iv;
            Map.Entry<String, OneTrustConsent> entry = element$iv = iterator.next();
            boolean bl = false;
            String consentKey = entry.getKey();
            OneTrustConsent mapping = entry.getValue();
            try {
                JSONObject jSONObject = this.getOneTrustSdk().getVendorDetails(mode, consentKey);
                if (jSONObject == null) continue;
                JSONObject details = jSONObject;
                boolean bl2 = false;
                String string = details.optString("consent");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"details.optString(\"consent\")");
                Integer status = StringsKt.toIntOrNull((String)string);
                this.setConsentStateEvent$android_onetrust_kit_release(mapping, status);
            }
            catch (NumberFormatException ex) {
                String[] stringArray = new String[]{"unable to fetch vendor details for " + mode + ": " + consentKey};
                Logger.warning((Throwable)ex, (String[])stringArray);
            }
        }
    }

    public final void setConsentStateEvent$android_onetrust_kit_release(@NotNull OneTrustConsent consentMapping, @Nullable Integer status) {
        Intrinsics.checkNotNullParameter((Object)consentMapping, (String)"consentMapping");
        MParticle mParticle = MParticle.getInstance();
        if (mParticle == null || (mParticle = mParticle.Identity()) == null || (mParticle = mParticle.getCurrentUser()) == null) {
            String[] stringArray = new String[]{"current user is not present"};
            Logger.warning((String[])stringArray);
            Unit it = Unit.INSTANCE;
            boolean bl = false;
            return;
        }
        MParticle user = mParticle;
        Integer n = status;
        int n2 = 1;
        boolean consented = n != null && n == n2;
        long time = System.currentTimeMillis();
        ConsentState it = user.getConsentState();
        boolean bl = false;
        ConsentState.Builder builder = ConsentState.withConsentState((ConsentState)it);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"user.consentState.let { \u2026te.withConsentState(it) }");
        ConsentState.Builder consentState = builder;
        switch (WhenMappings.$EnumSwitchMapping$0[consentMapping.getRegulation().ordinal()]) {
            case 1: {
                consentState.addGDPRConsentState(consentMapping.getPurpose(), GDPRConsent.builder((boolean)consented).timestamp(Long.valueOf(time)).build());
                break;
            }
            case 2: {
                consentState.setCCPAConsentState(CCPAConsent.builder((boolean)consented).timestamp(Long.valueOf(time)).build());
            }
        }
        user.setConsentState(consentState.build());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, OneTrustConsent> parseConsentMapping$android_onetrust_kit_release(@Nullable String json) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        Object object;
        Object object2 = json;
        if (object2 == null || object2.length() == 0) {
            return MapsKt.emptyMap();
        }
        try {
            Iterator $this$mapTo$iv$iv2;
            void $this$map$iv;
            JSONArray jsonArray = new JSONArray(json);
            boolean bl = false;
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)jsonArray.length());
            boolean $i$f$map = false;
            void var7_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            object = $this$mapTo$iv$iv2.iterator();
            while (object.hasNext()) {
                JSONObject jSONObject;
                void index;
                JSONObject jSONObject2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)object).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                JSONObject jSONObject3 = jSONObject2 = jsonArray.optJSONObject((int)index);
                if (jSONObject3 == null) {
                    jSONObject = new JSONObject();
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)jSONObject3, (String)"jsonArray.optJSONObject(index) ?: JSONObject()");
                    jSONObject = jSONObject2;
                }
                collection.add(jSONObject);
            }
            object2 = (List)destination$iv$iv;
        }
        catch (JSONException jse) {
            String[] bl = new String[]{"OneTrust parsing error"};
            Logger.warning((Throwable)jse, (String[])bl);
            object2 = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = (Iterable)object2;
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair;
            void it;
            JSONObject $i$f$mapTo2 = (JSONObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            String cookieValue = it.optString("value");
            String purpose = it.optString("map");
            ConsentRegulation regulation = Intrinsics.areEqual((Object)purpose, (Object)CCPAPurposeValue) ? ConsentRegulation.CCPA : ConsentRegulation.GDPR;
            String[] stringArray = (String[])cookieValue;
            if ((stringArray == null || stringArray.length() == 0) && ((stringArray = (CharSequence)purpose) == null || stringArray.length() == 0)) {
                stringArray = new String[]{"Consent Object is missing value and map: " + (Object)((Object)this)};
                Logger.warning((String[])stringArray);
                pair = null;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)purpose, (String)"purpose");
                pair = TuplesKt.to((Object)cookieValue, (Object)new OneTrustConsent(purpose, regulation));
            }
            collection.add(pair);
        }
        Iterable $this$associate$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv2;
            Pair it = (Pair)element$iv$iv;
            boolean bl4 = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            object.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    public void onIdentifyCompleted(@Nullable MParticleUser mParticleUser, @Nullable FilteredIdentityApiRequest identityApiRequest) {
    }

    public void onLoginCompleted(@Nullable MParticleUser mParticleUser, @Nullable FilteredIdentityApiRequest identityApiRequest) {
    }

    public void onLogoutCompleted(@Nullable MParticleUser mParticleUser, @Nullable FilteredIdentityApiRequest identityApiRequest) {
    }

    public void onModifyCompleted(@Nullable MParticleUser mParticleUser, @Nullable FilteredIdentityApiRequest identityApiRequest) {
    }

    public void onUserIdentified(@Nullable MParticleUser mParticleUser) {
        this.processOneTrustConsents$android_onetrust_kit_release();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/mparticle/kits/OneTrustKit$ConsentRegulation;", "", "(Ljava/lang/String;I)V", "GDPR", "CCPA", "android-onetrust-kit_release"})
    public static final class ConsentRegulation
    extends Enum<ConsentRegulation> {
        public static final /* enum */ ConsentRegulation GDPR = new ConsentRegulation();
        public static final /* enum */ ConsentRegulation CCPA = new ConsentRegulation();
        private static final /* synthetic */ ConsentRegulation[] $VALUES;

        public static ConsentRegulation[] values() {
            return (ConsentRegulation[])$VALUES.clone();
        }

        public static ConsentRegulation valueOf(String value) {
            return Enum.valueOf(ConsentRegulation.class, value);
        }

        static {
            $VALUES = consentRegulationArray = new ConsentRegulation[]{ConsentRegulation.GDPR, ConsentRegulation.CCPA};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/mparticle/kits/OneTrustKit$OneTrustConsent;", "", "purpose", "", "regulation", "Lcom/mparticle/kits/OneTrustKit$ConsentRegulation;", "(Ljava/lang/String;Lcom/mparticle/kits/OneTrustKit$ConsentRegulation;)V", "getPurpose", "()Ljava/lang/String;", "getRegulation", "()Lcom/mparticle/kits/OneTrustKit$ConsentRegulation;", "android-onetrust-kit_release"})
    public static final class OneTrustConsent {
        @NotNull
        private final String purpose;
        @NotNull
        private final ConsentRegulation regulation;

        public OneTrustConsent(@NotNull String purpose, @NotNull ConsentRegulation regulation) {
            Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
            Intrinsics.checkNotNullParameter((Object)((Object)regulation), (String)"regulation");
            this.purpose = purpose;
            this.regulation = regulation;
        }

        @NotNull
        public final String getPurpose() {
            return this.purpose;
        }

        @NotNull
        public final ConsentRegulation getRegulation() {
            return this.regulation;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/mparticle/kits/OneTrustKit$Companion;", "", "()V", "CCPAPurposeValue", "", "GeneralConsentGroups", "GeneralSharedPrefsKey", "GoogleConsentGroups", "GoogleSharedPrefsKey", "IABSharedPrefsKey", "IabConsentGroups", "MappingSharedPrefsKey", "MobileConsentGroups", "android-onetrust-kit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConsentRegulation.values().length];
            try {
                nArray[ConsentRegulation.GDPR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsentRegulation.CCPA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

