/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class MockFilterChain
implements FilterChain {
    private List filters = new ArrayList();
    private Servlet servlet;
    private Iterator iterator;
    private List requestList = new ArrayList();
    private List responseList = new ArrayList();

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.requestList.add(request);
        this.responseList.add(response);
        if (null == this.iterator) {
            this.iterator = this.filters.iterator();
        }
        if (this.iterator.hasNext()) {
            Filter nextFilter = (Filter)this.iterator.next();
            nextFilter.doFilter(request, response, (FilterChain)this);
        } else {
            this.reset();
            if (null == this.servlet) {
                return;
            }
            this.servlet.service(request, response);
        }
    }

    public void reset() {
        this.iterator = null;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void addFilter(Class filterClass) {
        if (!Filter.class.isAssignableFrom(filterClass)) {
            throw new IllegalArgumentException("filterClass must be an instance of javax.servlet.Filter");
        }
        try {
            this.filters.add(filterClass.newInstance());
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public void release() {
        this.filters.clear();
        this.setServlet(null);
        this.reset();
    }

    public List getRequestList() {
        return Collections.unmodifiableList(this.requestList);
    }

    public List getResponseList() {
        return Collections.unmodifiableList(this.responseList);
    }

    public ServletRequest getLastRequest() {
        if (this.requestList.isEmpty()) {
            return null;
        }
        return (ServletRequest)this.requestList.get(this.requestList.size() - 1);
    }

    public ServletResponse getLastResponse() {
        if (this.responseList.isEmpty()) {
            return null;
        }
        return (ServletResponse)this.responseList.get(this.responseList.size() - 1);
    }
}

