/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter.mockrunner;

import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.mockrunner.BinaryExpression;
import org.activemq.filter.mockrunner.BooleanExpression;

public abstract class LogicExpression
extends BinaryExpression
implements BooleanExpression {
    public static BooleanExpression createOR(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            @Override
            public Object evaluate(Message message) throws JMSException {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv != null && lv.booleanValue()) {
                    return Boolean.TRUE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            @Override
            public String getExpressionSymbol() {
                return "OR";
            }
        };
    }

    public static BooleanExpression createAND(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            @Override
            public Object evaluate(Message message) throws JMSException {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv == null) {
                    return null;
                }
                if (!lv.booleanValue()) {
                    return Boolean.FALSE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            @Override
            public String getExpressionSymbol() {
                return "AND";
            }
        };
    }

    public LogicExpression(BooleanExpression left, BooleanExpression right) {
        super(left, right);
    }

    @Override
    public abstract Object evaluate(Message var1) throws JMSException;
}

