/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockMessageConsumer;
import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockQueueSession;
import com.mockrunner.mock.jms.MockSession;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueReceiver;

public class MockQueueReceiver
extends MockMessageConsumer
implements QueueReceiver {
    private MockSession session;
    private MockQueue queue;

    public MockQueueReceiver(MockConnection connection, MockQueueSession session, MockQueue queue) {
        this(connection, session, queue, null);
    }

    public MockQueueReceiver(MockConnection connection, MockSession session, MockQueue queue, String messageSelector) {
        super(connection, messageSelector);
        this.session = session;
        this.queue = queue;
    }

    public Queue getQueue() throws JMSException {
        this.getConnection().throwJMSException();
        return this.queue;
    }

    public Message receiveNoWait() throws JMSException {
        this.getConnection().throwJMSException();
        if (this.isClosed()) {
            throw new JMSException("Receiver is closed");
        }
        if (this.queue.isEmpty()) {
            return null;
        }
        Message message = !this.getConnection().getConfigurationManager().getUseMessageSelectors() || null == this.getMessageFilter() ? this.queue.getMessage() : this.queue.getMatchingMessage(this.getMessageFilter());
        if (null == message) {
            return null;
        }
        if (this.session.isAutoAcknowledge()) {
            message.acknowledge();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void waitOnMessage(long timeout) {
        try {
            MockQueue mockQueue = this.queue;
            synchronized (mockQueue) {
                this.queue.wait(timeout);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

