/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jms.MockMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public class MockObjectMessage
extends MockMessage
implements ObjectMessage {
    private Serializable object;

    public MockObjectMessage() {
        this(null);
    }

    public MockObjectMessage(Serializable object) {
        this.object = object;
    }

    public void setObject(Serializable object) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.object = object;
    }

    public Serializable getObject() throws JMSException {
        return this.object;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.object = null;
    }

    public boolean equals(Object otherObject) {
        if (null == otherObject) {
            return false;
        }
        if (!(otherObject instanceof MockObjectMessage)) {
            return false;
        }
        MockObjectMessage otherMessage = (MockObjectMessage)otherObject;
        if (null == this.object && null == otherMessage.object) {
            return true;
        }
        return this.object.equals(otherMessage.object);
    }

    public int hashCode() {
        if (null == this.object) {
            return 0;
        }
        return this.object.hashCode();
    }

    @Override
    public Object clone() {
        MockObjectMessage message = (MockObjectMessage)super.clone();
        try {
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutStream = new ObjectOutputStream(byteOutStream);
            objectOutStream.writeObject(this.object);
            objectOutStream.flush();
            ByteArrayInputStream byteInStream = new ByteArrayInputStream(byteOutStream.toByteArray());
            ObjectInputStream objectInStream = new ObjectInputStream(byteInStream);
            message.object = (Serializable)objectInStream.readObject();
            return message;
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.object;
    }
}

