/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.regexp;

import com.mockrunner.util.regexp.Perl5PatternMatcher;
import com.mockrunner.util.regexp.SimplePatternMatcher;

public interface PatternMatcher
extends Comparable<PatternMatcher> {
    public String type();

    public String pattern();

    public boolean matches(String var1);

    public int hashCode();

    public boolean equals(Object var1);

    public static abstract class Base
    implements PatternMatcher {
        protected final String originalPattern;

        public Base(String pattern) {
            this.originalPattern = pattern;
        }

        @Override
        public int compareTo(PatternMatcher o) {
            return this.pattern().compareTo(o.pattern());
        }

        @Override
        public int hashCode() {
            return this.pattern().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof PatternMatcher) {
                PatternMatcher other = (PatternMatcher)obj;
                return this.pattern().equals(other.pattern()) && this.type().equals(other.type());
            }
            return false;
        }

        @Override
        public String pattern() {
            return this.originalPattern;
        }
    }

    public static class Factories {
        public static Factory from(boolean caseSensitive, boolean exactMatch, boolean useRegularExpressions) {
            if (exactMatch) {
                return new SimplePatternMatcher.Factory(caseSensitive, true);
            }
            if (useRegularExpressions) {
                return new Perl5PatternMatcher.Factory(caseSensitive);
            }
            return new SimplePatternMatcher.Factory(caseSensitive, exactMatch);
        }
    }

    public static interface Factory {
        public PatternMatcher create(String var1);
    }
}

