/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.spring4.extension.function.bindingresult;

import com.mitchellbosecke.pebble.spring4.extension.function.bindingresult.BaseBindingResultFunction;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public class GetFieldErrorsFunction
extends BaseBindingResultFunction {
    public static final String FUNCTION_NAME = "getFieldErrors";
    private final MessageSource messageSource;

    public GetFieldErrorsFunction(MessageSource messageSource) {
        super("formName", "fieldName");
        if (messageSource == null) {
            throw new IllegalArgumentException("In order to use the GetErrorsFunction, a bean of type " + MessageSource.class.getName() + " must be configured");
        }
        this.messageSource = messageSource;
    }

    public Object execute(Map<String, Object> args) {
        ArrayList<String> results = new ArrayList<String>();
        String formName = (String)args.get("formName");
        String field = (String)args.get("fieldName");
        if (field == null) {
            throw new IllegalArgumentException("Field parameter is required in GetFieldErrorsFunction");
        }
        EvaluationContext context = (EvaluationContext)args.get("_context");
        Locale locale = context.getLocale();
        BindingResult bindingResult = this.getBindingResult(formName, context);
        if (bindingResult != null) {
            for (FieldError error : bindingResult.getFieldErrors(field)) {
                String msg = this.messageSource.getMessage(error.getCode(), error.getArguments(), error.getDefaultMessage(), locale);
                if (msg == null) continue;
                results.add(msg);
            }
        }
        return results;
    }
}

