/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services.textembedding;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR"})
public class Embedding {
    private final List<Float> vector;
    private static final Embedding EMPTY = new Embedding();

    public static Embedding empty() {
        return EMPTY;
    }

    public Embedding() {
        this.vector = Collections.emptyList();
    }

    public Embedding(@Nonnull List<Float> vector) {
        Objects.requireNonNull(vector);
        this.vector = Collections.unmodifiableList(vector);
    }

    public Embedding(@Nonnull float[] vector) {
        Objects.requireNonNull(vector);
        ArrayList<Float> list = new ArrayList<Float>(vector.length);
        for (float f : vector) {
            list.add(Float.valueOf(f));
        }
        this.vector = Collections.unmodifiableList(list);
    }

    public List<Float> getVector() {
        return Collections.unmodifiableList(this.vector);
    }
}

