/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services.audio;

import com.microsoft.semantickernel.exceptions.SKException;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;

public class AudioContent {
    private final byte[] data;
    @Nullable
    private final String modelId;

    public AudioContent(byte[] data, @Nullable String modelId) {
        this.data = Arrays.copyOf(data, data.length);
        this.modelId = modelId;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Nullable
    public String getModelId() {
        return this.modelId;
    }

    @Nullable
    public String getInnerContent() {
        return null;
    }

    @Nullable
    public Map<String, Object> getMetadata() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private byte[] data = null;
        @Nullable
        private String modelId = null;

        public Builder withData(byte[] data) {
            this.data = Arrays.copyOf(data, data.length);
            return this;
        }

        public Builder withModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public AudioContent build() {
            if (this.data == null) {
                throw new SKException("Data is required");
            }
            if (this.modelId == null) {
                throw new SKException("Model ID is required");
            }
            return new AudioContent(this.data, this.modelId);
        }
    }
}

